/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.BaseFileChooserUI;
import com.frostwire.gui.theme.ThemeMediator;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class SkinFileChooserUI
extends BaseFileChooserUI {
    private final SubstanceFileView fileView = new SubstanceFileView();

    public SkinFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    public static ComponentUI createUI(JComponent comp) {
        ThemeMediator.testComponentCreationThreadingViolation();
        return new SkinFileChooserUI((JFileChooser)comp);
    }

    @Override
    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    private class SubstanceFileView
    extends BasicFileChooserUI.BasicFileView {
        private final Map<String, Icon> pathIconCache;

        private SubstanceFileView() {
            super(SkinFileChooserUI.this);
            this.pathIconCache = new HashMap<String, Icon>();
        }

        @Override
        public Icon getCachedIcon(File f) {
            return this.pathIconCache.get(f.getPath());
        }

        @Override
        public Icon getIcon(File f) {
            Icon icon = this.getCachedIcon(f);
            if (icon != null) {
                return icon;
            }
            try {
                icon = this.getDefaultIcon(f);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.cacheIcon(f, icon);
            return icon;
        }

        @Override
        public void cacheIcon(File f, Icon icon) {
            this.pathIconCache.put(f.getPath(), icon);
        }

        @Override
        public void clearIconCache() {
            this.pathIconCache.clear();
        }

        public Icon getDefaultIcon(File f) {
            FileSystemView fileSystemView;
            Icon icon = null;
            JFileChooser fileChooser = SkinFileChooserUI.this.getFileChooser();
            if (fileChooser != null && (fileSystemView = fileChooser.getFileSystemView()) != null) {
                icon = fileSystemView.getSystemIcon(f);
            }
            return icon;
        }
    }
}

