/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.DefaultShellFolder;
import com.frostwire.gui.theme.ShellFolder;
import com.frostwire.gui.theme.ShellFolderColumnInfo;
import java.io.File;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

class ShellFolderManager {
    private static final String COLUMN_NAME = "FileChooser.fileNameHeaderText";
    private static final String COLUMN_SIZE = "FileChooser.fileSizeHeaderText";
    private static final String COLUMN_DATE = "FileChooser.fileDateHeaderText";
    private final Comparator<Object> fileComparator = new Comparator<Object>(this){

        @Override
        public int compare(Object a, Object b) {
            return this.cmp((File)a, (File)b);
        }

        int cmp(File f1, File f2) {
            ShellFolder sf1 = null;
            ShellFolder sf2 = null;
            if (f1 instanceof ShellFolder && (sf1 = (ShellFolder)f1).isFileSystem()) {
                sf1 = null;
            }
            if (f2 instanceof ShellFolder && (sf2 = (ShellFolder)f2).isFileSystem()) {
                sf2 = null;
            }
            if (sf1 != null && sf2 != null) {
                return sf1.compareTo(sf2);
            }
            if (sf1 != null) {
                return -1;
            }
            if (sf2 != null) {
                return 1;
            }
            String name1 = f1.getName();
            String name2 = f2.getName();
            int diff = name1.toLowerCase().compareTo(name2.toLowerCase());
            if (diff != 0) {
                return diff;
            }
            return name1.compareTo(name2);
        }
    };

    ShellFolderManager() {
    }

    ShellFolder createShellFolder(File file) {
        return new DefaultShellFolder(null, file);
    }

    public Object get(String key) {
        switch (key) {
            case "fileChooserDefaultFolder": {
                File homeDir = new File(System.getProperty("user.home"));
                return this.createShellFolder(homeDir);
            }
            case "roots": {
                return File.listRoots();
            }
            case "fileChooserComboBoxFolders": {
                return this.get("roots");
            }
            case "fileChooserShortcutPanelFolders": {
                return new File[]{(File)this.get("fileChooserDefaultFolder")};
            }
        }
        return null;
    }

    boolean isComputerNode() {
        return false;
    }

    boolean isFileSystemRoot(File dir) {
        if (dir instanceof ShellFolder && !((ShellFolder)dir).isFileSystem()) {
            return false;
        }
        return dir.getParentFile() == null;
    }

    void sortFiles(List<Object> files) {
        files.sort(this.fileComparator);
    }

    ShellFolderColumnInfo[] getFolderColumns(File dir) {
        ShellFolderColumnInfo[] columns = null;
        if (dir instanceof ShellFolder) {
            columns = ((ShellFolder)dir).getFolderColumns();
        }
        if (columns == null) {
            columns = new ShellFolderColumnInfo[]{new ShellFolderColumnInfo(COLUMN_NAME, 150, 10, true, this.fileComparator), new ShellFolderColumnInfo(COLUMN_SIZE, 75, 4, true, ComparableComparator.getInstance(), true), new ShellFolderColumnInfo(COLUMN_DATE, 130, 10, true, ComparableComparator.getInstance(), true)};
        }
        return columns;
    }

    Object getFolderColumnValue(File file, int column) {
        Object value;
        if (file instanceof ShellFolder && (value = ((ShellFolder)file).getFolderColumnValue()) != null) {
            return value;
        }
        if (file == null || !file.exists()) {
            return null;
        }
        switch (column) {
            case 0: {
                return file;
            }
            case 1: {
                return file.isDirectory() ? null : Long.valueOf(file.length());
            }
            case 2: {
                if (this.isFileSystemRoot(file)) {
                    return null;
                }
                long time = file.lastModified();
                return time == 0L ? null : new Date(time);
            }
        }
        return null;
    }

    private static class ComparableComparator
    implements Comparator<Object> {
        private static Comparator<Object> instance;

        private ComparableComparator() {
        }

        public static Comparator<Object> getInstance() {
            if (instance == null) {
                instance = new ComparableComparator();
            }
            return instance;
        }

        @Override
        public int compare(Object o1, Object o2) {
            int gt = o1 == null && o2 == null ? 0 : (o1 != null && o2 == null ? 1 : (o1 == null && o2 != null ? -1 : (o1 instanceof Comparable ? ((Comparable)o1).compareTo(o2) : 0)));
            return gt;
        }
    }
}

