/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.FilePane;
import com.frostwire.gui.theme.SkinMenu;
import com.frostwire.gui.theme.SkinPopupMenu;
import com.frostwire.gui.theme.SkinRadioButtonMenuItem;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class FilePaneEx
extends FilePane {
    private static final int VIEWTYPE_COUNT = 2;
    private SkinPopupMenu contextMenu;
    private SkinMenu viewMenu;
    private String viewMenuLabelText;
    private boolean listViewWindowsStyle;
    private String[] viewTypeActionNames;

    FilePaneEx(FilePane.FileChooserUIAccessor fileChooserUIAccessor) {
        super(fileChooserUIAccessor);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Locale l = this.getFileChooser().getLocale();
        this.listViewWindowsStyle = UIManager.getBoolean("FileChooser.listViewWindowsStyle");
        this.viewMenuLabelText = UIManager.getString((Object)"FileChooser.viewMenuLabelText", l);
        this.viewTypeActionNames = new String[2];
        this.viewTypeActionNames[0] = UIManager.getString((Object)"FileChooser.listViewActionLabelText", l);
        this.viewTypeActionNames[1] = UIManager.getString((Object)"FileChooser.detailsViewActionLabelText", l);
    }

    @Override
    public JMenu getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new SkinMenu(this.viewMenuLabelText);
            ButtonGroup viewButtonGroup = new ButtonGroup();
            for (int i2 = 0; i2 < 2; ++i2) {
                SkinRadioButtonMenuItem mi = new SkinRadioButtonMenuItem(new ViewTypeAction(i2));
                viewButtonGroup.add(mi);
                this.viewMenu.add(mi);
            }
            this.updateViewMenu();
        }
        return this.viewMenu;
    }

    private void updateViewMenu() {
        if (this.viewMenu != null) {
            Component[] comps;
            for (Component comp : comps = this.viewMenu.getMenuComponents()) {
                if (!(comp instanceof SkinRadioButtonMenuItem)) continue;
                SkinRadioButtonMenuItem mi = (SkinRadioButtonMenuItem)comp;
                if (((ViewTypeAction)mi.getAction()).viewType != this.getViewType()) continue;
                mi.setSelected(true);
            }
        }
    }

    @Override
    public JPopupMenu getComponentPopupMenu() {
        SkinMenu viewMenu = (SkinMenu)this.getViewMenu();
        if (this.contextMenu == null) {
            this.contextMenu = new SkinPopupMenu();
            if (viewMenu != null) {
                this.contextMenu.add(viewMenu);
                if (this.listViewWindowsStyle) {
                    this.contextMenu.addSeparator();
                }
            }
            ActionMap actionMap = this.getActionMap();
            Action refreshAction = actionMap.get("refresh");
            Action newFolderAction = actionMap.get("New Folder");
            if (refreshAction != null) {
                this.contextMenu.add(refreshAction);
                if (this.listViewWindowsStyle && newFolderAction != null) {
                    this.contextMenu.addSeparator();
                }
            }
            if (newFolderAction != null) {
                this.contextMenu.add(newFolderAction);
            }
        }
        if (viewMenu != null) {
            viewMenu.getPopupMenu().setInvoker(viewMenu);
        }
        return this.contextMenu;
    }

    class ViewTypeAction
    extends AbstractAction {
        private static final long serialVersionUID = 3795594739034737323L;
        private final int viewType;

        ViewTypeAction(int viewType) {
            super(FilePaneEx.this.viewTypeActionNames[viewType]);
            this.viewType = viewType;
            this.putValue("ActionCommandKey", switch (viewType) {
                case 0 -> "viewTypeList";
                case 1 -> "viewTypeDetails";
                default -> (String)this.getValue("Name");
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilePaneEx.this.setViewType(this.viewType);
        }
    }
}

