/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.ShellFolder;
import com.frostwire.gui.theme.ShellFolderColumnInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import javax.swing.text.Position;

public class FilePane
extends JPanel
implements PropertyChangeListener {
    static final String ACTION_REFRESH = "refresh";
    static final String ACTION_NEW_FOLDER = "New Folder";
    static final String ACTION_VIEW_LIST = "viewTypeList";
    static final String ACTION_VIEW_DETAILS = "viewTypeDetails";
    static final int VIEWTYPE_LIST = 0;
    static final int VIEWTYPE_DETAILS = 1;
    private static final long serialVersionUID = -7006852608530881336L;
    private static final String ACTION_CANCEL = "cancelSelection";
    private static final String ACTION_EDIT_FILE_NAME = "editFileName";
    private static final int VIEWTYPE_COUNT = 2;
    private static final Cursor waitCursor = Cursor.getPredefinedCursor(3);
    private static final int COLUMN_FILENAME = 0;
    private static final FocusListener repaintListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent fe) {
            this.repaintSelection(fe.getSource());
        }

        @Override
        public void focusLost(FocusEvent fe) {
            this.repaintSelection(fe.getSource());
        }

        private void repaintSelection(Object source2) {
            if (source2 instanceof JList) {
                this.repaintListSelection((JList)source2);
            } else if (source2 instanceof JTable) {
                this.repaintTableSelection((JTable)source2);
            }
        }

        private void repaintListSelection(JList<Object> list) {
            int[] indices;
            for (int i2 : indices = list.getSelectedIndices()) {
                Rectangle bounds = list.getCellBounds(i2, i2);
                list.repaint(bounds);
            }
        }

        private void repaintTableSelection(JTable table) {
            int minRow = table.getSelectionModel().getMinSelectionIndex();
            int maxRow = table.getSelectionModel().getMaxSelectionIndex();
            if (minRow == -1 || maxRow == -1) {
                return;
            }
            int col0 = table.convertColumnIndexToView(0);
            Rectangle first = table.getCellRect(minRow, col0, false);
            Rectangle last = table.getCellRect(maxRow, col0, false);
            Rectangle dirty = first.union(last);
            table.repaint(dirty);
        }
    };
    private Action[] actions;
    private int viewType = -1;
    private final JPanel[] viewPanels = new JPanel[2];
    private JPanel currentViewPanel;
    private String[] viewTypeActionNames;
    private JPopupMenu contextMenu;
    private JMenu viewMenu;
    private String viewMenuLabelText;
    private String refreshActionLabelText;
    private String newFolderActionLabelText;
    private String kiloByteString;
    private String megaByteString;
    private String gigaByteString;
    private String renameErrorTitleText;
    private String renameErrorText;
    private Border listViewBorder;
    private Color listViewBackground;
    private boolean listViewWindowsStyle;
    private boolean readOnly;
    private boolean fullRowSelection = false;
    private ListSelectionModel listSelectionModel;
    private JList<Object> list;
    private JTable detailsTable;
    private File newFolderFile;
    private final FileChooserUIAccessor fileChooserUIAccessor;
    private DetailsTableModel detailsTableModel;
    private DetailsTableRowSorter rowSorter;
    private final KeyListener detailsKeyListener = new KeyAdapter(){
        private final long timeFactor;
        private final StringBuilder typedString = new StringBuilder();
        private long lastTime = 1000L;
        {
            Long l = (Long)UIManager.get("Table.timeFactor");
            this.timeFactor = l != null ? l : 1000L;
        }

        @Override
        public void keyTyped(KeyEvent e) {
            int index;
            BasicDirectoryModel model = FilePane.this.getModel();
            int rowCount = model.getSize();
            if (FilePane.this.detailsTable == null || rowCount == 0 || e.isAltDown() || e.isControlDown() || e.isMetaDown()) {
                return;
            }
            InputMap inputMap = FilePane.this.detailsTable.getInputMap(1);
            KeyStroke key = KeyStroke.getKeyStrokeForEvent(e);
            if (inputMap != null && inputMap.get(key) != null) {
                return;
            }
            int startIndex = FilePane.this.detailsTable.getSelectionModel().getLeadSelectionIndex();
            if (startIndex < 0) {
                startIndex = 0;
            }
            if (startIndex >= rowCount) {
                startIndex = rowCount - 1;
            }
            char c = e.getKeyChar();
            long time = e.getWhen();
            if (time - this.lastTime < this.timeFactor) {
                if (this.typedString.length() == 1 && this.typedString.charAt(0) == c) {
                    ++startIndex;
                } else {
                    this.typedString.append(c);
                }
            } else {
                ++startIndex;
                this.typedString.setLength(0);
                this.typedString.append(c);
            }
            this.lastTime = time;
            if (startIndex >= rowCount) {
                startIndex = 0;
            }
            if ((index = this.getNextMatch(startIndex, rowCount - 1)) < 0 && startIndex > 0) {
                index = this.getNextMatch(0, startIndex - 1);
            }
            if (index >= 0) {
                FilePane.this.detailsTable.getSelectionModel().setSelectionInterval(index, index);
                Rectangle cellRect = FilePane.this.detailsTable.getCellRect(index, FilePane.this.detailsTable.convertColumnIndexToView(0), false);
                FilePane.this.detailsTable.scrollRectToVisible(cellRect);
            }
        }

        private int getNextMatch(int startIndex, int finishIndex) {
            BasicDirectoryModel model = FilePane.this.getModel();
            JFileChooser fileChooser = FilePane.this.getFileChooser();
            DetailsTableRowSorter rowSorter = FilePane.this.getRowSorter();
            String prefix = this.typedString.toString().toLowerCase();
            for (int index = startIndex; index <= finishIndex; ++index) {
                File file = (File)model.getElementAt(rowSorter.convertRowIndexToModel(index));
                String fileName = fileChooser.getName(file).toLowerCase();
                if (!fileName.startsWith(prefix)) continue;
                return index;
            }
            return -1;
        }
    };
    private DetailsTableCellEditor tableCellEditor;
    private int lastIndex = -1;
    private File editFile = null;
    private int editX = 20;
    private JTextField editCell = null;
    private final FocusListener editorFocusListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                FilePane.this.applyEdit();
            }
        }
    };
    private Action newFolderAction;
    private Handler handler;

    FilePane(FileChooserUIAccessor fileChooserUIAccessor) {
        super(new BorderLayout());
        this.fileChooserUIAccessor = fileChooserUIAccessor;
        this.installDefaults();
        this.createActionMap();
    }

    private static void recursivelySetInheritsPopupMenu(Container container, boolean b) {
        if (container instanceof JComponent) {
            ((JComponent)container).setInheritsPopupMenu(b);
        }
        int n = container.getComponentCount();
        for (int i2 = 0; i2 < n; ++i2) {
            FilePane.recursivelySetInheritsPopupMenu((Container)container.getComponent(i2), b);
        }
    }

    static void addActionsToMap(ActionMap map, Action[] actions) {
        if (map != null && actions != null) {
            for (Action a : actions) {
                String cmd = (String)a.getValue("ActionCommandKey");
                if (cmd == null) {
                    cmd = (String)a.getValue("Name");
                }
                map.put(cmd, a);
            }
        }
    }

    private static int loc2IndexFileList(JList<Object> list, Point point) {
        Object bySize;
        int index = list.locationToIndex(point);
        if (index != -1 && (bySize = list.getClientProperty("List.isFileList")) instanceof Boolean && ((Boolean)bySize).booleanValue() && !FilePane.pointIsInActualBounds(list, index, point)) {
            index = -1;
        }
        return index;
    }

    private static boolean pointIsInActualBounds(JList<Object> list, int index, Point point) {
        ListCellRenderer<Object> renderer = list.getCellRenderer();
        ListModel<Object> dataModel = list.getModel();
        Object value = dataModel.getElementAt(index);
        Component item = renderer.getListCellRendererComponent(list, value, index, false, false);
        Dimension itemSize = item.getPreferredSize();
        Rectangle cellBounds = list.getCellBounds(index, index);
        if (!item.getComponentOrientation().isLeftToRight()) {
            cellBounds.x += cellBounds.width - itemSize.width;
        }
        cellBounds.width = itemSize.width;
        return cellBounds.contains(point);
    }

    private static boolean pointOutsidePrefSize(JTable table, int row, int column, Point p) {
        if (table.convertColumnIndexToModel(column) != 0 || row == -1) {
            return true;
        }
        TableCellRenderer tcr = table.getCellRenderer(row, column);
        Object value = table.getValueAt(row, column);
        Component cell = tcr.getTableCellRendererComponent(table, value, false, false, row, column);
        Dimension itemSize = cell.getPreferredSize();
        Rectangle cellBounds = table.getCellRect(row, column, false);
        cellBounds.width = itemSize.width;
        cellBounds.height = itemSize.height;
        assert (p.x >= cellBounds.x && p.y >= cellBounds.y);
        return p.x > cellBounds.x + cellBounds.width || p.y > cellBounds.y + cellBounds.height;
    }

    void uninstallUI() {
        if (this.getModel() != null) {
            this.getModel().removePropertyChangeListener(this);
        }
    }

    JFileChooser getFileChooser() {
        return this.fileChooserUIAccessor.getFileChooser();
    }

    private BasicDirectoryModel getModel() {
        return this.fileChooserUIAccessor.getModel();
    }

    int getViewType() {
        return this.viewType;
    }

    void setViewType(int viewType) {
        int oldValue = this.viewType;
        if (viewType == oldValue) {
            return;
        }
        this.viewType = viewType;
        switch (viewType) {
            case 0: {
                JPanel p;
                if (this.viewPanels[viewType] == null) {
                    p = this.fileChooserUIAccessor.createList();
                    if (p == null) {
                        p = this.createList();
                    }
                    this.setViewPanel(viewType, p);
                }
                this.list.setLayoutOrientation(1);
                break;
            }
            case 1: {
                if (this.viewPanels[viewType] != null) break;
                JPanel p = this.fileChooserUIAccessor.createDetailsView();
                if (p == null) {
                    p = this.createDetailsView();
                }
                this.setViewPanel(viewType, p);
            }
        }
        JPanel oldViewPanel = this.currentViewPanel;
        this.currentViewPanel = this.viewPanels[viewType];
        if (this.currentViewPanel != oldViewPanel) {
            if (oldViewPanel != null) {
                this.remove(oldViewPanel);
            }
            this.add((Component)this.currentViewPanel, "Center");
            this.revalidate();
            this.repaint();
        }
        this.updateViewMenu();
        this.firePropertyChange("viewType", oldValue, viewType);
    }

    Action getViewTypeAction(int viewType) {
        return new ViewTypeAction(viewType);
    }

    private void setViewPanel(int viewType, JPanel viewPanel) {
        this.viewPanels[viewType] = viewPanel;
        FilePane.recursivelySetInheritsPopupMenu(viewPanel, true);
        switch (viewType) {
            case 0: {
                this.list = (JList)this.findChildComponent(this.viewPanels[viewType], JList.class);
                if (this.listSelectionModel == null) {
                    this.listSelectionModel = this.list.getSelectionModel();
                    if (this.detailsTable == null) break;
                    this.detailsTable.setSelectionModel(this.listSelectionModel);
                    break;
                }
                this.list.setSelectionModel(this.listSelectionModel);
                break;
            }
            case 1: {
                this.detailsTable = (JTable)this.findChildComponent(this.viewPanels[viewType], JTable.class);
                this.detailsTable.setRowHeight(Math.max(this.detailsTable.getFont().getSize() + 4, 17));
                if (this.listSelectionModel == null) break;
                this.detailsTable.setSelectionModel(this.listSelectionModel);
            }
        }
        if (this.viewType == viewType) {
            if (this.currentViewPanel != null) {
                this.remove(this.currentViewPanel);
            }
            this.currentViewPanel = viewPanel;
            this.add((Component)this.currentViewPanel, "Center");
            this.revalidate();
            this.repaint();
        }
    }

    void installDefaults() {
        Locale l = this.getFileChooser().getLocale();
        this.listViewBorder = UIManager.getBorder("FileChooser.listViewBorder");
        this.listViewBackground = UIManager.getColor("FileChooser.listViewBackground");
        this.listViewWindowsStyle = UIManager.getBoolean("FileChooser.listViewWindowsStyle");
        this.readOnly = UIManager.getBoolean("FileChooser.readOnly");
        this.viewMenuLabelText = UIManager.getString((Object)"FileChooser.viewMenuLabelText", l);
        this.refreshActionLabelText = UIManager.getString((Object)"FileChooser.refreshActionLabelText", l);
        this.newFolderActionLabelText = UIManager.getString((Object)"FileChooser.newFolderActionLabelText", l);
        this.viewTypeActionNames = new String[2];
        this.viewTypeActionNames[0] = UIManager.getString((Object)"FileChooser.listViewActionLabelText", l);
        this.viewTypeActionNames[1] = UIManager.getString((Object)"FileChooser.detailsViewActionLabelText", l);
        this.kiloByteString = UIManager.getString((Object)"FileChooser.fileSizeKiloBytes", l);
        this.megaByteString = UIManager.getString((Object)"FileChooser.fileSizeMegaBytes", l);
        this.gigaByteString = UIManager.getString((Object)"FileChooser.fileSizeGigaBytes", l);
        this.fullRowSelection = UIManager.getBoolean("FileView.fullRowSelection");
        this.renameErrorTitleText = UIManager.getString((Object)"FileChooser.renameErrorTitleText", l);
        this.renameErrorText = UIManager.getString((Object)"FileChooser.renameErrorText", l);
    }

    public Action[] getActions() {
        if (this.actions == null) {
            ArrayList<Action> actionList = new ArrayList<Action>(8);
            class FilePaneAction
            extends AbstractAction {
                private FilePaneAction(String name) {
                    this(name, name);
                }

                private FilePaneAction(String name, String cmd) {
                    super(name);
                    this.putValue("ActionCommandKey", cmd);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    String cmd;
                    switch (cmd = (String)this.getValue("ActionCommandKey")) {
                        case "cancelSelection": {
                            if (FilePane.this.editFile != null) {
                                FilePane.this.cancelEdit();
                                break;
                            }
                            FilePane.this.getFileChooser().cancelSelection();
                            break;
                        }
                        case "editFileName": {
                            JFileChooser fc = FilePane.this.getFileChooser();
                            int index = FilePane.this.listSelectionModel.getMinSelectionIndex();
                            if (index < 0 || FilePane.this.editFile != null || fc.isMultiSelectionEnabled() && fc.getSelectedFiles().length > 1) break;
                            FilePane.this.editFileName(index);
                            break;
                        }
                        case "refresh": {
                            FilePane.this.getFileChooser().rescanCurrentDirectory();
                        }
                    }
                }

                @Override
                public boolean isEnabled() {
                    String cmd = (String)this.getValue("ActionCommandKey");
                    if (cmd.equals(FilePane.ACTION_CANCEL)) {
                        return FilePane.this.getFileChooser().isEnabled();
                    }
                    if (cmd.equals(FilePane.ACTION_EDIT_FILE_NAME)) {
                        return !FilePane.this.readOnly && FilePane.this.getFileChooser().isEnabled();
                    }
                    return true;
                }
            }
            actionList.add(new FilePaneAction(ACTION_CANCEL));
            actionList.add(new FilePaneAction(ACTION_EDIT_FILE_NAME));
            actionList.add(new FilePaneAction(this.refreshActionLabelText, ACTION_REFRESH));
            Action action = this.fileChooserUIAccessor.getApproveSelectionAction();
            if (action != null) {
                actionList.add(action);
            }
            if ((action = this.fileChooserUIAccessor.getChangeToParentDirectoryAction()) != null) {
                actionList.add(action);
            }
            if ((action = this.getNewFolderAction()) != null) {
                actionList.add(action);
            }
            if ((action = this.getViewTypeAction(0)) != null) {
                actionList.add(action);
            }
            if ((action = this.getViewTypeAction(1)) != null) {
                actionList.add(action);
            }
            this.actions = actionList.toArray(new Action[0]);
        }
        return this.actions;
    }

    private void createActionMap() {
        FilePane.addActionsToMap(super.getActionMap(), this.getActions());
    }

    private void updateListRowCount(JList<Object> list) {
        boolean smallIconsView = false;
        if (smallIconsView) {
            list.setVisibleRowCount(this.getModel().getSize() / 3);
        } else {
            list.setVisibleRowCount(-1);
        }
    }

    JPanel createList() {
        JPanel p = new JPanel(new BorderLayout());
        final JFileChooser fileChooser = this.getFileChooser();
        final JList<Object> list = new JList<Object>(){
            private static final long serialVersionUID = 7343396893205583428L;

            @Override
            public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
                ListModel model = this.getModel();
                int max = model.getSize();
                if (prefix == null || startIndex < 0 || startIndex >= max) {
                    throw new IllegalArgumentException();
                }
                boolean backwards = bias == Position.Bias.Backward;
                int i2 = startIndex;
                while (backwards ? i2 >= 0 : i2 < max) {
                    String filename = fileChooser.getName((File)model.getElementAt(i2));
                    if (filename.regionMatches(true, 0, prefix, 0, prefix.length())) {
                        return i2;
                    }
                    i2 += backwards ? -1 : 1;
                }
                return -1;
            }
        };
        list.setCellRenderer(new FileRenderer());
        list.setLayoutOrientation(1);
        list.putClientProperty("List.isFileList", Boolean.TRUE);
        if (this.listViewWindowsStyle) {
            list.addFocusListener(repaintListener);
        }
        this.updateListRowCount(list);
        this.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                FilePane.this.updateListRowCount(list);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                FilePane.this.updateListRowCount(list);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (FilePane.this.isShowing()) {
                    FilePane.this.clearSelection();
                }
                FilePane.this.updateListRowCount(list);
            }
        });
        this.getModel().addPropertyChangeListener(this);
        if (fileChooser.isMultiSelectionEnabled()) {
            list.setSelectionMode(2);
        } else {
            list.setSelectionMode(0);
        }
        list.setModel(new SortableListModel());
        list.addListSelectionListener(this.createListSelectionListener());
        list.addMouseListener(this.getMouseHandler());
        JScrollPane scrollpane = new JScrollPane(list);
        if (this.listViewBackground != null) {
            list.setBackground(this.listViewBackground);
        }
        if (this.listViewBorder != null) {
            scrollpane.setBorder(this.listViewBorder);
        }
        p.add((Component)scrollpane, "Center");
        return p;
    }

    private DetailsTableModel getDetailsTableModel() {
        if (this.detailsTableModel == null) {
            this.detailsTableModel = new DetailsTableModel(this.getFileChooser());
        }
        return this.detailsTableModel;
    }

    private void updateDetailsColumnModel(JTable table) {
        if (table != null) {
            ShellFolderColumnInfo[] columns = this.detailsTableModel.getColumns();
            DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
            for (int i2 = 0; i2 < columns.length; ++i2) {
                String uiTitle;
                ShellFolderColumnInfo dataItem = columns[i2];
                TableColumn column = new TableColumn(i2);
                String title = dataItem.getTitle();
                if (title != null && title.startsWith("FileChooser.") && title.endsWith("HeaderText") && (uiTitle = UIManager.getString((Object)title, table.getLocale())) != null) {
                    title = uiTitle;
                }
                column.setHeaderValue(title);
                Integer width = dataItem.getWidth();
                if (width != null) {
                    column.setPreferredWidth(width);
                }
                columnModel.addColumn(column);
            }
            if (!this.readOnly && columnModel.getColumnCount() > 0) {
                columnModel.getColumn(0).setCellEditor(this.getDetailsTableCellEditor());
            }
            table.setColumnModel(columnModel);
        }
    }

    private DetailsTableRowSorter getRowSorter() {
        if (this.rowSorter == null) {
            this.rowSorter = new DetailsTableRowSorter();
        }
        return this.rowSorter;
    }

    private DetailsTableCellEditor getDetailsTableCellEditor() {
        if (this.tableCellEditor == null) {
            this.tableCellEditor = new DetailsTableCellEditor(new JTextField());
        }
        return this.tableCellEditor;
    }

    JPanel createDetailsView() {
        final JFileChooser chooser = this.getFileChooser();
        JPanel p = new JPanel(new BorderLayout());
        JTable detailsTable = new JTable(this.getDetailsTableModel()){
            private static final long serialVersionUID = 2765367470318527427L;

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.getKeyCode() == 27 && this.getCellEditor() == null) {
                    chooser.dispatchEvent(e);
                    return true;
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }

            @Override
            public void tableChanged(TableModelEvent e) {
                super.tableChanged(e);
                if (e.getFirstRow() == -1) {
                    FilePane.this.updateDetailsColumnModel(this);
                }
            }
        };
        detailsTable.setRowSorter(this.getRowSorter());
        detailsTable.setAutoCreateColumnsFromModel(false);
        detailsTable.setComponentOrientation(chooser.getComponentOrientation());
        detailsTable.setAutoResizeMode(0);
        detailsTable.setShowGrid(false);
        detailsTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        detailsTable.addKeyListener(this.detailsKeyListener);
        Font font = this.list.getFont();
        detailsTable.setFont(font);
        detailsTable.setIntercellSpacing(new Dimension(0, 0));
        AlignableTableHeaderRenderer headerRenderer = new AlignableTableHeaderRenderer(detailsTable.getTableHeader().getDefaultRenderer());
        detailsTable.getTableHeader().setDefaultRenderer(headerRenderer);
        DetailsTableCellRenderer cellRenderer = new DetailsTableCellRenderer(chooser);
        detailsTable.setDefaultRenderer(Object.class, cellRenderer);
        detailsTable.getColumnModel().getSelectionModel().setSelectionMode(0);
        detailsTable.addMouseListener(this.getMouseHandler());
        detailsTable.putClientProperty("Table.isFileList", Boolean.TRUE);
        if (this.listViewWindowsStyle) {
            detailsTable.addFocusListener(repaintListener);
        }
        ActionMap am = SwingUtilities.getUIActionMap(detailsTable);
        am.remove("selectNextRowCell");
        am.remove("selectPreviousRowCell");
        am.remove("selectNextColumnCell");
        am.remove("selectPreviousColumnCell");
        detailsTable.setFocusTraversalKeys(0, null);
        detailsTable.setFocusTraversalKeys(1, null);
        JScrollPane scrollpane = new JScrollPane(detailsTable);
        scrollpane.setComponentOrientation(chooser.getComponentOrientation());
        LookAndFeel.installColors(scrollpane.getViewport(), "Table.background", "Table.foreground");
        scrollpane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JScrollPane sp = (JScrollPane)e.getComponent();
                FilePane.this.fixNameColumnWidth(sp.getViewport().getSize().width);
                sp.removeComponentListener(this);
            }
        });
        scrollpane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JScrollPane jsp = (JScrollPane)e.getComponent();
                JTable table = (JTable)jsp.getViewport().getView();
                if (!e.isShiftDown() || table.getSelectionModel().getSelectionMode() == 0) {
                    FilePane.this.clearSelection();
                    TableCellEditor tce = table.getCellEditor();
                    if (tce != null) {
                        tce.stopCellEditing();
                    }
                }
            }
        });
        detailsTable.setForeground(this.list.getForeground());
        detailsTable.setBackground(this.list.getBackground());
        if (this.listViewBorder != null) {
            scrollpane.setBorder(this.listViewBorder);
        }
        p.add((Component)scrollpane, "Center");
        this.detailsTableModel.fireTableStructureChanged();
        return p;
    }

    private void fixNameColumnWidth(int viewWidth) {
        TableColumn nameCol = this.detailsTable.getColumnModel().getColumn(0);
        int tableWidth = this.detailsTable.getPreferredSize().width;
        if (tableWidth < viewWidth) {
            nameCol.setPreferredWidth(nameCol.getPreferredWidth() + viewWidth - tableWidth);
        }
    }

    private ListSelectionListener createListSelectionListener() {
        return this.fileChooserUIAccessor.createListSelectionListener();
    }

    private int getEditIndex() {
        return this.lastIndex;
    }

    private void setEditIndex(int i2) {
        this.lastIndex = i2;
    }

    private void resetEditIndex() {
        this.lastIndex = -1;
    }

    private void cancelEdit() {
        if (this.editFile != null) {
            this.editFile = null;
            this.list.remove(this.editCell);
            this.repaint();
        } else if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().cancelCellEditing();
        }
    }

    private void editFileName(int index) {
        File currentDirectory = this.getFileChooser().getCurrentDirectory();
        if (this.readOnly || !this.canWrite(currentDirectory)) {
            return;
        }
        this.ensureIndexIsVisible(index);
        switch (this.viewType) {
            case 0: {
                this.editFile = (File)this.getModel().getElementAt(this.getRowSorter().convertRowIndexToModel(index));
                Rectangle r = this.list.getCellBounds(index, index);
                if (this.editCell == null) {
                    this.editCell = new JTextField();
                    this.editCell.setName("Tree.cellEditor");
                    this.editCell.addActionListener(new EditActionListener());
                    this.editCell.addFocusListener(this.editorFocusListener);
                    this.editCell.setNextFocusableComponent(this.list);
                }
                this.list.add(this.editCell);
                this.editCell.setText(this.getFileChooser().getName(this.editFile));
                ComponentOrientation orientation = this.list.getComponentOrientation();
                this.editCell.setComponentOrientation(orientation);
                if (orientation.isLeftToRight()) {
                    this.editCell.setBounds(this.editX + r.x, r.y, r.width - this.editX, r.height);
                } else {
                    this.editCell.setBounds(r.x, r.y, r.width - this.editX, r.height);
                }
                this.editCell.requestFocus();
                this.editCell.selectAll();
                break;
            }
            case 1: {
                this.detailsTable.editCellAt(index, 0);
            }
        }
    }

    private void applyEdit() {
        if (this.editFile != null && this.editFile.exists()) {
            JFileChooser chooser = this.getFileChooser();
            String oldDisplayName = chooser.getName(this.editFile);
            String oldFileName = this.editFile.getName();
            String newDisplayName = this.editCell.getText().trim();
            if (!newDisplayName.equals(oldDisplayName)) {
                FileSystemView fsv;
                File f2;
                int i2;
                Object newFileName = newDisplayName;
                int i1 = oldFileName.length();
                if (i1 > (i2 = oldDisplayName.length()) && oldFileName.charAt(i2) == '.') {
                    newFileName = newDisplayName + oldFileName.substring(i2);
                }
                if (!(f2 = (fsv = chooser.getFileSystemView()).createFileObject(this.editFile.getParentFile(), (String)newFileName)).exists()) {
                    if (this.getModel().renameFile(this.editFile, f2)) {
                        if (fsv.isParent(chooser.getCurrentDirectory(), f2)) {
                            if (chooser.isMultiSelectionEnabled()) {
                                chooser.setSelectedFiles(new File[]{f2});
                            } else {
                                chooser.setSelectedFile(f2);
                            }
                        }
                    } else {
                        JOptionPane.showMessageDialog(chooser, MessageFormat.format(this.renameErrorText, oldFileName), this.renameErrorTitleText, 0);
                    }
                }
            }
        }
        if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().stopCellEditing();
        }
        this.cancelEdit();
    }

    Action getNewFolderAction() {
        if (!this.readOnly && this.newFolderAction == null) {
            this.newFolderAction = new AbstractAction(this.newFolderActionLabelText){
                private static final long serialVersionUID = 1165291121008749795L;
                private Action basicNewFolderAction;
                {
                    this.putValue("ActionCommandKey", FilePane.ACTION_NEW_FOLDER);
                    File currentDirectory = FilePane.this.getFileChooser().getCurrentDirectory();
                    if (currentDirectory != null) {
                        this.setEnabled(FilePane.this.canWrite(currentDirectory));
                    }
                }

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (this.basicNewFolderAction == null) {
                        this.basicNewFolderAction = FilePane.this.fileChooserUIAccessor.getNewFolderAction();
                    }
                    JFileChooser fc = FilePane.this.getFileChooser();
                    File oldFile = fc.getSelectedFile();
                    this.basicNewFolderAction.actionPerformed(ev);
                    File newFile = fc.getSelectedFile();
                    if (newFile != null && !newFile.equals(oldFile) && newFile.isDirectory()) {
                        FilePane.this.newFolderFile = newFile;
                    }
                }
            };
        }
        return this.newFolderAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setFileSelected() {
        if (this.getFileChooser().isMultiSelectionEnabled() && !this.isDirectorySelected()) {
            Object[] files = this.getFileChooser().getSelectedFiles();
            List<Object> selectedObjectsList = this.list.getSelectedValuesList();
            Object[] selectedObjects = selectedObjectsList.toArray();
            this.listSelectionModel.setValueIsAdjusting(true);
            try {
                int lead = this.listSelectionModel.getLeadSelectionIndex();
                int anchor = this.listSelectionModel.getAnchorSelectionIndex();
                Arrays.sort(files);
                Arrays.sort(selectedObjects);
                int shouldIndex = 0;
                int actuallyIndex = 0;
                while (shouldIndex < files.length && actuallyIndex < selectedObjects.length) {
                    int comparison = ((File)files[shouldIndex]).compareTo((File)selectedObjects[actuallyIndex]);
                    if (comparison < 0) {
                        this.doSelectFile((File)files[shouldIndex++]);
                        continue;
                    }
                    if (comparison > 0) {
                        this.doDeselectFile(selectedObjects[actuallyIndex++]);
                        continue;
                    }
                    ++shouldIndex;
                    ++actuallyIndex;
                }
                while (shouldIndex < files.length) {
                    this.doSelectFile((File)files[shouldIndex++]);
                }
                while (actuallyIndex < selectedObjects.length) {
                    this.doDeselectFile(selectedObjects[actuallyIndex++]);
                }
                if (!(this.listSelectionModel instanceof DefaultListSelectionModel)) return;
                ((DefaultListSelectionModel)this.listSelectionModel).moveLeadSelectionIndex(lead);
                this.listSelectionModel.setAnchorSelectionIndex(anchor);
                return;
            }
            finally {
                this.listSelectionModel.setValueIsAdjusting(false);
            }
        } else {
            int i2;
            JFileChooser chooser = this.getFileChooser();
            File f = this.isDirectorySelected() ? this.getDirectory() : chooser.getSelectedFile();
            if (f != null && (i2 = this.getModel().indexOf(f)) >= 0) {
                int viewIndex = this.getRowSorter().convertRowIndexToView(i2);
                this.listSelectionModel.setSelectionInterval(viewIndex, viewIndex);
                this.ensureIndexIsVisible(viewIndex);
                return;
            } else {
                this.clearSelection();
            }
        }
    }

    private void doSelectFile(File fileToSelect) {
        int index = this.getModel().indexOf(fileToSelect);
        if (index >= 0) {
            index = this.getRowSorter().convertRowIndexToView(index);
            this.listSelectionModel.addSelectionInterval(index, index);
        }
    }

    private void doDeselectFile(Object fileToDeselect) {
        int index = this.getRowSorter().convertRowIndexToView(this.getModel().indexOf(fileToDeselect));
        this.listSelectionModel.removeSelectionInterval(index, index);
    }

    private void doSelectedFileChanged(PropertyChangeEvent e) {
        this.applyEdit();
        File f = (File)e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (f != null && (fc.isFileSelectionEnabled() && !f.isDirectory() || f.isDirectory() && fc.isDirectorySelectionEnabled())) {
            this.setFileSelected();
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent e) {
        this.applyEdit();
        File[] files = (File[])e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (files != null && files.length > 0 && (files.length > 1 || fc.isDirectorySelectionEnabled() || !files[0].isDirectory())) {
            this.setFileSelected();
        }
    }

    private void doDirectoryChanged() {
        this.getDetailsTableModel().updateColumnInfo();
        JFileChooser fc = this.getFileChooser();
        FileSystemView fsv = fc.getFileSystemView();
        this.applyEdit();
        this.resetEditIndex();
        this.ensureIndexIsVisible(0);
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null) {
            if (!this.readOnly) {
                this.getNewFolderAction().setEnabled(this.canWrite(currentDirectory));
            }
            this.fileChooserUIAccessor.getChangeToParentDirectoryAction().setEnabled(!fsv.isRoot(currentDirectory));
        }
    }

    private void doFilterChanged() {
        this.applyEdit();
        this.resetEditIndex();
        this.clearSelection();
    }

    private void doFileSelectionModeChanged() {
        this.applyEdit();
        this.resetEditIndex();
        this.clearSelection();
    }

    private void doMultiSelectionChanged() {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.listSelectionModel.setSelectionMode(2);
        } else {
            this.listSelectionModel.setSelectionMode(0);
            this.clearSelection();
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String s;
        if (this.viewType == -1) {
            this.setViewType(0);
        }
        switch (s = e.getPropertyName()) {
            case "SelectedFileChangedProperty": {
                this.doSelectedFileChanged(e);
                break;
            }
            case "SelectedFilesChangedProperty": {
                this.doSelectedFilesChanged(e);
                break;
            }
            case "directoryChanged": {
                this.doDirectoryChanged();
                break;
            }
            case "fileFilterChanged": {
                this.doFilterChanged();
                break;
            }
            case "fileSelectionChanged": {
                this.doFileSelectionModeChanged();
                break;
            }
            case "MultiSelectionEnabledChangedProperty": {
                this.doMultiSelectionChanged();
                break;
            }
            case "CancelSelection": {
                this.applyEdit();
                break;
            }
            case "busy": {
                this.setCursor((Boolean)e.getNewValue() != false ? waitCursor : null);
                break;
            }
            case "componentOrientation": {
                ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                JFileChooser cc = (JFileChooser)e.getSource();
                if (o != e.getOldValue()) {
                    cc.applyComponentOrientation(o);
                }
                if (this.detailsTable == null) break;
                this.detailsTable.setComponentOrientation(o);
                this.detailsTable.getParent().getParent().setComponentOrientation(o);
            }
        }
    }

    private void ensureIndexIsVisible(int i2) {
        if (i2 >= 0) {
            if (this.list != null) {
                this.list.ensureIndexIsVisible(i2);
            }
            if (this.detailsTable != null) {
                this.detailsTable.scrollRectToVisible(this.detailsTable.getCellRect(i2, 0, true));
            }
        }
    }

    void ensureFileIsVisible(File f) {
        int modelIndex = this.getModel().indexOf(f);
        if (modelIndex >= 0) {
            this.ensureIndexIsVisible(this.getRowSorter().convertRowIndexToView(modelIndex));
        }
    }

    void rescanCurrentDirectory() {
        this.getModel().validateFileCache();
    }

    public void clearSelection() {
        if (this.listSelectionModel != null) {
            this.listSelectionModel.clearSelection();
            if (this.listSelectionModel instanceof DefaultListSelectionModel) {
                ((DefaultListSelectionModel)this.listSelectionModel).moveLeadSelectionIndex(0);
                this.listSelectionModel.setAnchorSelectionIndex(0);
            }
        }
    }

    JMenu getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new JMenu(this.viewMenuLabelText);
            ButtonGroup viewButtonGroup = new ButtonGroup();
            for (int i2 = 0; i2 < 2; ++i2) {
                JRadioButtonMenuItem mi = new JRadioButtonMenuItem(new ViewTypeAction(i2));
                viewButtonGroup.add(mi);
                this.viewMenu.add(mi);
            }
            this.updateViewMenu();
        }
        return this.viewMenu;
    }

    private void updateViewMenu() {
        if (this.viewMenu != null) {
            Component[] comps;
            for (Component comp : comps = this.viewMenu.getMenuComponents()) {
                if (!(comp instanceof JRadioButtonMenuItem)) continue;
                JRadioButtonMenuItem mi = (JRadioButtonMenuItem)comp;
                if (((ViewTypeAction)mi.getAction()).viewType != this.viewType) continue;
                mi.setSelected(true);
            }
        }
    }

    @Override
    public JPopupMenu getComponentPopupMenu() {
        JPopupMenu popupMenu = this.getFileChooser().getComponentPopupMenu();
        if (popupMenu != null) {
            return popupMenu;
        }
        JMenu viewMenu = this.getViewMenu();
        if (this.contextMenu == null) {
            this.contextMenu = new JPopupMenu();
            if (viewMenu != null) {
                this.contextMenu.add(viewMenu);
                if (this.listViewWindowsStyle) {
                    this.contextMenu.addSeparator();
                }
            }
            ActionMap actionMap = this.getActionMap();
            Action refreshAction = actionMap.get(ACTION_REFRESH);
            Action newFolderAction = actionMap.get(ACTION_NEW_FOLDER);
            if (refreshAction != null) {
                this.contextMenu.add(refreshAction);
                if (this.listViewWindowsStyle && newFolderAction != null) {
                    this.contextMenu.addSeparator();
                }
            }
            if (newFolderAction != null) {
                this.contextMenu.add(newFolderAction);
            }
        }
        if (viewMenu != null) {
            viewMenu.getPopupMenu().setInvoker(viewMenu);
        }
        return this.contextMenu;
    }

    private Handler getMouseHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    private boolean isDirectorySelected() {
        return this.fileChooserUIAccessor.isDirectorySelected();
    }

    private File getDirectory() {
        return this.fileChooserUIAccessor.getDirectory();
    }

    private Component findChildComponent(Container container, Class<?> cls) {
        int n = container.getComponentCount();
        for (int i2 = 0; i2 < n; ++i2) {
            Component c;
            Component comp = container.getComponent(i2);
            if (cls.isInstance(comp)) {
                return comp;
            }
            if (!(comp instanceof Container) || (c = this.findChildComponent((Container)comp, cls)) == null) continue;
            return c;
        }
        return null;
    }

    private boolean canWrite(File f) {
        if (!f.exists()) {
            return false;
        }
        if (f instanceof ShellFolder) {
            return ((ShellFolder)f).isFileSystem();
        }
        if (this.fileChooserUIAccessor.usesShellFolder()) {
            try {
                return ShellFolder.getShellFolder(f).isFileSystem();
            }
            catch (FileNotFoundException ex) {
                return false;
            }
        }
        return true;
    }

    public static interface FileChooserUIAccessor {
        public JFileChooser getFileChooser();

        public BasicDirectoryModel getModel();

        public JPanel createList();

        public JPanel createDetailsView();

        public boolean isDirectorySelected();

        public File getDirectory();

        public Action getApproveSelectionAction();

        public Action getChangeToParentDirectoryAction();

        public Action getNewFolderAction();

        public MouseListener createDoubleClickListener(JList<Object> var1);

        public ListSelectionListener createListSelectionListener();

        public boolean usesShellFolder();
    }

    class ViewTypeAction
    extends AbstractAction {
        private static final long serialVersionUID = -4836669546572282852L;
        private final int viewType;

        ViewTypeAction(int viewType) {
            super(FilePane.this.viewTypeActionNames[viewType]);
            this.viewType = viewType;
            this.putValue("ActionCommandKey", switch (viewType) {
                case 0 -> FilePane.ACTION_VIEW_LIST;
                case 1 -> FilePane.ACTION_VIEW_DETAILS;
                default -> (String)this.getValue("Name");
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilePane.this.setViewType(this.viewType);
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -7099480042235528638L;

        protected FileRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (FilePane.this.listViewWindowsStyle && !list.isFocusOwner()) {
                isSelected = false;
            }
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            File file = (File)value;
            String fileName = FilePane.this.getFileChooser().getName(file);
            this.setText(fileName);
            this.setFont(list.getFont());
            Icon icon = FilePane.this.getFileChooser().getIcon(file);
            if (icon != null) {
                this.setIcon(icon);
                if (isSelected) {
                    FilePane.this.editX = icon.getIconWidth() + 4;
                }
            } else if (FilePane.this.getFileChooser().getFileSystemView().isTraversable(file).booleanValue()) {
                this.setText(fileName + File.separator);
            }
            return this;
        }
    }

    private class SortableListModel
    extends AbstractListModel<Object>
    implements TableModelListener,
    RowSorterListener {
        private static final long serialVersionUID = 7056739425130909334L;

        SortableListModel() {
            FilePane.this.getDetailsTableModel().addTableModelListener(this);
            FilePane.this.getRowSorter().addRowSorterListener(this);
        }

        @Override
        public int getSize() {
            return FilePane.this.getModel().getSize();
        }

        @Override
        public Object getElementAt(int index) {
            return FilePane.this.getModel().getElementAt(FilePane.this.getRowSorter().convertRowIndexToModel(index));
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public void sorterChanged(RowSorterEvent e) {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    private class Handler
    implements MouseListener {
        private MouseListener doubleClickListener;

        private Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            int index;
            JComponent source2 = (JComponent)evt.getSource();
            if (source2 instanceof JList) {
                index = FilePane.loc2IndexFileList(FilePane.this.list, evt.getPoint());
            } else if (source2 instanceof JTable) {
                JTable table = (JTable)source2;
                Point p = evt.getPoint();
                index = table.rowAtPoint(p);
                boolean pointOutsidePrefSize = FilePane.pointOutsidePrefSize(table, index, table.columnAtPoint(p), p);
                if (pointOutsidePrefSize && !FilePane.this.fullRowSelection) {
                    return;
                }
                if (index >= 0 && FilePane.this.list != null && FilePane.this.listSelectionModel.isSelectedIndex(index)) {
                    Rectangle r = FilePane.this.list.getCellBounds(index, index);
                    evt = new MouseEvent(FilePane.this.list, evt.getID(), evt.getWhen(), evt.getModifiersEx(), r.x + 1, r.y + r.height / 2, evt.getXOnScreen(), evt.getYOnScreen(), evt.getClickCount(), evt.isPopupTrigger(), evt.getButton());
                }
            } else {
                return;
            }
            if (index >= 0 && SwingUtilities.isLeftMouseButton(evt)) {
                JFileChooser fc = FilePane.this.getFileChooser();
                if (evt.getClickCount() == 1 && source2 instanceof JList) {
                    if ((!fc.isMultiSelectionEnabled() || fc.getSelectedFiles().length <= 1) && FilePane.this.listSelectionModel.isSelectedIndex(index) && FilePane.this.getEditIndex() == index && FilePane.this.editFile == null) {
                        FilePane.this.editFileName(index);
                    } else {
                        FilePane.this.setEditIndex(index);
                    }
                } else if (evt.getClickCount() == 2) {
                    FilePane.this.resetEditIndex();
                }
            }
            if (this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mouseClicked(evt);
            }
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            JComponent source2 = (JComponent)evt.getSource();
            if (source2 instanceof JTable) {
                boolean dragEnabled;
                TransferHandler th2;
                JTable table = (JTable)evt.getSource();
                TransferHandler th1 = FilePane.this.getFileChooser().getTransferHandler();
                if (th1 != (th2 = table.getTransferHandler())) {
                    table.setTransferHandler(th1);
                }
                if ((dragEnabled = FilePane.this.getFileChooser().getDragEnabled()) != table.getDragEnabled()) {
                    table.setDragEnabled(dragEnabled);
                }
            } else if (source2 instanceof JList && this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mouseEntered(evt);
            }
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            if (evt.getSource() instanceof JList && this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mouseExited(evt);
            }
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (evt.getSource() instanceof JList && this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mousePressed(evt);
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (evt.getSource() instanceof JList && this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mouseReleased(evt);
            }
        }

        private MouseListener getDoubleClickListener() {
            if (this.doubleClickListener == null && FilePane.this.list != null) {
                this.doubleClickListener = FilePane.this.fileChooserUIAccessor.createDoubleClickListener(FilePane.this.list);
            }
            return this.doubleClickListener;
        }
    }

    class DetailsTableModel
    extends AbstractTableModel
    implements ListDataListener {
        private static final long serialVersionUID = 6898830676567042099L;
        final JFileChooser chooser;
        final BasicDirectoryModel directoryModel;
        ShellFolderColumnInfo[] columns;
        int[] columnMap;

        DetailsTableModel(JFileChooser fc) {
            this.chooser = fc;
            this.directoryModel = FilePane.this.getModel();
            this.directoryModel.addListDataListener(this);
            this.updateColumnInfo();
        }

        void updateColumnInfo() {
            File dir = this.chooser.getCurrentDirectory();
            if (dir != null && FilePane.this.fileChooserUIAccessor.usesShellFolder()) {
                try {
                    dir = ShellFolder.getShellFolder(dir);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            ShellFolderColumnInfo[] allColumns = ShellFolder.getFolderColumns(dir);
            ArrayList<ShellFolderColumnInfo> visibleColumns = new ArrayList<ShellFolderColumnInfo>();
            this.columnMap = new int[allColumns.length];
            for (int i2 = 0; i2 < allColumns.length; ++i2) {
                ShellFolderColumnInfo column = allColumns[i2];
                if (!column.isVisible()) continue;
                this.columnMap[visibleColumns.size()] = i2;
                visibleColumns.add(column);
            }
            this.columns = new ShellFolderColumnInfo[visibleColumns.size()];
            visibleColumns.toArray(this.columns);
            this.columnMap = Arrays.copyOf(this.columnMap, this.columns.length);
            List<RowSorter.SortKey> sortKeys = FilePane.this.rowSorter == null ? null : FilePane.this.rowSorter.getSortKeys();
            this.fireTableStructureChanged();
            this.restoreSortKeys(sortKeys);
        }

        private void restoreSortKeys(List<RowSorter.SortKey> sortKeys) {
            if (sortKeys != null) {
                for (int i2 = 0; i2 < sortKeys.size(); ++i2) {
                    RowSorter.SortKey sortKey = sortKeys.get(i2);
                    if (sortKey.getColumn() < this.columns.length) continue;
                    sortKeys = null;
                    break;
                }
                if (sortKeys != null) {
                    FilePane.this.rowSorter.setSortKeys(sortKeys);
                }
            }
        }

        @Override
        public int getRowCount() {
            return this.directoryModel.getSize();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.getFileColumnValue((File)this.directoryModel.getElementAt(row), col);
        }

        private Object getFileColumnValue(File f, int col) {
            return col == 0 ? f : ShellFolder.getFolderColumnValue(f, this.columnMap[col]);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                JFileChooser chooser = FilePane.this.getFileChooser();
                File f = (File)this.getValueAt(row, col);
                if (f != null) {
                    String oldDisplayName = chooser.getName(f);
                    String oldFileName = f.getName();
                    String newDisplayName = ((String)value).trim();
                    if (!newDisplayName.equals(oldDisplayName)) {
                        FileSystemView fsv;
                        File f2;
                        int i2;
                        Object newFileName = newDisplayName;
                        int i1 = oldFileName.length();
                        if (i1 > (i2 = oldDisplayName.length()) && oldFileName.charAt(i2) == '.') {
                            newFileName = newDisplayName + oldFileName.substring(i2);
                        }
                        if (!(f2 = (fsv = chooser.getFileSystemView()).createFileObject(f.getParentFile(), (String)newFileName)).exists()) {
                            if (FilePane.this.getModel().renameFile(f, f2)) {
                                if (fsv.isParent(chooser.getCurrentDirectory(), f2)) {
                                    if (chooser.isMultiSelectionEnabled()) {
                                        chooser.setSelectedFiles(new File[]{f2});
                                    } else {
                                        chooser.setSelectedFile(f2);
                                    }
                                }
                            } else {
                                JOptionPane.showMessageDialog(chooser, MessageFormat.format(FilePane.this.renameErrorText, oldFileName), FilePane.this.renameErrorTitleText, 0);
                            }
                        }
                    }
                }
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            File currentDirectory = FilePane.this.getFileChooser().getCurrentDirectory();
            return !FilePane.this.readOnly && column == 0 && FilePane.this.canWrite(currentDirectory);
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            new DelayedSelectionUpdater();
            this.fireTableDataChanged();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            File file;
            int i1;
            int i0 = e.getIndex0();
            if (i0 == (i1 = e.getIndex1()) && (file = (File)FilePane.this.getModel().getElementAt(i0)).equals(FilePane.this.newFolderFile)) {
                new DelayedSelectionUpdater(file);
                FilePane.this.newFolderFile = null;
            }
            this.fireTableRowsInserted(e.getIndex0(), e.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.fireTableRowsDeleted(e.getIndex0(), e.getIndex1());
        }

        ShellFolderColumnInfo[] getColumns() {
            return this.columns;
        }
    }

    private class DetailsTableCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 7059979171474189234L;
        private final JTextField tf;

        DetailsTableCellEditor(JTextField tf) {
            super(tf);
            this.tf = tf;
            tf.setName("Table.editor");
            tf.addFocusListener(FilePane.this.editorFocusListener);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (value instanceof File) {
                this.tf.setText(FilePane.this.getFileChooser().getName((File)value));
                this.tf.selectAll();
            }
            return comp;
        }
    }

    private class DetailsTableRowSorter
    extends TableRowSorter {
        DetailsTableRowSorter() {
            this.setModelWrapper(new SorterModelWrapper());
        }

        void updateComparators(ShellFolderColumnInfo[] columns) {
            for (int i2 = 0; i2 < columns.length; ++i2) {
                DirectoriesFirstComparatorWrapper c = columns[i2].getComparator();
                if (c != null) {
                    c = new DirectoriesFirstComparatorWrapper(i2, c);
                }
                this.setComparator(i2, c);
            }
        }

        @Override
        public void modelStructureChanged() {
            super.modelStructureChanged();
            this.updateComparators(FilePane.this.detailsTableModel.getColumns());
        }

        private class SorterModelWrapper
        extends DefaultRowSorter.ModelWrapper<Object, Object> {
            private SorterModelWrapper() {
            }

            @Override
            public Object getModel() {
                return FilePane.this.getDetailsTableModel();
            }

            @Override
            public int getColumnCount() {
                return FilePane.this.getDetailsTableModel().getColumnCount();
            }

            @Override
            public int getRowCount() {
                return FilePane.this.getDetailsTableModel().getRowCount();
            }

            @Override
            public Object getValueAt(int row, int column) {
                return FilePane.this.getModel().getElementAt(row);
            }

            @Override
            public Object getIdentifier(int row) {
                return row;
            }
        }
    }

    private class AlignableTableHeaderRenderer
    implements TableCellRenderer {
        final TableCellRenderer wrappedRenderer;

        AlignableTableHeaderRenderer(TableCellRenderer wrappedRenderer) {
            this.wrappedRenderer = wrappedRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.wrappedRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int modelColumn = table.convertColumnIndexToModel(column);
            ShellFolderColumnInfo columnInfo = FilePane.this.detailsTableModel.getColumns()[modelColumn];
            Integer alignment = columnInfo.getAlignment();
            if (alignment == null) {
                alignment = 0;
            }
            if (c instanceof JLabel) {
                ((JLabel)c).setHorizontalAlignment(alignment);
            }
            return c;
        }
    }

    class DetailsTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 4795829282408806063L;
        final JFileChooser chooser;
        final DateFormat df;

        DetailsTableCellRenderer(JFileChooser chooser) {
            this.chooser = chooser;
            this.df = DateFormat.getDateTimeInstance(3, 3, chooser.getLocale());
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            if (this.getHorizontalAlignment() == 10 && !FilePane.this.fullRowSelection) {
                width = Math.min(width, this.getPreferredSize().width + 4);
            } else {
                x -= 4;
            }
            super.setBounds(x, y, width, height);
        }

        @Override
        public Insets getInsets(Insets i2) {
            i2 = super.getInsets(i2);
            i2.left += 4;
            i2.right += 4;
            return i2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String text;
            if ((table.convertColumnIndexToModel(column) != 0 || FilePane.this.listViewWindowsStyle && !table.isFocusOwner()) && !FilePane.this.fullRowSelection) {
                isSelected = false;
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setIcon(null);
            int modelColumn = table.convertColumnIndexToModel(column);
            ShellFolderColumnInfo columnInfo = FilePane.this.detailsTableModel.getColumns()[modelColumn];
            Integer alignment = columnInfo.getAlignment();
            if (alignment == null) {
                alignment = value instanceof Number ? 4 : 10;
            }
            this.setHorizontalAlignment(alignment);
            if (value == null) {
                text = "";
            } else if (value instanceof File) {
                File file = (File)value;
                text = this.chooser.getName(file);
                Icon icon = this.chooser.getIcon(file);
                this.setIcon(icon);
            } else if (value instanceof Long) {
                long len = (Long)value / 1024L;
                text = FilePane.this.listViewWindowsStyle ? MessageFormat.format(FilePane.this.kiloByteString, len + 1L) : (len < 1024L ? MessageFormat.format(FilePane.this.kiloByteString, len == 0L ? 1L : len) : ((len /= 1024L) < 1024L ? MessageFormat.format(FilePane.this.megaByteString, len) : MessageFormat.format(FilePane.this.gigaByteString, len /= 1024L)));
            } else {
                text = value instanceof Date ? this.df.format((Date)value) : value.toString();
            }
            this.setText(text);
            return this;
        }
    }

    class EditActionListener
    implements ActionListener {
        EditActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilePane.this.applyEdit();
        }
    }

    private class DelayedSelectionUpdater
    implements Runnable {
        File editFile;

        DelayedSelectionUpdater() {
            this(null);
        }

        DelayedSelectionUpdater(File editFile) {
            this.editFile = editFile;
            if (FilePane.this.isShowing()) {
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            FilePane.this.setFileSelected();
            if (this.editFile != null) {
                FilePane.this.editFileName(FilePane.this.getRowSorter().convertRowIndexToView(FilePane.this.getModel().indexOf(this.editFile)));
                this.editFile = null;
            }
        }
    }

    private class DirectoriesFirstComparatorWrapper
    implements Comparator<File> {
        private final Comparator<Object> comparator;
        private final int column;

        DirectoriesFirstComparatorWrapper(int column, Comparator<Object> comparator) {
            this.column = column;
            this.comparator = comparator;
        }

        @Override
        public int compare(File f1, File f2) {
            if (f1 != null && f2 != null) {
                boolean traversable1 = FilePane.this.getFileChooser().isTraversable(f1);
                boolean traversable2 = FilePane.this.getFileChooser().isTraversable(f2);
                if (traversable1 && !traversable2) {
                    return -1;
                }
                if (!traversable1 && traversable2) {
                    return 1;
                }
            }
            if (FilePane.this.detailsTableModel.getColumns()[this.column].isCompareByColumn()) {
                return this.comparator.compare(FilePane.this.getDetailsTableModel().getFileColumnValue(f1, this.column), FilePane.this.getDetailsTableModel().getFileColumnValue(f2, this.column));
            }
            return this.comparator.compare(f1, f2);
        }
    }
}

