/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.tabs;

import com.frostwire.gui.tabs.AbstractTab;
import com.frostwire.gui.tabs.SearchTab;
import com.frostwire.gui.tabs.TransfersTab;
import com.frostwire.gui.theme.ThemeMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.UISettings;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

public final class SearchTransfersTab
extends AbstractTab {
    private final JSplitPane searchDownloadSplitPane;

    public SearchTransfersTab(SearchTab searchTab, TransfersTab transfersTab) {
        super(I18n.tr("Search"), I18n.tr("Search and Download Files from the Internet."), "search_tab");
        this.searchDownloadSplitPane = new JSplitPane(0, searchTab.getComponent(), transfersTab.getComponent());
        this.searchDownloadSplitPane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ThemeMediator.LIGHT_BORDER_COLOR));
        this.searchDownloadSplitPane.setContinuousLayout(true);
        this.searchDownloadSplitPane.setResizeWeight(0.6);
        this.searchDownloadSplitPane.setDividerLocation(UISettings.UI_TRANSFERS_DIVIDER_LOCATION.getValue());
        this.searchDownloadSplitPane.addPropertyChangeListener("lastDividerLocation", evt -> {
            JSplitPane splitPane = (JSplitPane)evt.getSource();
            int current = splitPane.getDividerLocation();
            if (splitPane.getSize().height - current < 150) {
                splitPane.setDividerLocation(splitPane.getSize().height - 150);
            }
            UISettings.UI_TRANSFERS_DIVIDER_LOCATION.setValue(splitPane.getDividerLocation());
        });
    }

    @Override
    public JComponent getComponent() {
        return this.searchDownloadSplitPane;
    }

    public void setDividerLocation(int newLocation) {
        this.searchDownloadSplitPane.setDividerLocation(newLocation);
    }
}

