/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.searchfield;

import com.frostwire.gui.searchfield.AbstractUIChangeHandler;
import com.frostwire.gui.searchfield.BuddySupport;
import com.frostwire.gui.searchfield.BuddyTextFieldUI;
import com.frostwire.gui.searchfield.JXSearchField;
import com.frostwire.gui.searchfield.PromptTextUI;
import com.frostwire.gui.searchfield.SearchFieldUI;
import java.beans.PropertyChangeEvent;
import javax.swing.JTextField;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;

public abstract class TextUIWrapper<UI extends TextUI> {
    private static final DefaultWrapper defaultWrapper = new DefaultWrapper();
    private final TextUIChangeHandler uiChangeHandler = new TextUIChangeHandler();
    private final Class<UI> wrapperClass;

    TextUIWrapper(Class<UI> wrapperClass) {
        this.wrapperClass = wrapperClass;
    }

    public static TextUIWrapper<? extends PromptTextUI> getDefaultWrapper() {
        return defaultWrapper;
    }

    public final void install(JTextComponent textComponent, boolean stayOnUIChange) {
        this.replaceUIIfNeeded(textComponent);
        if (stayOnUIChange) {
            this.uiChangeHandler.install(textComponent);
        }
    }

    boolean replaceUIIfNeeded(JTextComponent textComponent) {
        if (this.wrapperClass.isAssignableFrom(textComponent.getUI().getClass())) {
            return false;
        }
        textComponent.setUI((TextUI)this.wrapUI(textComponent));
        return true;
    }

    protected abstract UI wrapUI(JTextComponent var1);

    public final void uninstall(JTextComponent textComponent) {
        this.uiChangeHandler.uninstall(textComponent);
        textComponent.updateUI();
    }

    private final class TextUIChangeHandler
    extends AbstractUIChangeHandler {
        private TextUIChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JTextComponent txt = (JTextComponent)evt.getSource();
            TextUIWrapper.this.replaceUIIfNeeded(txt);
        }
    }

    public static final class DefaultWrapper
    extends TextUIWrapper<PromptTextUI> {
        private DefaultWrapper() {
            super(PromptTextUI.class);
        }

        @Override
        public PromptTextUI wrapUI(JTextComponent textComponent) {
            TextUI textUI = textComponent.getUI();
            if (textUI instanceof PromptTextUI) {
                return (PromptTextUI)textUI;
            }
            if (textUI instanceof BasicTextFieldUI) {
                if (textComponent instanceof JXSearchField) {
                    return new SearchFieldUI(textUI);
                }
                return new BuddyTextFieldUI(textUI);
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected boolean replaceUIIfNeeded(JTextComponent textComponent) {
            boolean replaced = super.replaceUIIfNeeded(textComponent);
            if (replaced && textComponent instanceof JTextField) {
                BuddySupport.ensureBuddiesAreInComponentHierarchy((JTextField)textComponent);
            }
            return replaced;
        }
    }
}

