/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.searchfield;

import com.frostwire.gui.searchfield.TextUIWrapper;
import java.awt.Color;
import javax.swing.text.JTextComponent;

public class PromptSupport {
    private static final String PROMPT = "promptText";
    private static final String FOREGROUND = "promptForeground";
    private static final String BACKGROUND = "promptBackground";
    private static final String FOCUS_BEHAVIOR = "focusBehavior";
    private static final String FONT_STYLE = "promptFontStyle";

    public static void init(String promptText, Color promptForeground, Color promptBackground, JTextComponent textComponent) {
        if (promptText != null && promptText.length() > 0) {
            PromptSupport.setPrompt(promptText, textComponent);
        }
        if (promptForeground != null) {
            PromptSupport.setForeground(promptForeground, textComponent);
        }
        if (promptBackground != null) {
            PromptSupport.setBackground(promptBackground, textComponent);
        }
    }

    static FocusBehavior getFocusBehavior(JTextComponent textComponent) {
        FocusBehavior fb = (FocusBehavior)((Object)textComponent.getClientProperty(FOCUS_BEHAVIOR));
        if (fb == null) {
            fb = FocusBehavior.HIDE_PROMPT;
        }
        return fb;
    }

    static void setFocusBehavior(FocusBehavior focusBehavior, JTextComponent textComponent) {
        textComponent.putClientProperty(FOCUS_BEHAVIOR, (Object)focusBehavior);
        if (textComponent.isFocusOwner()) {
            textComponent.repaint();
        }
    }

    static String getPrompt(JTextComponent textComponent) {
        return (String)textComponent.getClientProperty(PROMPT);
    }

    public static void setPrompt(String promptText, JTextComponent textComponent) {
        TextUIWrapper.getDefaultWrapper().install(textComponent, true);
        if (textComponent.getToolTipText() == null || textComponent.getToolTipText().equals(PromptSupport.getPrompt(textComponent))) {
            textComponent.setToolTipText(promptText);
        }
        textComponent.putClientProperty(PROMPT, promptText);
        textComponent.repaint();
    }

    public static Color getForeground(JTextComponent textComponent) {
        if (textComponent.getClientProperty(FOREGROUND) == null) {
            return textComponent.getDisabledTextColor();
        }
        return (Color)textComponent.getClientProperty(FOREGROUND);
    }

    private static void setForeground(Color promptTextColor, JTextComponent textComponent) {
        textComponent.putClientProperty(FOREGROUND, promptTextColor);
        textComponent.repaint();
    }

    public static Color getBackground(JTextComponent textComponent) {
        if (textComponent.getClientProperty(BACKGROUND) == null) {
            return textComponent.getBackground();
        }
        return (Color)textComponent.getClientProperty(BACKGROUND);
    }

    private static void setBackground(Color background, JTextComponent textComponent) {
        TextUIWrapper.getDefaultWrapper().install(textComponent, true);
        textComponent.putClientProperty(BACKGROUND, background);
        textComponent.repaint();
    }

    static void setFontStyle(Integer fontStyle, JTextComponent textComponent) {
        textComponent.putClientProperty(FONT_STYLE, fontStyle);
        textComponent.revalidate();
        textComponent.repaint();
    }

    static Integer getFontStyle(JTextComponent textComponent) {
        return (Integer)textComponent.getClientProperty(FONT_STYLE);
    }

    public static enum FocusBehavior {
        HIGHLIGHT_PROMPT,
        HIDE_PROMPT;

    }
}

