/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.searchfield;

import com.frostwire.gui.searchfield.BuddyButton;
import com.frostwire.gui.searchfield.JXSearchFieldAddon;
import com.frostwire.gui.searchfield.JXTextField;
import com.frostwire.gui.searchfield.NativeSearchFieldSupport;
import com.frostwire.gui.searchfield.TextUIWrapper;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class JXSearchField
extends JXTextField {
    private static final long serialVersionUID = -6555528038058656677L;
    private static final int DEFAULT_INSTANT_SEARCH_DELAY = 180;
    private static final KeyStroke CANCEL_KEY = KeyStroke.getKeyStroke(27, 0);
    private JButton findButton;
    private JButton cancelButton;
    private JButton popupButton;
    private LayoutStyle layoutStyle;
    private SearchMode searchMode = SearchMode.INSTANT;
    private boolean useSeperatePopupButton;
    private boolean useSeperatePopupButtonSet;
    private boolean layoutStyleSet;
    private int instantSearchDelay = 180;
    private boolean promptFontStyleSet;
    private Timer instantSearchTimer;

    JXSearchField() {
        this("");
    }

    private JXSearchField(String prompt) {
        super(prompt);
        this.setUseNativeSearchFieldIfPossible(true);
        this.setCancelAction(new ClearAction());
        this.setFindAction(new FindAction());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (CANCEL_KEY.equals(KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiersEx()))) {
                    JXSearchField.this.getCancelAction().actionPerformed(new ActionEvent(JXSearchField.this, e.getID(), KeyEvent.getKeyText(e.getKeyCode())));
                }
            }
        });
        this.addPropertyChangeListener("JTextField.Search.FindPopup", evt -> {
            JPopupMenu oldPopup = (JPopupMenu)evt.getOldValue();
            this.firePropertyChange("findPopupMenu", oldPopup, evt.getNewValue());
        });
        this.addPropertyChangeListener("JTextField.Search.CancelAction", evt -> {
            ActionListener oldAction = (ActionListener)evt.getOldValue();
            this.firePropertyChange("cancelAction", oldAction, evt.getNewValue());
        });
        this.addPropertyChangeListener("JTextField.Search.FindAction", evt -> {
            ActionListener oldAction = (ActionListener)evt.getOldValue();
            this.firePropertyChange("findAction", oldAction, evt.getNewValue());
        });
    }

    private SearchMode getSearchMode() {
        return this.searchMode;
    }

    public void setSearchMode(SearchMode searchMode) {
        this.searchMode = searchMode;
        this.firePropertyChange("searchMode", (Object)this.searchMode, (Object)this.searchMode);
    }

    boolean isInstantSearchMode() {
        return SearchMode.INSTANT.equals((Object)this.getSearchMode());
    }

    boolean isRegularSearchMode() {
        return SearchMode.REGULAR.equals((Object)this.getSearchMode());
    }

    int getInstantSearchDelay() {
        return this.instantSearchDelay;
    }

    public void setInstantSearchDelay(int instantSearchDelay) {
        this.instantSearchDelay = instantSearchDelay;
        this.firePropertyChange("instantSearchDelay", this.instantSearchDelay, this.instantSearchDelay);
    }

    LayoutStyle getLayoutStyle() {
        return this.layoutStyle;
    }

    private void setLayoutStyle(LayoutStyle layoutStyle) {
        this.layoutStyleSet = true;
        this.layoutStyle = layoutStyle;
        this.firePropertyChange("layoutStyle", (Object)this.layoutStyle, (Object)this.layoutStyle);
    }

    boolean isVistaLayoutStyle() {
        return LayoutStyle.VISTA.equals((Object)this.getLayoutStyle());
    }

    boolean isMacLayoutStyle() {
        return LayoutStyle.MAC.equals((Object)this.getLayoutStyle());
    }

    @Override
    public void setMargin(Insets m) {
        super.setMargin(m);
    }

    private ActionListener getCancelAction() {
        ActionListener a = NativeSearchFieldSupport.getCancelAction(this);
        if (a == null) {
            a = new ClearAction();
        }
        return a;
    }

    private void setCancelAction(ActionListener cancelAction) {
        NativeSearchFieldSupport.setCancelAction(this, cancelAction);
    }

    final JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = this.createCancelButton();
            this.cancelButton.addActionListener(e -> this.getCancelAction().actionPerformed(e));
        }
        return this.cancelButton;
    }

    private JButton createCancelButton() {
        return new BuddyButton();
    }

    private ActionListener getFindAction() {
        ActionListener a = NativeSearchFieldSupport.getFindAction(this);
        if (a == null) {
            a = new FindAction();
        }
        return a;
    }

    private void setFindAction(ActionListener findAction) {
        NativeSearchFieldSupport.setFindAction(this, findAction);
    }

    final JButton getFindButton() {
        if (this.findButton == null) {
            this.findButton = this.createFindButton();
            this.findButton.addActionListener(e -> this.getFindAction().actionPerformed(e));
        }
        return this.findButton;
    }

    private JButton createFindButton() {
        return new BuddyButton();
    }

    final JButton getPopupButton() {
        if (this.popupButton == null) {
            this.popupButton = this.createPopupButton();
        }
        return this.popupButton;
    }

    private JButton createPopupButton() {
        return new BuddyButton();
    }

    boolean isUseSeperatePopupButton() {
        return this.useSeperatePopupButton;
    }

    private void setUseSeparatePopupButton(boolean useSeperatePopupButton) {
        this.useSeperatePopupButtonSet = true;
        this.useSeperatePopupButton = useSeperatePopupButton;
        this.firePropertyChange("useSeperatePopupButton", this.useSeperatePopupButton, this.useSeperatePopupButton);
    }

    private void setUseNativeSearchFieldIfPossible(boolean useNativeSearchFieldIfPossible) {
        TextUIWrapper.getDefaultWrapper().uninstall(this);
        NativeSearchFieldSupport.setSearchField(this, useNativeSearchFieldIfPossible);
        TextUIWrapper.getDefaultWrapper().install(this, true);
        this.updateUI();
    }

    @Override
    public void setEditable(boolean b) {
        super.setEditable(b);
        this.updateButtonState();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateButtonState();
    }

    private void updateButtonState() {
        this.getCancelButton().setEnabled(this.isEditable() & this.isEnabled());
        this.getFindButton().setEnabled(this.isEnabled());
        this.getPopupButton().setEnabled(this.isEnabled());
    }

    JPopupMenu getFindPopupMenu() {
        return NativeSearchFieldSupport.getFindPopupMenu(this);
    }

    void setFindPopupMenu(JPopupMenu findPopupMenu) {
        if (this.isManagingRecentSearches()) {
            return;
        }
        NativeSearchFieldSupport.setFindPopupMenu(this, findPopupMenu);
    }

    private boolean isManagingRecentSearches() {
        return false;
    }

    Timer getInstantSearchTimer() {
        if (this.instantSearchTimer == null) {
            this.instantSearchTimer = new Timer(0, e -> this.postActionEvent());
            this.instantSearchTimer.setRepeats(false);
        }
        return this.instantSearchTimer;
    }

    @Override
    public boolean hasFocus() {
        if (this.getFindPopupMenu() != null && this.getFindPopupMenu().isVisible()) {
            return true;
        }
        return super.hasFocus();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.getFindPopupMenu() != null) {
            SwingUtilities.updateComponentTreeUI(this.getFindPopupMenu());
        }
    }

    @Override
    public void setPromptFontStyle(Integer fontStyle) {
        super.setPromptFontStyle(fontStyle);
        this.promptFontStyleSet = true;
    }

    void customSetUIProperty(String propertyName, Object value) {
        this.customSetUIProperty(propertyName, value, false);
    }

    private void customSetUIProperty(String propertyName, Object value, boolean override) {
        if ("useSeperatePopupButton".equals(propertyName)) {
            if (!this.useSeperatePopupButtonSet || override) {
                this.setUseSeparatePopupButton((Boolean)value);
                this.useSeperatePopupButtonSet = false;
            }
        } else if ("layoutStyle".equals(propertyName)) {
            if (!this.layoutStyleSet || override) {
                this.setLayoutStyle(LayoutStyle.valueOf(value.toString()));
                this.layoutStyleSet = false;
            }
        } else if ("promptFontStyle".equals(propertyName)) {
            if (!this.promptFontStyleSet || override) {
                this.setPromptFontStyle((Integer)value);
                this.promptFontStyleSet = false;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void postActionEvent() {
        this.getInstantSearchTimer().stop();
        super.postActionEvent();
    }

    static {
        new JXSearchFieldAddon().addDefaults();
    }

    public static enum SearchMode {
        REGULAR,
        INSTANT;

    }

    class ClearAction
    extends AbstractAction {
        private static final long serialVersionUID = -3349455592229414653L;

        ClearAction() {
            this.putValue("ShortDescription", "Clear Search Text");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.clear();
        }

        void clear() {
            JXSearchField.this.setText(null);
            JXSearchField.this.requestFocusInWindow();
        }
    }

    public class FindAction
    extends AbstractAction {
        private static final long serialVersionUID = 6512288404613230232L;

        FindAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JXSearchField.this.isFocusOwner() && JXSearchField.this.isRegularSearchMode()) {
                JXSearchField.this.postActionEvent();
            }
            JXSearchField.this.requestFocusInWindow();
            JXSearchField.this.selectAll();
        }
    }

    public static enum LayoutStyle {
        VISTA,
        MAC;

    }
}

