/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.searchfield;

import com.frostwire.gui.searchfield.JXSearchField;
import com.frostwire.gui.searchfield.SearchField;
import com.frostwire.gui.theme.ThemeMediator;
import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.OSUtils;
import com.frostwire.util.http.HttpClient;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.FileMenuActions;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.util.URLDecoder;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.limewire.util.LCS;
import org.limewire.util.StringUtils;

public class GoogleSearchField
extends SearchField {
    private static final String SUGGESTIONS_URL = GoogleSearchField.buildSuggestionsUrl();
    private static final int HTTP_QUERY_TIMEOUT = 1000;
    private SuggestionsThread suggestionsThread;
    public static final String CLOUD_SEARCH_FIELD_HINT_TEXT = I18n.tr("Search or enter target URL");
    private static String lastClipboardSearchQuery = null;

    public GoogleSearchField() {
        this.dict = this.createDefaultDictionary();
        this.setPrompt(I18n.tr("Hints by Google"));
        this.setSearchMode(JXSearchField.SearchMode.REGULAR);
        GoogleSearchField.initCloudSearchField(this);
    }

    private static String buildSuggestionsUrl() {
        String lang = ApplicationSettings.LANGUAGE.getValue();
        if (StringUtils.isNullOrEmpty(lang)) {
            lang = "en";
        }
        return "https://clients1.google.com/complete/search?client=youtube&q=%s&hl=" + lang + "&gl=us&gs_rn=23&gs_ri=youtube&ds=yt&cp=2&gs_id=8&callback=google.sbox.p50";
    }

    @Override
    public void autoCompleteInput() {
        String input = this.getText();
        if (input != null && input.length() > 0) {
            if (this.suggestionsThread != null) {
                this.suggestionsThread.cancel();
            }
            if (this.getAutoComplete()) {
                this.suggestionsThread = new SuggestionsThread(input, this);
                this.suggestionsThread.start();
            }
        } else {
            this.hidePopup();
        }
    }

    @Override
    public void setText(String t) {
        try {
            if (t != null) {
                t = t.replace("<html>", "").replace("</html>", "").replace("<b>", "").replace("</b>", "");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        super.setText(t);
    }

    public static void eraseLastClipboardSearchQuery() {
        lastClipboardSearchQuery = null;
    }

    public static void initCloudSearchField(final GoogleSearchField cloudSearchField) {
        cloudSearchField.addActionListener(new SearchListener(cloudSearchField));
        cloudSearchField.setPrompt(CLOUD_SEARCH_FIELD_HINT_TEXT);
        Font origFont = cloudSearchField.getFont();
        Font newFont = origFont.deriveFont(origFont.getSize2D() + 2.0f);
        cloudSearchField.setFont(newFont);
        cloudSearchField.setMargin(new Insets(0, 2, 0, 0));
        cloudSearchField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (cloudSearchField.getText().equals(CLOUD_SEARCH_FIELD_HINT_TEXT)) {
                    cloudSearchField.setText("");
                }
            }
        });
        cloudSearchField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!SearchSettings.AUTO_SEARCH_CLIPBOARD_URL.getValue()) {
                    return;
                }
                Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                String s = GUIUtils.extractStringContentFromClipboard(systemClipboard);
                if (s == null || "".equals(s)) {
                    return;
                }
                if (lastClipboardSearchQuery != null && lastClipboardSearchQuery.equals(s)) {
                    return;
                }
                if (s.startsWith("http") || s.startsWith("magnet")) {
                    cloudSearchField.setText(s);
                    lastClipboardSearchQuery = s;
                    cloudSearchField.getActionListeners()[0].actionPerformed(null);
                    cloudSearchField.setText("");
                }
            }
        });
    }

    @Override
    protected JComponent getPopupComponent() {
        Font origFont;
        if (this.entryPanel != null) {
            return this.entryPanel;
        }
        this.entryPanel = new JPanel(new GridBagLayout());
        this.entryPanel.setBorder(UIManager.getBorder("List.border"));
        this.entryPanel.setBackground(UIManager.getColor("List.background"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        this.entryList = new SearchField.AutoCompleteList(this);
        JScrollPane entryScrollPane = new JScrollPane(this.entryList);
        entryScrollPane.setVerticalScrollBarPolicy(20);
        entryScrollPane.setHorizontalScrollBarPolicy(31);
        this.entryPanel.add((Component)entryScrollPane, c);
        Font newFont = origFont = this.getFont();
        if (OSUtils.isWindows()) {
            newFont = ThemeMediator.DIALOG_FONT.deriveFont(origFont.getSize2D());
        }
        this.entryList.setFont(newFont);
        return this.entryPanel;
    }

    private static final class SuggestionsThread
    extends Thread {
        private final String constraint;
        private final GoogleSearchField input;
        private boolean cancelled;

        SuggestionsThread(String constraint, GoogleSearchField input) {
            this.constraint = constraint;
            this.input = input;
            this.setName("SuggestionsThread: " + constraint);
            this.setDaemon(true);
        }

        boolean isCancelled() {
            return this.cancelled;
        }

        void cancel() {
            this.cancelled = true;
        }

        @Override
        public void run() {
            try {
                String url = String.format(SUGGESTIONS_URL, URLEncoder.encode(this.constraint, StandardCharsets.UTF_8));
                HttpClient httpClient = HttpClientFactory.getInstance(HttpClientFactory.HttpContext.MISC);
                String js = httpClient.get(url, 1000);
                String json = this.stripJs(js);
                if (!this.isCancelled()) {
                    JsonArray arr = JsonParser.parseString(json).getAsJsonArray();
                    List<String> suggestions = this.readSuggestions(arr.get(1).getAsJsonArray());
                    GUIMediator.safeInvokeLater(() -> {
                        Iterator<String> it = suggestions.iterator();
                        if (it.hasNext()) {
                            if (!StringUtils.isNullOrEmpty(this.input.getText(), true)) {
                                this.input.showPopup(it);
                            } else {
                                this.input.hidePopup();
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private List<String> readSuggestions(JsonArray array) {
            String t = this.input.getText();
            ArrayList<String> suggestions = new ArrayList<String>(array.size());
            if (!StringUtils.isNullOrEmpty(t, true)) {
                for (int i2 = 0; i2 < array.size(); ++i2) {
                    try {
                        String s = LCS.lcsHtml(t, array.get(i2).getAsJsonArray().get(0).getAsString());
                        suggestions.add(s);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            return suggestions;
        }

        private String stripJs(String js) {
            js = js.replace("google.sbox.p50 && google.sbox.p50(", "");
            js = js.replace("}])", "}]");
            return js;
        }
    }

    public static class SearchListener
    implements ActionListener {
        private final GoogleSearchField cloudSearchField;

        public SearchListener(GoogleSearchField searchField) {
            this.cloudSearchField = searchField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String query;
            String queryTitle = query = this.cloudSearchField.getText();
            GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
            if (FileMenuActions.openMagnetOrTorrent(query)) {
                this.cloudSearchField.setText("");
                this.cloudSearchField.hidePopup();
                return;
            }
            if (query.contains("www.frostclick.com/cloudplayer/?type=yt") || query.contains("frostwire-preview.com/?type=yt")) {
                try {
                    query = query.split("detailsUrl=")[1];
                    query = URLDecoder.decode(query);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            SearchInformation info = SearchInformation.createTitledKeywordSearch(query, null, MediaType.getTorrentMediaType(), queryTitle);
            if (SearchMediator.instance().triggerSearch(info) != 0L && info.isKeywordSearch()) {
                this.cloudSearchField.addToDictionary();
                this.cloudSearchField.setText("");
                this.cloudSearchField.hidePopup();
            }
        }
    }
}

