/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.player;

import java.io.File;

public class MediaSource {
    private final File file;
    private final String url;
    String titleText;
    String toolTipText;

    public MediaSource(File file) {
        if (file == null) {
            throw new NullPointerException("File cannot be null");
        }
        this.file = file;
        this.url = null;
        this.titleText = this.file.getName();
        this.toolTipText = this.file.getAbsolutePath();
    }

    MediaSource(String url) {
        if (url == null) {
            throw new NullPointerException("Url cannot be null");
        }
        this.file = null;
        this.url = url;
        this.titleText = "internet ";
        this.toolTipText = "";
    }

    public String toString() {
        String name = this.getFile() != null ? this.getFile().getName() : this.url;
        return "[MediaSource@" + this.hashCode() + ": " + name + "]";
    }

    public File getFile() {
        return this.file;
    }

    public String getURL() {
        return this.url;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MediaSource)) {
            return false;
        }
        MediaSource o = (MediaSource)obj;
        if (this.file != null && o.file != null) {
            return this.file.equals(o.file);
        }
        if (this.url != null && o.url != null) {
            return this.url.equals(o.url);
        }
        return false;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public boolean isFile() {
        return this.file != null;
    }

    public boolean isURL() {
        return this.url != null;
    }
}

