/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.player;

import com.frostwire.gui.bittorrent.SendFileProgressDialog;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.library.tags.TagsData;
import com.frostwire.gui.library.tags.TagsReader;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.player.MediaPlayerListener;
import com.frostwire.gui.player.MediaSource;
import com.frostwire.gui.player.RepeatMode;
import com.frostwire.gui.player.StreamMediaSource;
import com.frostwire.gui.theme.ThemeMediator;
import com.frostwire.mplayer.MediaPlaybackState;
import com.frostwire.util.Logger;
import com.frostwire.util.StringUtils;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MediaButton;
import com.limegroup.gnutella.gui.RefreshListener;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;

public final class MediaPlayerComponent
implements MediaPlayerListener,
RefreshListener {
    private static final Logger LOG = Logger.getLogger(MediaPlayerComponent.class);
    private static final int MAX_TITLE_CHARS = 36;
    private static final int BOUND_TITLE_CHARS = 18;
    private final MediaButton PLAY_BUTTON = new MediaButton(I18n.tr("Play") + " (" + I18n.tr("Long Press to Stop Playback") + ")", "play_up", "play_dn");
    private final MediaButton PAUSE_BUTTON = new MediaButton(I18n.tr("Pause") + " (" + I18n.tr("Long Press to Stop Playback") + ")", "pause_up", "pause_dn");
    private final MediaButton NEXT_BUTTON = new MediaButton(I18n.tr("Next"), "forward_up", "forward_dn");
    private final MediaButton PREV_BUTTON = new MediaButton(I18n.tr("Previous"), "rewind_up", "rewind_dn");
    private final JSlider VOLUME = new JSlider();
    private final JProgressBar PROGRESS = new JProgressBar();
    private final JLabel progressCurrentTime = new JLabel("--:--:--");
    private final JLabel progressSongLength = new JLabel("--:--:--");
    private final MediaPlayer mediaPlayer;
    private final Dimension progressBarDimension = new Dimension(245, 10);
    private JPanel PLAY_PAUSE_BUTTON_CONTAINER;
    private MediaSource currentPlayListItem;
    private JPanel myMediaPanel = null;
    private JToggleButton SHUFFLE_BUTTON;
    private JButton LOOP_BUTTON;
    private CardLayout PLAY_PAUSE_CARD_LAYOUT;
    private JLabel trackTitle;
    private MediaButton shareButton;
    private MediaButton socialButton;
    private MediaButton mediaSourceButton;
    private final Pattern facebookURLPattern = Pattern.compile("http(s)?\\:\\/\\/(www\\.)?facebook\\.com\\/([\\w-]+)");
    private final Pattern twitterURLPattern = Pattern.compile("http(s)?\\:\\/\\/(www\\.)?twitter\\.com\\/([\\w\\p{L}_]*[\\:|\\.]?\\s?)+");
    private final Pattern twitterUsernamePattern = Pattern.compile("(@[\\w\\p{L}_]*[\\:|\\.]?\\s?)+");
    private Timer longPressTimer;

    public MediaPlayerComponent() {
        this.mediaPlayer = MediaPlayer.instance();
        this.mediaPlayer.addMediaPlayerListener(this);
        GUIMediator.addRefreshListener(this);
    }

    public JPanel getMediaPanel() {
        if (this.myMediaPanel == null) {
            this.myMediaPanel = this.constructMediaPanel();
        }
        return this.myMediaPanel;
    }

    private JPanel constructMediaPanel() {
        this.PROGRESS.setMinimumSize(this.progressBarDimension);
        this.PROGRESS.setPreferredSize(this.progressBarDimension);
        this.PROGRESS.setMaximum(3600);
        this.PROGRESS.setEnabled(false);
        this.VOLUME.setMinimum(0);
        this.VOLUME.setValue(50);
        this.VOLUME.setMaximum(100);
        this.VOLUME.setEnabled(true);
        this.VOLUME.setOpaque(false);
        this.VOLUME.setToolTipText(I18n.tr("Volume"));
        this.registerListeners();
        JPanel panel = new JPanel();
        panel.setLayout(new MigLayout("insets 0, gap 0, fillx", "[][]"));
        panel.setPreferredSize(new Dimension(480, 55));
        panel.setMinimumSize(new Dimension(480, 55));
        panel.setMaximumSize(new Dimension(480, 55));
        panel.add((Component)this.createPlaybackButtonsPanel(), "span 1 2,growy, gapright 0");
        panel.add((Component)this.createTrackDetailPanel(), "wrap, w 345px");
        panel.add((Component)this.createProgressPanel(), "w 345px");
        return panel;
    }

    private JPanel createPlaybackButtonsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new MigLayout("insets 0, filly"));
        panel.add((Component)ThemeMediator.createAppHeaderSeparator(), "growy");
        panel.add((Component)this.PREV_BUTTON, "w 30px!");
        this.PLAY_PAUSE_CARD_LAYOUT = new CardLayout();
        this.PLAY_PAUSE_BUTTON_CONTAINER = new JPanel(this.PLAY_PAUSE_CARD_LAYOUT);
        this.PLAY_PAUSE_BUTTON_CONTAINER.setOpaque(false);
        this.PLAY_PAUSE_BUTTON_CONTAINER.add((Component)this.PLAY_BUTTON, "PLAY");
        this.PLAY_PAUSE_BUTTON_CONTAINER.add((Component)this.PAUSE_BUTTON, "PAUSE");
        panel.add((Component)this.PLAY_PAUSE_BUTTON_CONTAINER, "w 36px!");
        panel.add((Component)this.NEXT_BUTTON, "w 30px!");
        panel.add((Component)ThemeMediator.createAppHeaderSeparator(), "growy");
        return panel;
    }

    private JPanel createTrackDetailPanel() {
        JPanel panel = new JPanel();
        Cursor theHand = new Cursor(12);
        panel.setLayout(new MigLayout("insets 0, gap 4px, fillx, w 340px!", "[][][grow][][][]", ""));
        this.socialButton = new MediaButton("", null, null);
        this.socialButton.setCursor(theHand);
        this.socialButton.setVisible(false);
        panel.add((Component)this.socialButton, "w 18px!");
        JPanel shareAndSourceButtonPanel = new JPanel();
        this.shareButton = new MediaButton(I18n.tr("Send this file to a friend"), "player_share_on", "player_share_off");
        this.shareButton.setCursor(theHand);
        this.shareButton.addActionListener(new SendToFriendActionListener(this));
        this.shareButton.setVisible(false);
        this.mediaSourceButton = new MediaButton(I18n.tr("Show the source of this media"), null, null);
        this.mediaSourceButton.setCursor(theHand);
        this.mediaSourceButton.addActionListener(new ShowSourceActionListener(this));
        this.mediaSourceButton.setVisible(false);
        shareAndSourceButtonPanel.add(this.shareButton);
        shareAndSourceButtonPanel.add(this.mediaSourceButton);
        panel.add((Component)shareAndSourceButtonPanel, "w 18px!");
        Font buttonFont = new Font("Helvetica", 1, 10);
        this.trackTitle = new JLabel("");
        this.trackTitle.setBorder(null);
        this.trackTitle.setFont(buttonFont);
        this.trackTitle.setCursor(theHand);
        this.trackTitle.setForeground(Color.WHITE);
        this.trackTitle.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (MediaPlayer.instance().getCurrentMedia().getFile() != null) {
                    MediaPlayerComponent.this.showCurrentMedia();
                } else if (MediaPlayer.instance().getCurrentMedia() instanceof StreamMediaSource) {
                    StreamMediaSource mediaSource = (StreamMediaSource)MediaPlayer.instance().getCurrentMedia();
                    if (mediaSource.getDetailsUrl() != null) {
                        GUIMediator.openURL(mediaSource.getDetailsUrl());
                    }
                } else if (MediaPlayer.instance().getCurrentMedia().getURL() != null) {
                    GUIMediator.instance().setWindow(GUIMediator.Tabs.LIBRARY);
                }
            }
        });
        panel.add((Component)this.trackTitle, "w 186px, wmax 186px");
        this.initPlaylistPlaybackModeControls();
        panel.add((Component)this.LOOP_BUTTON, "w 20px!");
        panel.add((Component)this.SHUFFLE_BUTTON, "w 20px!");
        panel.add((Component)this.VOLUME, "w 58px!");
        return panel;
    }

    private JPanel createProgressPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new MigLayout("insets 0 0 5px 0 5px, fillx", "[][grow][]"));
        Font f = panel.getFont();
        f = f.deriveFont(10.0f);
        this.progressCurrentTime.setForeground(Color.WHITE);
        this.progressCurrentTime.setFont(f);
        this.progressSongLength.setForeground(Color.WHITE);
        this.progressSongLength.setFont(f);
        panel.add((Component)this.progressCurrentTime, "gap 2px!");
        panel.add((Component)this.PROGRESS, "growx");
        panel.add((Component)this.progressSongLength, "align center");
        return panel;
    }

    private void initPlaylistPlaybackModeControls() {
        this.SHUFFLE_BUTTON = new JToggleButton();
        this.SHUFFLE_BUTTON.setContentAreaFilled(false);
        this.SHUFFLE_BUTTON.setBackground(null);
        this.SHUFFLE_BUTTON.setIcon(GUIMediator.getThemeImage("shuffle_off"));
        this.SHUFFLE_BUTTON.setSelectedIcon(GUIMediator.getThemeImage("shuffle_on"));
        this.SHUFFLE_BUTTON.setToolTipText(I18n.tr("Shuffle songs"));
        this.SHUFFLE_BUTTON.setSelected(this.mediaPlayer.isShuffle());
        this.LOOP_BUTTON = new JButton();
        this.LOOP_BUTTON.setContentAreaFilled(false);
        this.LOOP_BUTTON.setBackground(null);
        this.LOOP_BUTTON.setIcon(this.getCurrentLoopButtonImage());
        this.LOOP_BUTTON.setToolTipText(I18n.tr("Repeat songs"));
        this.SHUFFLE_BUTTON.addActionListener(e -> this.mediaPlayer.setShuffle(this.SHUFFLE_BUTTON.isSelected()));
        this.LOOP_BUTTON.addActionListener(e -> {
            this.mediaPlayer.setRepeatMode(this.mediaPlayer.getRepeatMode().getNextState());
            this.LOOP_BUTTON.setIcon(this.getCurrentLoopButtonImage());
        });
    }

    private ImageIcon getCurrentLoopButtonImage() {
        if (this.mediaPlayer.getRepeatMode() == RepeatMode.ALL) {
            return GUIMediator.getThemeImage("loop_all");
        }
        if (this.mediaPlayer.getRepeatMode() == RepeatMode.SONG) {
            return GUIMediator.getThemeImage("loop_one");
        }
        return GUIMediator.getThemeImage("loop_off");
    }

    private void showPauseButton() {
        this.PLAY_PAUSE_CARD_LAYOUT.show(this.PLAY_PAUSE_BUTTON_CONTAINER, "PAUSE");
    }

    private void showPlayButton() {
        this.PLAY_PAUSE_CARD_LAYOUT.show(this.PLAY_PAUSE_BUTTON_CONTAINER, "PLAY");
    }

    private void registerListeners() {
        this.PLAY_BUTTON.addActionListener(new PlayListener());
        this.PAUSE_BUTTON.addActionListener(new PauseListener());
        this.NEXT_BUTTON.addActionListener(new NextListener());
        this.PREV_BUTTON.addActionListener(new BackListener());
        this.VOLUME.addChangeListener(new VolumeSliderListener());
        this.PROGRESS.addMouseListener(new ProgressBarMouseAdapter());
        this.longPressTimer = new Timer(1500, e -> this.stopSong());
        this.longPressTimer.setRepeats(false);
        MouseAdapter longPressListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MediaPlayerComponent.this.longPressTimer.start();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MediaPlayerComponent.this.longPressTimer.stop();
            }
        };
        this.PLAY_BUTTON.addMouseListener(longPressListener);
        this.PAUSE_BUTTON.addMouseListener(longPressListener);
    }

    @Override
    public void refresh() {
        this.mediaPlayer.refresh();
    }

    private void setProgressValue(int update) {
        GUIMediator.safeInvokeLater(() -> this.PROGRESS.setValue(update));
    }

    private void setProgressEnabled(boolean enabled) {
        GUIMediator.safeInvokeLater(() -> this.PROGRESS.setEnabled(enabled));
        this.setProgressValue(0);
    }

    private void setVolumeValue() {
        this.VOLUME.repaint();
        this.mediaPlayer.setVolume((float)this.VOLUME.getValue() / (float)this.VOLUME.getMaximum());
    }

    private void play() {
        if (this.mediaPlayer.getCurrentMedia() != null) {
            if (this.mediaPlayer.getState() == MediaPlaybackState.Paused || this.mediaPlayer.getState() == MediaPlaybackState.Playing) {
                this.mediaPlayer.togglePause();
            } else if (this.mediaPlayer.getState() == MediaPlaybackState.Closed) {
                LibraryMediator.instance().playCurrentSelection();
            }
        } else if (GUIMediator.instance().getSelectedTab() != null && GUIMediator.instance().getSelectedTab().equals((Object)GUIMediator.Tabs.LIBRARY)) {
            LibraryMediator.instance().playCurrentSelection();
        }
    }

    private void pauseSong() {
        this.mediaPlayer.togglePause();
    }

    private void stopSong() {
        this.mediaPlayer.stop();
    }

    private void seek(float percent) {
        if (this.currentPlayListItem != null && this.currentPlayListItem.getURL() == null && this.mediaPlayer.canSeek()) {
            float timeInSecs = this.mediaPlayer.getDurationInSecs() * percent;
            this.mediaPlayer.seek(timeInSecs);
        }
    }

    @Override
    public void mediaOpened(MediaPlayer mediaPlayer, MediaSource mediaSource) {
        this.currentPlayListItem = mediaSource;
        this.setVolumeValue();
        if (mediaSource.getURL() == null && mediaPlayer.canSeek()) {
            this.setProgressEnabled(true);
            this.progressSongLength.setText(LibraryUtils.getSecondsInDDHHMMSS((int)mediaPlayer.getDurationInSecs()));
        } else {
            this.setProgressEnabled(false);
            this.progressSongLength.setText("--:--:--");
        }
        this.updateTitle(mediaSource);
        this.updateSocialButton(mediaSource);
        this.updateMediaSourceButton(mediaSource);
    }

    private void updateTitle(MediaSource mediaSource) {
        try {
            if (mediaSource == null) {
                return;
            }
            this.updateShareButtonVisibility(mediaSource);
            String currentText = null;
            if (mediaSource instanceof StreamMediaSource) {
                currentText = ((StreamMediaSource)mediaSource).getTitle();
            } else if (mediaSource != null && mediaSource.getFile() != null) {
                currentText = mediaSource.getFile().getName();
                this.trackTitle.setToolTipText(mediaSource.getFile().getAbsolutePath());
            } else if (mediaSource != null && mediaSource.getFile() == null && mediaSource.getURL() != null) {
                currentText = "internet ";
            }
            this.setTitleHelper(currentText);
        }
        catch (Throwable e) {
            LOG.error("Error doing UI updates", e);
        }
    }

    private void updateShareButtonVisibility(MediaSource currentMedia) {
        boolean isLocalFile = currentMedia != null && currentMedia.getFile() != null;
        boolean showShareButton = currentMedia != null && isLocalFile;
        this.shareButton.setVisible(showShareButton);
    }

    private void setTitleHelper(String currentText) {
        if (((String)currentText).length() > 36) {
            currentText = ((String)currentText).substring(0, 18) + " ... " + ((String)currentText).substring(((String)currentText).length() - 18);
        }
        String finalCurrentText = currentText;
        GUIMediator.safeInvokeLater(() -> {
            this.trackTitle.setText("<html><u>" + finalCurrentText + "</u></html>");
            this.trackTitle.setText(finalCurrentText);
        });
    }

    @Override
    public void progressChange(MediaPlayer mediaPlayer, float currentTimeInSecs) {
        this.progressCurrentTime.setText(LibraryUtils.getSecondsInDDHHMMSS((int)currentTimeInSecs));
        if (this.currentPlayListItem != null && this.currentPlayListItem.getURL() == null) {
            this.progressSongLength.setText(LibraryUtils.getSecondsInDDHHMMSS((int)mediaPlayer.getDurationInSecs()));
        }
        if (this.currentPlayListItem != null && this.currentPlayListItem.getURL() == null && mediaPlayer.canSeek()) {
            this.setProgressEnabled(true);
            float progressUpdate = (float)this.PROGRESS.getMaximum() * currentTimeInSecs / mediaPlayer.getDurationInSecs();
            this.setProgressValue((int)progressUpdate);
        }
    }

    @Override
    public void stateChange(MediaPlayer mediaPlayer, MediaPlaybackState state) {
        if (state == MediaPlaybackState.Opening) {
            this.setVolumeValue();
        } else if (state == MediaPlaybackState.Stopped || state == MediaPlaybackState.Closed) {
            this.setProgressValue(this.PROGRESS.getMinimum());
            this.progressCurrentTime.setText("--:--:--");
            this.progressSongLength.setText("--:--:--");
            this.mediaSourceButton.setVisible(false);
            this.showPlayButton();
        } else if (state == MediaPlaybackState.Playing) {
            this.showPauseButton();
        } else if (state == MediaPlaybackState.Paused) {
            this.showPlayButton();
        }
        if (state == MediaPlaybackState.Stopped || state == MediaPlaybackState.Closed) {
            this.trackTitle.setText("");
            this.updateMediaSourceButton(null);
            this.updateShareButtonVisibility(null);
        } else {
            this.updateTitle(mediaPlayer.getCurrentMedia());
        }
    }

    private void next() {
        this.mediaPlayer.playNextMedia();
    }

    private void back() {
        MediaSource previousSong;
        MediaSource currentMedia = this.mediaPlayer.getCurrentMedia();
        if (currentMedia != null && (previousSong = this.mediaPlayer.getPreviousMedia(currentMedia)) != null) {
            this.mediaPlayer.asyncLoadMedia(previousSong, false, true);
        }
    }

    @Override
    public void volumeChange(MediaPlayer mediaPlayer, double currentVolume) {
        VolumeSliderListener oldListener = (VolumeSliderListener)this.VOLUME.getChangeListeners()[0];
        this.VOLUME.removeChangeListener(oldListener);
        this.VOLUME.setValue((int)((double)this.VOLUME.getMaximum() * currentVolume));
        this.VOLUME.addChangeListener(oldListener);
    }

    @Override
    public void icyInfo(String data) {
        if (data != null) {
            for (String s : data.split(";")) {
                if (!s.startsWith("StreamTitle=")) continue;
                try {
                    String streamTitle = s.substring(13, s.length() - 1);
                    this.setTitleHelper("radio " + streamTitle);
                }
                catch (Throwable e) {
                    LOG.warn("Error updating UI", e);
                }
                break;
            }
        }
    }

    private void showCurrentMedia() {
        GUIMediator.instance().setWindow(GUIMediator.Tabs.LIBRARY);
        LibraryMediator.instance().selectCurrentMedia();
    }

    private void updateSocialButton(final MediaSource currentMedia) {
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            private boolean foundSocialLink;
            private String socialLink;

            @Override
            protected Void doInBackground() {
                if (currentMedia != null && currentMedia.getFile() != null) {
                    String commentToParse = "";
                    if (currentMedia.getFile() != null) {
                        commentToParse = MediaPlayerComponent.this.getCommentFromMP3(currentMedia);
                    }
                    this.parseSocialLink(commentToParse);
                }
                return null;
            }

            @Override
            protected void done() {
                if (this.foundSocialLink) {
                    this.setupSocialButtonAction();
                }
                MediaPlayerComponent.this.socialButton.setVisible(this.foundSocialLink);
            }

            private void setupSocialButtonAction() {
                String artist = MediaPlayerComponent.this.getArtistFromMP3(currentMedia);
                if (artist.equals("")) {
                    artist = I18n.tr("this artist(s)");
                }
                if (this.socialLink.contains("facebook")) {
                    MediaPlayerComponent.this.socialButton.init(I18n.tr("Open Facebook page of") + " " + artist, "FACEBOOK", "FACEBOOK");
                } else if (this.socialLink.contains("twitter")) {
                    MediaPlayerComponent.this.socialButton.init(I18n.tr("Open Twitter page of") + " " + artist, "TWITTER", "TWITTER");
                }
                this.removeSocialButtonActionListeners();
                MediaPlayerComponent.this.socialButton.addActionListener(arg0 -> GUIMediator.openURL(this.socialLink));
            }

            private void removeSocialButtonActionListeners() {
                ActionListener[] actionListeners = MediaPlayerComponent.this.socialButton.getActionListeners();
                if (actionListeners != null && actionListeners.length > 0) {
                    for (ActionListener al : actionListeners) {
                        MediaPlayerComponent.this.socialButton.removeActionListener(al);
                    }
                }
            }

            private void parseSocialLink(String commentToParse) {
                if (!StringUtils.isNullOrEmpty(commentToParse)) {
                    String trimmedComment = commentToParse.toLowerCase().trim();
                    Matcher facebookMatcher = MediaPlayerComponent.this.facebookURLPattern.matcher(trimmedComment);
                    if (facebookMatcher.find()) {
                        this.socialLink = facebookMatcher.group(0);
                    } else {
                        Matcher twitterURLMatcher = MediaPlayerComponent.this.twitterURLPattern.matcher(trimmedComment);
                        if (twitterURLMatcher.find()) {
                            this.socialLink = twitterURLMatcher.group(0);
                        } else {
                            Matcher twitterUsernameMatcher = MediaPlayerComponent.this.twitterUsernamePattern.matcher(trimmedComment);
                            if (twitterUsernameMatcher.find()) {
                                String tweep = twitterUsernameMatcher.group(0).trim();
                                this.socialLink = "https://twitter.com/" + tweep.substring(1);
                            }
                        }
                    }
                    this.foundSocialLink = !StringUtils.isNullOrEmpty(this.socialLink);
                }
            }
        };
        swingWorker.execute();
    }

    private void updateMediaSourceButton(final MediaSource currentMedia) {
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            private boolean isLocalFile;
            private boolean isSC;
            private boolean isAR;
            private String playlistName;

            @Override
            protected Void doInBackground() {
                StreamMediaSource streamMedia;
                if (currentMedia == null) {
                    return null;
                }
                if (currentMedia.getFile() != null) {
                    this.isLocalFile = true;
                }
                if (currentMedia instanceof StreamMediaSource && (streamMedia = (StreamMediaSource)currentMedia).getDetailsUrl() != null) {
                    this.isSC = streamMedia.getDetailsUrl().contains("soundcloud");
                    this.isAR = streamMedia.getDetailsUrl().contains("archive");
                }
                return null;
            }

            @Override
            protected void done() {
                boolean mediaSourceButtonVisible;
                String tooltipText = "";
                String iconUpName = "";
                String iconDownName = "";
                if (this.isLocalFile) {
                    tooltipText = I18n.tr("Playing local file");
                    iconDownName = "speaker_light";
                    iconUpName = "speaker_light";
                } else if (this.isSC) {
                    tooltipText = I18n.tr("Open SoundCloud source page");
                    iconUpName = "soundcloud_off";
                    iconDownName = "soundcloud_on";
                } else if (this.isAR) {
                    tooltipText = I18n.tr("Open Archive.org source page");
                    iconUpName = "archive_off";
                    iconDownName = "archive_on";
                }
                boolean bl = mediaSourceButtonVisible = currentMedia != null && (this.isSC || this.isAR);
                if (mediaSourceButtonVisible) {
                    MediaPlayerComponent.this.mediaSourceButton.init(tooltipText, iconUpName, iconDownName);
                }
                MediaPlayerComponent.this.mediaSourceButton.setVisible(mediaSourceButtonVisible);
            }
        };
        swingWorker.execute();
    }

    private String getCommentFromMP3(MediaSource currentMedia) {
        TagsReader reader;
        TagsData tagData;
        String comment = "";
        File fileToParse = currentMedia.getFile();
        if (fileToParse != null && fileToParse.isFile() && fileToParse.exists() && fileToParse.getAbsolutePath().toLowerCase().endsWith(".mp3") && (tagData = (reader = new TagsReader(fileToParse)).parse()) != null && !StringUtils.isNullOrEmpty(tagData.getComment())) {
            comment = tagData.getComment();
        }
        return comment;
    }

    private String getArtistFromMP3(MediaSource currentMedia) {
        TagsReader reader;
        TagsData tagData;
        File fileToParse;
        String artist = "";
        if (currentMedia.getFile() != null && (fileToParse = currentMedia.getFile()).isFile() && fileToParse.exists() && fileToParse.getAbsolutePath().toLowerCase().endsWith(".mp3") && (tagData = (reader = new TagsReader(fileToParse)).parse()) != null && !StringUtils.isNullOrEmpty(tagData.getComment())) {
            artist = tagData.getArtist();
        }
        return artist;
    }

    private final class SendToFriendActionListener
    implements ActionListener {
        private SendToFriendActionListener(MediaPlayerComponent mediaPlayerComponent) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaSource currentMedia = MediaPlayer.instance().getCurrentMedia();
            if (currentMedia == null) {
                return;
            }
            File file = null;
            if (currentMedia.getFile() != null) {
                file = currentMedia.getFile();
            }
            if (file == null) {
                return;
            }
            String fileFolder = file.isFile() ? I18n.tr("file") : I18n.tr("folder");
            DialogOption result = GUIMediator.showYesNoMessage(I18n.tr("Do you want to send this {0} to a friend?", fileFolder) + "\n\n\"" + file.getName() + "\"", I18n.tr("Send files with FrostWire"), 3);
            if (result == DialogOption.YES) {
                new SendFileProgressDialog(GUIMediator.getAppFrame(), file).setVisible(true);
                GUIMediator.instance().setWindow(GUIMediator.Tabs.TRANSFERS);
            }
        }
    }

    private final class ShowSourceActionListener
    implements ActionListener {
        private ShowSourceActionListener(MediaPlayerComponent mediaPlayerComponent) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StreamMediaSource streamMedia;
            MediaSource currentMedia = MediaPlayer.instance().getCurrentMedia();
            if (currentMedia == null) {
                return;
            }
            if (currentMedia instanceof StreamMediaSource && !StringUtils.isNullOrEmpty((streamMedia = (StreamMediaSource)currentMedia).getDetailsUrl())) {
                GUIMediator.openURL(streamMedia.getDetailsUrl());
            }
        }
    }

    private class PlayListener
    implements ActionListener {
        private PlayListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MediaPlayerComponent.this.play();
        }
    }

    private class PauseListener
    implements ActionListener {
        private PauseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MediaPlayerComponent.this.pauseSong();
        }
    }

    private class NextListener
    implements ActionListener {
        private NextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MediaPlayerComponent.this.next();
        }
    }

    private class BackListener
    implements ActionListener {
        private BackListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MediaPlayerComponent.this.back();
        }
    }

    private class VolumeSliderListener
    implements ChangeListener {
        private VolumeSliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            MediaPlayerComponent.this.setVolumeValue();
        }
    }

    private class ProgressBarMouseAdapter
    extends MouseAdapter {
        private ProgressBarMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            MediaPlayerComponent.this.seek((float)e.getX() * 1.0f / (float)((Component)e.getSource()).getWidth());
        }
    }
}

