/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library.tags;

import com.frostwire.gui.library.tags.FlacParser;
import com.frostwire.gui.library.tags.JaudiotaggerParser;
import com.frostwire.gui.library.tags.MP3Parser;
import com.frostwire.gui.library.tags.MP4Parser;
import com.frostwire.gui.library.tags.MPlayerParser;
import com.frostwire.gui.library.tags.OggParser;
import com.frostwire.gui.library.tags.TagsParser;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

class TagsParserFactory {
    private static final List<String> MP3_EXTENSIONS = Collections.singletonList("mp3");
    private static final List<String> M4A_EXTENSIONS = Collections.singletonList("m4a");
    private static final List<String> MP4_EXTENSIONS = Arrays.asList("mp4", "m4v", "mov", "3gp");
    private static final List<String> OGG_EXTENSIONS = Collections.singletonList("ogg");
    private static final List<String> FLAC_EXTENSIONS = Collections.singletonList("flac");
    private static final List<String> JAUDIOTAGGER_EXTENSIONS = Arrays.asList("wma", "wav");

    TagsParserFactory() {
    }

    public TagsParser getInstance(File file) {
        String ext = FilenameUtils.getExtension(file.getName());
        if (this.isMP3(ext)) {
            return new MP3Parser(file);
        }
        if (this.isM4A(ext)) {
            return new MP4Parser(file);
        }
        if (this.isMP4(ext)) {
            return new MP4Parser(file);
        }
        if (this.isOgg(ext)) {
            return new OggParser(file);
        }
        if (this.isFlac(ext)) {
            return new FlacParser(file);
        }
        if (this.isJaudiotagger(ext)) {
            return new JaudiotaggerParser(file);
        }
        return new MPlayerParser(file);
    }

    private boolean isMP3(String ext) {
        return MP3_EXTENSIONS.contains(ext);
    }

    private boolean isM4A(String ext) {
        return M4A_EXTENSIONS.contains(ext);
    }

    private boolean isMP4(String ext) {
        return MP4_EXTENSIONS.contains(ext);
    }

    private boolean isOgg(String ext) {
        return OGG_EXTENSIONS.contains(ext);
    }

    private boolean isFlac(String ext) {
        return FLAC_EXTENSIONS.contains(ext);
    }

    private boolean isJaudiotagger(String ext) {
        return JAUDIOTAGGER_EXTENSIONS.contains(ext);
    }
}

