/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library.tags;

import com.frostwire.gui.library.tags.AbstractTagParser;
import com.frostwire.gui.library.tags.TagsData;
import com.frostwire.gui.mplayer.MPlayer;
import com.frostwire.util.Logger;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Map;

class MPlayerParser
extends AbstractTagParser {
    private static final Logger LOG = Logger.getLogger(MPlayerParser.class);

    public MPlayerParser(File file) {
        super(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagsData parse() {
        TagsData data = null;
        try {
            MPlayer mplayer = new MPlayer();
            try {
                Map<String, String> properties = mplayer.getProperties(this.file.getAbsolutePath());
                int duration = this.parseDuration(properties.get("ID_LENGTH"));
                String bitrate = this.parseBitrate(properties.get("ID_AUDIO_BITRATE"));
                String title = properties.get("Title");
                String artist = properties.get("Artist");
                String album = properties.get("Album");
                String comment = properties.get("Comment");
                String genre = properties.get("Genre");
                String track = properties.get("Track");
                String year = properties.get("Year");
                String lyrics = properties.get("Lyrics");
                data = this.sanitize(duration, bitrate, title, artist, album, comment, genre, track, year, lyrics);
            }
            finally {
                mplayer.dispose();
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to parse file with mplayer: " + String.valueOf(this.file), e);
        }
        return data;
    }

    @Override
    public BufferedImage getArtwork() {
        return null;
    }

    private int parseDuration(String durationInSecs) {
        try {
            return (int)Float.parseFloat(durationInSecs);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String parseBitrate(String bitrate) {
        if (bitrate == null) {
            return "";
        }
        try {
            return String.valueOf(Integer.parseInt(bitrate) / 1000);
        }
        catch (Exception e) {
            return bitrate;
        }
    }
}

