/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.trees.FileTreeModel;
import com.limegroup.gnutella.settings.LibrarySettings;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.limewire.util.FileUtils;

public class RecursiveLibraryDirectoryPanel
extends JPanel {
    private final FileTreeModel directoryTreeModel;
    private final JTree directoryTree;
    private final Set<File> deselected;
    private final Set<File> roots;
    private final JPanel legendPanel;
    private final JPanel mainPanel;
    private final Icon partiallyIncludedIcon = RecursiveLibraryDirectoryPanel.createPartiallyIncludedIcon();

    public RecursiveLibraryDirectoryPanel(boolean precheckFolders, File ... roots2) {
        this(precheckFolders, RecursiveLibraryDirectoryPanel.emptyFileSet(), roots2);
    }

    private RecursiveLibraryDirectoryPanel(boolean precheckFolders, Set<File> blackListSet, File ... roots2) {
        super(new BorderLayout());
        this.roots = new TreeSet<File>(FileTreeModel.DEFAULT_COMPARATOR);
        this.deselected = new HashSet<File>(blackListSet);
        if (!precheckFolders) {
            this.addFoldersToExclude(new HashSet<File>(Arrays.asList(roots2)));
        }
        this.directoryTreeModel = new FileTreeModel("", new File[0]);
        this.directoryTreeModel.setFileFilter(new IncludedFolderFilter());
        this.directoryTree = new RootNotEditableTree(this.directoryTreeModel);
        this.directoryTree.setBorder(new EmptyBorder(4, 4, 4, 4));
        FileTreeCellRenderer fileTreeCellRenderer = new FileTreeCellRenderer();
        this.directoryTree.setCellRenderer(fileTreeCellRenderer);
        this.directoryTree.setCellEditor(new FileTreeCellEditor());
        this.directoryTree.setEditable(true);
        this.directoryTree.setVisibleRowCount(8);
        this.directoryTree.getSelectionModel().setSelectionMode(1);
        JScrollPane jspDirectories = new JScrollPane(this.directoryTree);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)jspDirectories, "Center");
        this.legendPanel = new JPanel();
        this.mainPanel.add((Component)this.legendPanel, "South");
        this.add((Component)this.mainPanel, "Center");
        this.setRoots(roots2);
        this.updateLanguage();
    }

    private static Set<File> emptyFileSet() {
        return Collections.emptySet();
    }

    private static Icon createPartiallyIncludedIcon() {
        Icon icon = UIManager.getIcon("CheckBox.icon");
        if (icon == null || icon.getIconWidth() == 0 || icon.getIconHeight() == 0) {
            icon = MetalIconFactory.getCheckBoxIcon();
        }
        return RecursiveLibraryDirectoryPanel.createDisabledIcon(RecursiveLibraryDirectoryPanel.configureCheckBox(new JCheckBox()), icon);
    }

    private static Set<File> retainAncestors(File ... roots2) {
        if (roots2 == null) {
            return new HashSet<File>();
        }
        for (int i2 = 0; i2 < roots2.length; ++i2) {
            for (int j = i2 + 1; j < roots2.length && roots2[i2] != null; ++j) {
                if (roots2[j] == null) continue;
                if (FileUtils.isAncestor(roots2[i2], roots2[j])) {
                    roots2[j] = null;
                    continue;
                }
                if (!FileUtils.isAncestor(roots2[j], roots2[i2])) continue;
                roots2[i2] = null;
            }
        }
        HashSet<File> retained = new HashSet<File>(roots2.length);
        for (File file : roots2) {
            if (file == null) continue;
            retained.add(file);
        }
        return retained;
    }

    private static JCheckBox configureCheckBox(JCheckBox checkBox) {
        checkBox.setHorizontalAlignment(2);
        checkBox.setFont(UIManager.getFont("Tree.font"));
        checkBox.setBorderPainted(false);
        checkBox.setFocusPainted(false);
        checkBox.setFocusable(false);
        checkBox.setOpaque(false);
        return checkBox;
    }

    private static Icon createDisabledIcon(JCheckBox checkBox, Icon icon) {
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconWidth(), 1);
        Graphics g = ((Image)image).getGraphics();
        checkBox.setSelected(true);
        icon.paintIcon(checkBox, g, 0, 0);
        g.dispose();
        return UIManager.getLookAndFeel().getDisabledIcon(checkBox, new ImageIcon(image));
    }

    private void updateLanguage() {
        this.createLegendPanel(this.legendPanel);
        this.directoryTreeModel.changeRootText(I18n.tr("Library Folders"));
    }

    public void addEastPanel(JComponent comp) {
        this.mainPanel.add((Component)comp, "East");
    }

    public void setRoots(File ... newRoots) {
        this.roots.clear();
        this.directoryTree.cancelEditing();
        this.directoryTreeModel.removeSubRoots();
        this.roots.addAll(RecursiveLibraryDirectoryPanel.retainAncestors(newRoots));
        ArrayList<File> list = new ArrayList<File>(this.roots);
        list.sort((o1, o2) -> {
            if (o1.equals(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue())) {
                return -1;
            }
            if (o2.equals(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue())) {
                return 1;
            }
            return o1.compareTo((File)o2);
        });
        for (File root : list) {
            this.directoryTreeModel.addSubRoot(root);
        }
        this.setRootExpanded();
    }

    boolean isRoot(File dir) {
        return this.roots.contains(dir);
    }

    private void addFoldersToExclude(Set<File> blackListSet) {
        this.deselected.addAll(blackListSet);
    }

    private void setRootExpanded() {
        this.directoryTree.expandPath(new TreePath(this.directoryTreeModel.getRoot()));
    }

    public void addRoot(File dir) {
        boolean changed = this.deselected.remove(dir);
        for (File root : this.roots) {
            if (FileUtils.isAncestor(root, dir)) {
                if (root.equals(dir)) {
                    if (changed) {
                        this.directoryTreeModel.valueForPathChanged(this.getTreePath(dir), null);
                    }
                    return;
                }
                this.removeFromPath(dir);
                TreePath path = this.getTreePath(dir);
                this.directoryTree.scrollPathToVisible(path);
                return;
            }
            if (!FileUtils.isAncestor(dir, root)) continue;
            this.removeRoot(root);
            this.addDirToTree(dir);
            this.setExpanded(root);
            this.setExpanded(root.getParentFile());
            return;
        }
        this.addDirToTree(dir);
        this.setRootExpanded();
    }

    private void addDirToTree(File dir) {
        this.roots.add(dir);
        this.directoryTreeModel.addSubRoot(dir);
    }

    void removeRoot(File root) {
        if (this.roots.remove(root)) {
            this.directoryTree.cancelEditing();
            this.directoryTreeModel.removeSubRoot(root);
            this.removeFromPath(root);
        }
    }

    private void createLegendPanel(JPanel basePanel) {
        JPanel panel;
        if (basePanel != null) {
            basePanel.removeAll();
            basePanel.setLayout(new GridBagLayout());
            panel = basePanel;
        } else {
            panel = new JPanel(new GridBagLayout());
        }
        panel.setBorder(BorderFactory.createTitledBorder(I18n.tr("Legend")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 4, 0, 6);
        JCheckBox checkBox = new JCheckBox();
        checkBox.setSelected(true);
        panel.add((Component)this.createIconLabel(checkBox), gbc);
        MultiLineLabel label = new MultiLineLabel(I18n.tr("Folder and subfolders are included in the Library."), true);
        GridBagConstraints labelGbc = new GridBagConstraints();
        labelGbc.anchor = 17;
        labelGbc.fill = 2;
        labelGbc.gridwidth = 0;
        labelGbc.gridx = 1;
        labelGbc.weightx = 1.0;
        panel.add((Component)label, labelGbc);
        checkBox.setSelected(false);
        gbc.gridy = 1;
        panel.add((Component)this.createIconLabel(checkBox), gbc);
        label = new MultiLineLabel(I18n.tr("Folder is not included and no subfolders are included in the Library."), true);
        labelGbc.gridy = 1;
        panel.add((Component)label, labelGbc);
        checkBox.setIcon(this.partiallyIncludedIcon);
        gbc.gridy = 2;
        gbc.insets = new Insets(0, 6, 0, 0);
        panel.add((Component)this.createIconLabel(checkBox), gbc);
        label = new MultiLineLabel(I18n.tr("Folder's files and some subfolders are included in the Library."), true);
        labelGbc.gridy = 2;
        gbc.insets = null;
        panel.add((Component)label, labelGbc);
    }

    private JLabel createIconLabel(JCheckBox checkBox) {
        checkBox.setOpaque(false);
        checkBox.setSize(checkBox.getMinimumSize());
        BufferedImage image = new BufferedImage(checkBox.getWidth(), checkBox.getHeight(), 3);
        Graphics g = ((Image)image).getGraphics();
        checkBox.paint(g);
        g.dispose();
        return new JLabel(new ImageIcon(image));
    }

    public Set<File> getRootsToInclude() {
        HashSet<File> ret = new HashSet<File>(this.roots);
        ret.removeAll(this.deselected);
        return ret;
    }

    public Set<File> getFoldersToExclude() {
        return new HashSet<File>(this.deselected);
    }

    public void setFoldersToExclude(Set<File> blackListSet) {
        this.deselected.clear();
        this.deselected.addAll(blackListSet);
    }

    private TreePath getTreePath(File dir) {
        LinkedList<File> files = new LinkedList<File>();
        files.add(dir);
        for (File parent = dir.getParentFile(); parent != null && !this.directoryTreeModel.isSubRoot(dir); parent = parent.getParentFile()) {
            files.addFirst(parent);
            dir = parent;
        }
        Object[] path = new Object[files.size() + 1];
        path[0] = this.directoryTreeModel.getRoot();
        System.arraycopy(files.toArray(), 0, path, 1, path.length - 1);
        return new TreePath(path);
    }

    public JTree getTree() {
        return this.directoryTree;
    }

    private void setExpanded(File dir) {
        this.directoryTree.expandPath(this.getTreePath(dir));
    }

    private boolean isIncludedOrParentIsIncluded(File dir) {
        while (dir != null) {
            if (this.deselected.contains(dir)) {
                return false;
            }
            dir = dir.getParentFile();
        }
        return true;
    }

    private boolean isExcluded(File dir) {
        for (File file : this.deselected) {
            if (!FileUtils.isAncestor(file, dir)) continue;
            return true;
        }
        return false;
    }

    private boolean isFullyIncluded(File dir) {
        for (File offspring : this.deselected) {
            if (!FileUtils.isAncestor(dir, offspring)) continue;
            return false;
        }
        return true;
    }

    private String getText(File file) {
        return this.directoryTreeModel.isSubRoot(file) ? file.getAbsolutePath() : file.getName();
    }

    private void removeFromPath(File file) {
        Iterator<File> i2 = this.deselected.iterator();
        while (i2.hasNext()) {
            File f = i2.next();
            if (!FileUtils.isAncestor(file, f)) continue;
            i2.remove();
        }
        while (file != null && !this.roots.contains(file)) {
            File parent = file.getParentFile();
            if (this.ancestorIsExcluded(parent)) {
                this.deselected.remove(parent);
                int childCount = this.directoryTreeModel.getChildCount(parent);
                for (int j = 0; j < childCount; ++j) {
                    File sibling = (File)this.directoryTreeModel.getChild(parent, j);
                    if (sibling == null || sibling.equals(file)) continue;
                    this.deselected.add(sibling);
                }
            }
            file = parent;
        }
    }

    private boolean ancestorIsExcluded(File file) {
        while (file != null) {
            if (this.deselected.contains(file)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    private static class IncludedFolderFilter
    implements FileFilter {
        private IncludedFolderFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (FileUtils.isAncestor(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue(), pathname)) {
                return false;
            }
            for (File f : LibrarySettings.DIRECTORIES_TO_INCLUDE_FROM_FROSTWIRE4.getValue()) {
                if (!FileUtils.isAncestor(f, pathname)) continue;
                return false;
            }
            if (FileUtils.isAncestor(LibrarySettings.USER_MUSIC_FOLDER.getValue(), pathname)) {
                return false;
            }
            return pathname.isDirectory() && !pathname.isHidden();
        }
    }

    private static class RootNotEditableTree
    extends JTree {
        private static final long serialVersionUID = 3856730985269585441L;

        RootNotEditableTree(TreeModel newModel) {
            super(newModel);
        }

        @Override
        public boolean isPathEditable(TreePath path) {
            Object comp = path.getLastPathComponent();
            if (comp instanceof File && comp.equals(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue())) {
                return false;
            }
            return path.getPathCount() != 1;
        }
    }

    private class FileTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -8299879264709364378L;
        private final JCheckBox checkBox = RecursiveLibraryDirectoryPanel.configureCheckBox(new JCheckBox());
        private final DefaultTreeCellRenderer labelRenderer = new DefaultTreeCellRenderer();

        private FileTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (!(value instanceof File)) {
                this.labelRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, false, row, false);
                this.labelRenderer.setIcon(null);
                return this.labelRenderer;
            }
            File file = (File)value;
            this.checkBox.setText(RecursiveLibraryDirectoryPanel.this.getText(file));
            this.checkBox.setBackground(this.getBackground());
            this.checkBox.setForeground(this.getForeground());
            if (RecursiveLibraryDirectoryPanel.this.isExcluded(file)) {
                this.checkBox.setSelected(false);
                this.checkBox.setIcon(null);
            } else if (RecursiveLibraryDirectoryPanel.this.isFullyIncluded(file)) {
                this.checkBox.setSelected(true);
                this.checkBox.setIcon(null);
            } else {
                this.checkBox.setSelected(true);
                this.checkBox.setIcon(RecursiveLibraryDirectoryPanel.this.partiallyIncludedIcon);
            }
            return this.checkBox;
        }
    }

    private class FileTreeCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -8422311328409412824L;

        FileTreeCellEditor() {
            super(RecursiveLibraryDirectoryPanel.configureCheckBox(new JCheckBox()));
            this.delegate = new DefaultCellEditor.EditorDelegate(){
                private static final long serialVersionUID = -7007164079287676831L;

                @Override
                public void setValue(Object value) {
                    File file = (File)value;
                    ((JCheckBox)FileTreeCellEditor.this.editorComponent).setSelected(RecursiveLibraryDirectoryPanel.this.isIncludedOrParentIsIncluded(file));
                    ((JCheckBox)FileTreeCellEditor.this.editorComponent).setText(RecursiveLibraryDirectoryPanel.this.getText(file));
                    this.value = value;
                }

                @Override
                public Object getCellEditorValue() {
                    File file = (File)this.value;
                    if (((JCheckBox)FileTreeCellEditor.this.editorComponent).isSelected()) {
                        RecursiveLibraryDirectoryPanel.this.removeFromPath(file);
                    } else {
                        RecursiveLibraryDirectoryPanel.this.deselected.add(file);
                    }
                    return this.value;
                }
            };
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.delegate.setValue(value);
            return this.editorComponent;
        }
    }
}

