/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.library.DirectoryHolder;
import com.frostwire.gui.library.DirectoryHolderNode;
import com.frostwire.gui.theme.ThemeMediator;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultTreeCellRenderer;

class NodeRenderer
extends DefaultTreeCellRenderer {
    private static final AbstractBorder DIRECTORY_HOLDER_NODE_BORDER = new EmptyBorder(5, 5, 5, 5);

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (sel) {
            this.setBackgroundSelectionColor(ThemeMediator.TABLE_SELECTED_BACKGROUND_ROW_COLOR);
        } else {
            this.setBackgroundNonSelectionColor(row % 2 == 0 ? Color.WHITE : ThemeMediator.TABLE_ALTERNATE_ROW_COLOR);
        }
        if (value instanceof DirectoryHolderNode) {
            DirectoryHolderNode node = (DirectoryHolderNode)value;
            DirectoryHolder dh = node.getDirectoryHolder();
            this.setText(dh.getName());
            this.setToolTipText(dh.getDescription());
            Icon icon = dh.getIcon();
            if (icon != null) {
                this.setIcon(icon);
                this.setBorder(DIRECTORY_HOLDER_NODE_BORDER);
            }
        }
        return this;
    }
}

