/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.library.DirectoryHolder;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;

public class MediaTypeSavedFilesDirectoryHolder
implements DirectoryHolder {
    private final MediaType type;
    private final Set<File> cache;

    public MediaTypeSavedFilesDirectoryHolder(MediaType type) {
        this.type = type;
        this.cache = new HashSet<File>();
    }

    public MediaType getMediaType() {
        return this.type;
    }

    @Override
    public boolean accept(File file) {
        return this.type.matches(file.getName());
    }

    @Override
    public Icon getIcon() {
        NamedMediaType nmt = NamedMediaType.getFromMediaType(this.type);
        return nmt.getIcon();
    }

    @Override
    public String getName() {
        return NamedMediaType.getFromMediaType(this.type).getName();
    }

    @Override
    public String getDescription() {
        return I18n.tr("Holds the Results for") + " " + this.type.getDescriptionKey();
    }

    @Override
    public File getDirectory() {
        return null;
    }

    @Override
    public File[] getFiles() {
        return new File[0];
    }

    @Override
    public int size() {
        return 0;
    }

    public Set<File> getCache() {
        return this.cache;
    }

    public void addToCache(List<File> files) {
        this.cache.addAll(files);
    }

    public void clearCache() {
        this.cache.clear();
    }
}

