/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.library.AbstractLibraryTableMediator;
import com.frostwire.gui.library.DirectoryHolder;
import com.frostwire.gui.library.LibraryCoverArtPanel;
import com.frostwire.gui.library.LibraryExplorer;
import com.frostwire.gui.library.LibraryFilesTableMediator;
import com.frostwire.gui.library.LibraryLeftPanel;
import com.frostwire.gui.library.LibrarySearch;
import com.frostwire.gui.library.MediaTypeSavedFilesDirectoryHolder;
import com.frostwire.gui.library.SavedFilesDirectoryHolder;
import com.frostwire.gui.library.TorrentDirectoryHolder;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.player.MediaSource;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.util.DividerLocationSettingUpdater;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class LibraryMediator {
    private static final String FILES_TABLE_KEY = "LIBRARY_FILES_TABLE";
    private static JPanel MAIN_PANEL;
    private static LibraryMediator INSTANCE;
    private LibraryExplorer libraryExplorer;
    private LibraryCoverArtPanel libraryCoverArtPanel;
    private LibraryLeftPanel libraryLeftPanel;
    private LibrarySearch librarySearch;
    private CardLayout _tablesViewLayout = new CardLayout();
    private JPanel _tablesPanel;
    private final Map<Object, Integer> scrollbarValues;
    private Object lastSelectedKey;
    private AbstractLibraryTableMediator<?, ?, ?> lastSelectedMediator;
    private final Set<Integer> idScanned;
    private AbstractLibraryTableMediator<?, ?, ?> currentMediator;

    private LibraryMediator() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Library Window..."));
        this.idScanned = new HashSet<Integer>();
        this.getComponent();
        this.scrollbarValues = new HashMap<Object, Integer>();
        JSplitPane splitPane = new JSplitPane(1, this.getLibraryLeftPanel(), this.getLibraryRightPanel());
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(0.5);
        splitPane.addPropertyChangeListener("lastDividerLocation", evt -> {
            JSplitPane splitPane1 = (JSplitPane)evt.getSource();
            int current = splitPane1.getDividerLocation();
            if (current > 300) {
                splitPane1.setDividerLocation(300);
            } else if (current < 155) {
                splitPane1.setDividerLocation(155);
            }
        });
        DividerLocationSettingUpdater.install(splitPane, UISettings.UI_LIBRARY_MAIN_DIVIDER_LOCATION);
        MAIN_PANEL.add(splitPane);
    }

    public static LibraryMediator instance() {
        if (INSTANCE == null) {
            INSTANCE = new LibraryMediator();
        }
        return INSTANCE;
    }

    private Object getSelectedKey() {
        return this.getLibraryExplorer().getSelectedDirectoryHolder();
    }

    public LibraryExplorer getLibraryExplorer() {
        if (this.libraryExplorer == null) {
            this.libraryExplorer = new LibraryExplorer();
        }
        return this.libraryExplorer;
    }

    public LibrarySearch getLibrarySearch() {
        if (this.librarySearch == null) {
            this.librarySearch = new LibrarySearch();
        }
        return this.librarySearch;
    }

    public LibraryCoverArtPanel getLibraryCoverArtPanel() {
        if (this.libraryCoverArtPanel == null) {
            this.libraryCoverArtPanel = new LibraryCoverArtPanel();
        }
        return this.libraryCoverArtPanel;
    }

    public JComponent getComponent() {
        if (MAIN_PANEL == null) {
            MAIN_PANEL = new JPanel(new BorderLayout());
        }
        return MAIN_PANEL;
    }

    private void showView() {
        GUIMediator.safeInvokeAndWait(() -> {
            this.rememberScrollbarsOnMediators();
            this._tablesViewLayout.show(this._tablesPanel, FILES_TABLE_KEY);
        });
        this.currentMediator = LibraryFilesTableMediator.instance();
    }

    private void rememberScrollbarsOnMediators() {
        LibraryFilesTableMediator tableMediator = LibraryFilesTableMediator.instance();
        if (tableMediator == null) {
            return;
        }
        if (this.lastSelectedMediator != null && this.lastSelectedKey != null) {
            this.scrollbarValues.put(this.lastSelectedKey, this.lastSelectedMediator.getScrollbarValue());
        }
        this.lastSelectedMediator = tableMediator;
        this.lastSelectedKey = this.getSelectedKey();
        int lastScrollValue = this.scrollbarValues.getOrDefault(this.lastSelectedKey, 0);
        tableMediator.scrollTo(lastScrollValue);
    }

    void updateTableFiles(DirectoryHolder dirHolder) {
        this.clearLibraryTable();
        this.showView();
        LibraryFilesTableMediator.instance().updateTableFiles(dirHolder);
    }

    public void clearDirectoryHolderCaches() {
        this.getLibraryExplorer().clearDirectoryHolderCaches();
    }

    void clearLibraryTable() {
        LibraryFilesTableMediator.instance().clearTable();
        this.getLibrarySearch().clear();
    }

    void addFilesToLibraryTable(List<File> files) {
        for (File file : files) {
            LibraryFilesTableMediator.instance().add(file);
        }
        this.getLibrarySearch().addResults(files.size());
    }

    private JComponent getLibraryLeftPanel() {
        if (this.libraryLeftPanel == null) {
            this.libraryLeftPanel = new LibraryLeftPanel(this.getLibraryExplorer(), this.getLibraryCoverArtPanel());
        }
        return this.libraryLeftPanel;
    }

    private JComponent getLibraryRightPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this._tablesViewLayout = new CardLayout();
        this._tablesPanel = new JPanel(this._tablesViewLayout);
        this._tablesPanel.add((Component)LibraryFilesTableMediator.instance().getComponent(), FILES_TABLE_KEY);
        panel.add((Component)this.getLibrarySearch(), "First");
        panel.add((Component)this._tablesPanel, "Center");
        return panel;
    }

    public void selectCurrentMedia() {
        MediaSource currentMedia = MediaPlayer.instance().getCurrentMedia();
        if (currentMedia != null && currentMedia.getFile() != null) {
            LibraryExplorer libraryFiles = this.getLibraryExplorer();
            libraryFiles.enqueueRunnable(() -> GUIMediator.safeInvokeLater(() -> LibraryFilesTableMediator.instance().setFileSelected(currentMedia.getFile())));
            libraryFiles.selectAudio();
        }
    }

    public boolean isScanned(int id) {
        return this.idScanned.contains(id);
    }

    public void scan(int hashCode, File location) {
        block4: {
            block3: {
                if (location == null) {
                    return;
                }
                this.idScanned.add(hashCode);
                if (!location.isDirectory()) break block3;
                File[] files = location.listFiles();
                if (files == null) break block4;
                for (File file : files) {
                    this.scan(hashCode, file);
                }
                break block4;
            }
            List<MediaTypeSavedFilesDirectoryHolder> holders = this.getLibraryExplorer().getMediaTypeSavedFilesDirectoryHolders();
            for (MediaTypeSavedFilesDirectoryHolder holder : holders) {
                Set<File> cache = holder.getCache();
                if (!holder.accept(location) || cache.isEmpty()) continue;
                cache.add(location);
            }
        }
    }

    File getSelectedFile() {
        boolean fileBasedDirectoryHolderSelected;
        File toExplore = null;
        DirectoryHolder selectedDirectoryHolder = LibraryMediator.instance().getLibraryExplorer().getSelectedDirectoryHolder();
        boolean bl = fileBasedDirectoryHolderSelected = selectedDirectoryHolder instanceof SavedFilesDirectoryHolder || selectedDirectoryHolder instanceof MediaTypeSavedFilesDirectoryHolder || selectedDirectoryHolder instanceof TorrentDirectoryHolder;
        if (fileBasedDirectoryHolderSelected && LibraryFilesTableMediator.instance().getSelectedLines().size() == 1) {
            toExplore = LibraryFilesTableMediator.instance().getSelectedLines().get(0).getFile();
        }
        return toExplore;
    }

    public void playCurrentSelection() {
        if (this.currentMediator != null) {
            this.currentMediator.playCurrentSelection();
        }
    }
}

