/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.mplayer.MediaPlaybackState;
import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.ListModel;

class LibraryIconList
extends JList<Object> {
    private Image speaker;
    private Image loading;

    LibraryIconList(ListModel<Object> dataModel) {
        super(dataModel);
        this.loadIcons();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        MediaPlayer player = MediaPlayer.instance();
        if (player.getState() == MediaPlaybackState.Stopped || player.getState() == MediaPlaybackState.Closed || player.getState() != MediaPlaybackState.Failed) {
            // empty if block
        }
    }

    private void loadIcons() {
        this.speaker = GUIMediator.getThemeImage("speaker").getImage();
        this.loading = GUIMediator.getThemeImage("indeterminate_small_progress").getImage();
    }

    private void paintIcon(Graphics g, Image image, int index) {
        Rectangle rect = this.getUI().getCellBounds(this, index, index);
        Dimension lsize = rect.getSize();
        Point llocation = rect.getLocation();
        g.drawImage(image, llocation.x + lsize.width - this.speaker.getWidth(null) - 4, llocation.y + (lsize.height - this.speaker.getHeight(null)) / 2, null);
    }
}

