/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.library.DirectoryHolder;
import com.frostwire.gui.library.DirectoryHolderNode;
import com.frostwire.gui.library.FileSettingDirectoryHolder;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryNode;
import com.frostwire.gui.library.MediaTypeSavedFilesDirectoryHolder;
import com.frostwire.util.Logger;
import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.settings.LibrarySettings;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

final class LibraryFilesTransferHandler
extends TransferHandler {
    private static final Logger LOG = Logger.getLogger(LibraryFilesTransferHandler.class);
    private final JTree tree;

    LibraryFilesTransferHandler(JTree tree) {
        this.tree = tree;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        try {
            LibraryNode node = this.getNodeFromLocation(support.getDropLocation());
            if (!(node instanceof DirectoryHolderNode)) {
                return false;
            }
            DirectoryHolder dirHolder = ((DirectoryHolderNode)node).getDirectoryHolder();
            if (this.droppingFoldersToAddToLibrary(support, dirHolder, true)) {
                return true;
            }
            if (!(dirHolder instanceof MediaTypeSavedFilesDirectoryHolder)) {
                return false;
            }
            MediaTypeSavedFilesDirectoryHolder mediaTypeSavedFilesDirHolder = (MediaTypeSavedFilesDirectoryHolder)dirHolder;
            MediaType mt = mediaTypeSavedFilesDirHolder.getMediaType();
            return mt.equals(MediaType.getAudioMediaType()) && DNDUtils.supportCanImport(support.getDataFlavors()[0], support, null, false);
        }
        catch (Throwable e) {
            LOG.error("Error in LibraryFilesTransferHandler processing", e);
            return false;
        }
    }

    private boolean droppingFoldersToAddToLibrary(TransferHandler.TransferSupport support, DirectoryHolder dirHolder, boolean invokingFromCanImport) {
        try {
            if (invokingFromCanImport && OSUtils.isMacOSX()) {
                return true;
            }
            return this.isSharedFolderReceiver(dirHolder) && DNDUtils.containsFileFlavors(support.getDataFlavors()) && this.areAllFilesDirectories(DNDUtils.getFiles(support.getTransferable()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean areAllFilesDirectories(File[] files) {
        boolean result = true;
        for (File f : files) {
            if (f.isDirectory()) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        try {
            DirectoryHolder dirHolder;
            LibraryNode node = this.getNodeFromLocation(support.getDropLocation());
            if (node instanceof DirectoryHolderNode && this.droppingFoldersToAddToLibrary(support, dirHolder = ((DirectoryHolderNode)node).getDirectoryHolder(), false)) {
                try {
                    File[] files;
                    for (File f : files = DNDUtils.getFiles(support.getTransferable())) {
                        LibrarySettings.DIRECTORIES_TO_INCLUDE.add(f);
                        LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.remove(f);
                    }
                    LibraryMediator.instance().clearDirectoryHolderCaches();
                    GUIMediator.instance().setOptionsVisible(true, "OPTIONS_LIBRARY_MAIN_TITLE");
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            LOG.error("Error in LibraryFilesTransferHandler processing", e);
        }
        return false;
    }

    private boolean isSharedFolderReceiver(DirectoryHolder directoryHolder) {
        return directoryHolder instanceof MediaTypeSavedFilesDirectoryHolder || directoryHolder instanceof FileSettingDirectoryHolder;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 0x40000003;
    }

    private LibraryNode getNodeFromLocation(TransferHandler.DropLocation location) {
        TreePath path = this.tree.getUI().getClosestPathForLocation(this.tree, location.getDropPoint().x, location.getDropPoint().y);
        return path != null ? (LibraryNode)path.getLastPathComponent() : null;
    }
}

