/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.gui.library.AbstractLibraryListPanel;
import com.frostwire.gui.library.DirectoryHolder;
import com.frostwire.gui.library.DirectoryHolderNode;
import com.frostwire.gui.library.LibraryFilesTransferHandler;
import com.frostwire.gui.library.LibraryIconTree;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryNode;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.library.MediaTypeSavedFilesDirectoryHolder;
import com.frostwire.gui.library.NodeRenderer;
import com.frostwire.gui.library.SavedFilesDirectoryHolder;
import com.frostwire.gui.library.TextNode;
import com.frostwire.gui.library.TorrentDirectoryHolder;
import com.frostwire.gui.library.TreeMouseObserver;
import com.frostwire.gui.theme.SkinMenuItem;
import com.frostwire.gui.theme.SkinPopupMenu;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.ConfigureOptionsAction;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.tables.DefaultMouseListener;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.LibrarySettings;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.limewire.util.FileUtils;

public class LibraryExplorer
extends AbstractLibraryListPanel {
    private DefaultTreeModel model;
    private JTree tree;
    private TextNode root;
    private final Action refreshAction = new RefreshAction();
    private final Action exploreAction = new ExploreAction();
    private TreeSelectionListener treeSelectionListener;

    LibraryExplorer() {
        this.setupUI();
    }

    @Override
    public void refresh() {
        this.tree.repaint();
    }

    public void refreshSelection(boolean clearCache) {
        LibraryNode node = (LibraryNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        LibraryMediator.instance().clearLibraryTable();
        DirectoryHolder directoryHolder = this.getSelectedDirectoryHolder();
        if (directoryHolder instanceof TorrentDirectoryHolder) {
            LibraryMediator.instance().updateTableFiles(directoryHolder);
        } else if (directoryHolder instanceof SavedFilesDirectoryHolder) {
            if (clearCache) {
                ((SavedFilesDirectoryHolder)directoryHolder).clearCache();
            }
            LibraryMediator.instance().updateTableFiles(directoryHolder);
        } else if (directoryHolder instanceof MediaTypeSavedFilesDirectoryHolder) {
            MediaTypeSavedFilesDirectoryHolder mtsfdh = (MediaTypeSavedFilesDirectoryHolder)directoryHolder;
            if (clearCache) {
                mtsfdh.clearCache();
            }
            LibraryMediator.instance().updateTableFiles(directoryHolder);
            BackgroundExecutorService.schedule(new SearchByMediaTypeRunnable(mtsfdh));
        }
        this.saveLastSelectedDirectoryHolder();
        String searchPrompt = I18n.tr("Search your") + " " + String.valueOf(node.getUserObject());
        LibraryMediator.instance().getLibrarySearch().clear();
        LibraryMediator.instance().getLibrarySearch().setSearchPrompt(searchPrompt);
    }

    private void saveLastSelectedDirectoryHolder() {
        int[] selectionRows = this.tree.getSelectionRows();
        if (selectionRows != null && selectionRows.length == 1) {
            LibrarySettings.LAST_SELECTED_LIBRARY_DIRECTORY_HOLDER_OFFSET.setValue(selectionRows[0]);
        }
    }

    private void setupUI() {
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(177, 170));
        this.setPreferredSize(new Dimension(177, 170));
        GUIMediator.addRefreshListener(this);
        this.setupModel();
        this.setupTree();
        this.add(new JScrollPane(this.tree));
    }

    private void setupModel() {
        this.root = new TextNode("root");
        this.addNodesPerMediaType(this.root);
        this.root.add(new DirectoryHolderNode(new TorrentDirectoryHolder()));
        this.root.add(new DirectoryHolderNode(new SavedFilesDirectoryHolder(SharingSettings.TORRENT_DATA_DIR_SETTING, I18n.tr("Default Save Folder"))));
        this.model = new DefaultTreeModel(this.root);
    }

    private void setupTree() {
        this.tree = new LibraryIconTree(this.model);
        this.tree.setRowHeight(TableSettings.DEFAULT_TABLE_ROW_HEIGHT.getValue());
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new NodeRenderer());
        this.tree.setDragEnabled(true);
        this.tree.setTransferHandler(new LibraryFilesTransferHandler(this.tree));
        ((BasicTreeUI)this.tree.getUI()).setExpandedIcon(null);
        ((BasicTreeUI)this.tree.getUI()).setCollapsedIcon(null);
        SkinPopupMenu popup = new SkinPopupMenu();
        popup.add(new SkinMenuItem(this.refreshAction));
        popup.add(new SkinMenuItem(this.exploreAction));
        popup.add(new SkinMenuItem(new ConfigureOptionsAction("OPTIONS_SHARED_MAIN_TITLE", I18n.tr("Configure Options"), I18n.tr("You can configure the FrostWire's Options."))));
        this.tree.addMouseListener(new DefaultMouseListener(new TreeMouseObserver(this.tree, popup)));
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (LibraryUtils.isRefreshKeyEvent(e)) {
                    LibraryExplorer.this.refreshSelection(true);
                }
            }
        });
        this.treeSelectionListener = new LibraryExplorerTreeSelectionListener();
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
    }

    private void addNodesPerMediaType(DefaultMutableTreeNode root) {
        this.addNodePerMediaType(root, NamedMediaType.getFromMediaType(MediaType.getAudioMediaType()));
        this.addNodePerMediaType(root, NamedMediaType.getFromMediaType(MediaType.getVideoMediaType()));
        this.addNodePerMediaType(root, NamedMediaType.getFromMediaType(MediaType.getImageMediaType()));
        this.addNodePerMediaType(root, NamedMediaType.getFromMediaType(MediaType.getProgramMediaType()));
        this.addNodePerMediaType(root, NamedMediaType.getFromMediaType(MediaType.getDocumentMediaType()));
    }

    private void addNodePerMediaType(DefaultMutableTreeNode root, NamedMediaType nm) {
        MediaTypeSavedFilesDirectoryHolder directoryHolder = new MediaTypeSavedFilesDirectoryHolder(nm.getMediaType());
        DirectoryHolderNode node = new DirectoryHolderNode(directoryHolder);
        root.add(node);
    }

    DirectoryHolder getSelectedDirectoryHolder() {
        LibraryNode node = (LibraryNode)this.tree.getLastSelectedPathComponent();
        return node instanceof DirectoryHolderNode ? ((DirectoryHolderNode)node).getDirectoryHolder() : null;
    }

    public void clearSelection() {
        this.tree.clearSelection();
    }

    void refreshSelection() {
        this.refreshSelection(false);
    }

    private void selectMediaTypeSavedFilesDirectoryHolderbyType(MediaType mediaType) {
        try {
            LibraryNode selectedValue = (LibraryNode)this.tree.getLastSelectedPathComponent();
            if (selectedValue instanceof DirectoryHolderNode && ((DirectoryHolderNode)selectedValue).getDirectoryHolder() instanceof MediaTypeSavedFilesDirectoryHolder && ((MediaTypeSavedFilesDirectoryHolder)((DirectoryHolderNode)selectedValue).getDirectoryHolder()).getMediaType().equals(mediaType)) {
                try {
                    this.treeSelectionListener.valueChanged(null);
                }
                catch (Exception e) {
                    System.out.println();
                }
                return;
            }
            Enumeration<TreeNode> e = this.root.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                DirectoryHolder holder;
                LibraryNode node = (LibraryNode)e.nextElement();
                if (!(node instanceof DirectoryHolderNode) || !((holder = ((DirectoryHolderNode)node).getDirectoryHolder()) instanceof MediaTypeSavedFilesDirectoryHolder) || !((MediaTypeSavedFilesDirectoryHolder)holder).getMediaType().equals(mediaType)) continue;
                GUIMediator.safeInvokeAndWait(() -> {
                    this.tree.setSelectionPath(new TreePath(node.getPath()));
                    this.tree.scrollPathToVisible(new TreePath(node.getPath()));
                });
                return;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void selectAudio() {
        this.selectMediaTypeSavedFilesDirectoryHolderbyType(MediaType.getAudioMediaType());
    }

    public void selectDirectoryHolderAt(int index) {
        if (index >= 0 && index < this.tree.getRowCount()) {
            GUIMediator.safeInvokeLater(() -> {
                this.tree.setSelectionRow(index);
                this.tree.scrollRowToVisible(index);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectFinishedDownloads() {
        try {
            if (this.selectionListenerForSameItem(SavedFilesDirectoryHolder.class)) {
                return;
            }
            Enumeration<TreeNode> e = this.root.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                DirectoryHolder holder;
                LibraryNode node = (LibraryNode)e.nextElement();
                if (!(node instanceof DirectoryHolderNode) || !((holder = ((DirectoryHolderNode)node).getDirectoryHolder()) instanceof SavedFilesDirectoryHolder)) continue;
                GUIMediator.safeInvokeLater(() -> {
                    this.tree.setSelectionPath(new TreePath(node.getPath()));
                    this.tree.scrollPathToVisible(new TreePath(node.getPath()));
                });
                return;
            }
        }
        finally {
            this.executePendingRunnables();
        }
    }

    private boolean selectionListenerForSameItem(Class<?> clazz) {
        LibraryNode selectedValue = (LibraryNode)this.tree.getLastSelectedPathComponent();
        if (selectedValue instanceof DirectoryHolderNode && clazz.isInstance(((DirectoryHolderNode)selectedValue).getDirectoryHolder())) {
            try {
                this.treeSelectionListener.valueChanged(null);
            }
            catch (Exception e) {
                System.out.println();
            }
            return true;
        }
        return false;
    }

    List<MediaTypeSavedFilesDirectoryHolder> getMediaTypeSavedFilesDirectoryHolders() {
        ArrayList<MediaTypeSavedFilesDirectoryHolder> holders = new ArrayList<MediaTypeSavedFilesDirectoryHolder>();
        Enumeration<TreeNode> e = this.root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DirectoryHolder holder;
            LibraryNode node = (LibraryNode)e.nextElement();
            if (!(node instanceof DirectoryHolderNode) || !((holder = ((DirectoryHolderNode)node).getDirectoryHolder()) instanceof MediaTypeSavedFilesDirectoryHolder)) continue;
            holders.add((MediaTypeSavedFilesDirectoryHolder)holder);
        }
        return holders;
    }

    public void clearDirectoryHolderCaches() {
        try {
            Enumeration<TreeNode> e = this.root.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                LibraryNode node = (LibraryNode)e.nextElement();
                if (!(node instanceof DirectoryHolderNode)) continue;
                DirectoryHolder holder = ((DirectoryHolderNode)node).getDirectoryHolder();
                if (holder instanceof MediaTypeSavedFilesDirectoryHolder) {
                    ((MediaTypeSavedFilesDirectoryHolder)holder).clearCache();
                    continue;
                }
                if (!(holder instanceof SavedFilesDirectoryHolder)) continue;
                ((SavedFilesDirectoryHolder)holder).clearCache();
            }
            this.refreshSelection();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private class RefreshAction
    extends AbstractAction {
        RefreshAction() {
            this.putValue("Name", I18n.tr("Refresh"));
            this.putValue("ShortDescription", I18n.tr("Refresh selected"));
            this.putValue("LimeIconName", "LIBRARY_REFRESH");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DirectoryHolder directoryHolder = LibraryExplorer.this.getSelectedDirectoryHolder();
            if (directoryHolder == null) {
                return;
            }
            LibraryExplorer.this.refreshSelection(true);
        }
    }

    private class ExploreAction
    extends AbstractAction {
        ExploreAction() {
            this.putValue("Name", I18n.tr("Explore"));
            this.putValue("ShortDescription", I18n.tr("Open Library Folder"));
            this.putValue("LimeIconName", "LIBRARY_EXPLORE");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DirectoryHolder directoryHolder = LibraryExplorer.this.getSelectedDirectoryHolder();
            if (directoryHolder == null) {
                return;
            }
            File directory = directoryHolder.getDirectory();
            if (directory != null) {
                GUIMediator.launchExplorer(directory);
            }
        }
    }

    private final class SearchByMediaTypeRunnable
    implements Runnable {
        private final MediaTypeSavedFilesDirectoryHolder _mtsfdh;

        SearchByMediaTypeRunnable(MediaTypeSavedFilesDirectoryHolder mtsfdh) {
            this._mtsfdh = mtsfdh;
        }

        @Override
        public void run() {
            try {
                GUIMediator.safeInvokeLater(() -> LibraryMediator.instance().clearLibraryTable());
                ArrayList<File> cache = new ArrayList<File>(this._mtsfdh.getCache());
                if (cache.size() == 0) {
                    File torrentDataDirFile = SharingSettings.TORRENT_DATA_DIR_SETTING.getValue();
                    Set<File> ignore = TorrentUtil.getIgnorableFiles();
                    HashSet<File> directories = new HashSet<File>(LibrarySettings.DIRECTORIES_TO_INCLUDE.getValue());
                    directories.removeAll(LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.getValue());
                    for (File dir : directories) {
                        if (dir == null) continue;
                        if (dir.equals(torrentDataDirFile)) {
                            this.search(dir, ignore, LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.getValue());
                            continue;
                        }
                        if (dir.equals(LibrarySettings.USER_MUSIC_FOLDER.getValue()) && !this._mtsfdh.getMediaType().equals(MediaType.getAudioMediaType())) continue;
                        this.search(dir, new HashSet<File>(), LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.getValue());
                    }
                } else {
                    GUIMediator.safeInvokeLater(() -> LibraryMediator.instance().addFilesToLibraryTable(cache));
                }
                LibraryExplorer.this.executePendingRunnables();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        private void search(File file, Set<File> ignore, Set<File> exludedSubFolders) {
            if (file == null || !file.isDirectory() || !file.exists()) {
                return;
            }
            if (LibraryExplorer.this.getSelectedDirectoryHolder() == null) {
                LibraryExplorer.this.selectMediaTypeSavedFilesDirectoryHolderbyType(this._mtsfdh.getMediaType());
            }
            ArrayList<File> directories = new ArrayList<File>();
            ArrayList<File> files = new ArrayList<File>();
            for (File child : FileUtils.listFiles(file)) {
                DirectoryHolder directoryHolder = LibraryExplorer.this.getSelectedDirectoryHolder();
                if (!this._mtsfdh.equals(directoryHolder)) {
                    return;
                }
                if (ignore.contains(child) || child.isHidden()) continue;
                if (child.isDirectory() && !exludedSubFolders.contains(child)) {
                    directories.add(child);
                    continue;
                }
                if (!this._mtsfdh.accept(child)) continue;
                files.add(child);
            }
            this._mtsfdh.addToCache(files);
            Runnable r = () -> LibraryMediator.instance().addFilesToLibraryTable(files);
            GUIMediator.safeInvokeLater(r);
            for (File directory : directories) {
                this.search(directory, ignore, exludedSubFolders);
            }
        }
    }

    private class LibraryExplorerTreeSelectionListener
    implements TreeSelectionListener {
        private LibraryExplorerTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreeNode node = (TreeNode)LibraryExplorer.this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            LibraryExplorer.this.refreshSelection(false);
        }
    }
}

