/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.transfers;

import com.frostwire.gui.bittorrent.BittorrentDownload;
import com.frostwire.gui.components.transfers.TransferDetailComponent;
import com.frostwire.gui.components.transfers.TransferDetailTrackersTableMediator;
import com.frostwire.jlibtorrent.AnnounceEndpoint;
import com.frostwire.jlibtorrent.AnnounceEntry;
import com.frostwire.jlibtorrent.PeerInfo;
import com.frostwire.jlibtorrent.TorrentHandle;
import com.frostwire.jlibtorrent.TorrentStatus;
import com.frostwire.util.Logger;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public final class TransferDetailTrackers
extends JPanel
implements TransferDetailComponent.TransferDetailPanel {
    private static final Logger LOG = Logger.getLogger(TransferDetailTrackers.class);
    private final TransferDetailTrackersTableMediator tableMediator = new TransferDetailTrackersTableMediator();

    TransferDetailTrackers() {
        super(new MigLayout("fillx, gap 0 0, insets 0 0 0 0"));
        this.add((Component)this.tableMediator.getComponent(), "growx, growy");
    }

    @Override
    public void updateData(BittorrentDownload btDownload) {
        if (btDownload != null && btDownload.getDl() != null) {
            this.tableMediator.clearTable();
            try {
                TorrentHandle torrentHandle = btDownload.getDl().getTorrentHandle();
                if (torrentHandle == null) {
                    return;
                }
                TorrentStatus status = torrentHandle.status();
                List<PeerInfo> peerInfos = torrentHandle.peerInfo();
                List<AnnounceEntry> items = torrentHandle.trackers();
                if (items != null && items.size() > 0) {
                    int i2 = 0;
                    for (AnnounceEntry item : items) {
                        this.tableMediator.add(new TrackerItemHolder(i2++, item));
                    }
                }
                TrackerItemHolder dhtTrackerItemHolder = this.getSpecialAnnounceEntry(SpecialAnnounceEntryType.DHT, status, peerInfos);
                TrackerItemHolder lsdTrackerItemHolder = this.getSpecialAnnounceEntry(SpecialAnnounceEntryType.LSD, status, peerInfos);
                TrackerItemHolder pexTrackerItemHolder = this.getSpecialAnnounceEntry(SpecialAnnounceEntryType.PEX, status, peerInfos);
                this.tableMediator.add(pexTrackerItemHolder);
                this.tableMediator.add(lsdTrackerItemHolder);
                this.tableMediator.add(dhtTrackerItemHolder);
            }
            catch (Throwable e) {
                LOG.error("Error updating data: " + e.getMessage());
            }
        }
    }

    private TrackerItemHolder getSpecialAnnounceEntry(SpecialAnnounceEntryType entryType, TorrentStatus status, List<PeerInfo> peerInfosCopy) {
        boolean isActive = false;
        int seeds = 0;
        int peers = 0;
        long downloaded = 0L;
        int trackerOffset = this.tableMediator.getSize();
        if (status != null) {
            switch (entryType) {
                case DHT: {
                    trackerOffset += 2;
                    isActive = status.announcingToDht();
                    break;
                }
                case LSD: {
                    ++trackerOffset;
                    isActive = status.announcingToLsd();
                    break;
                }
                case PEX: {
                    isActive = false;
                }
            }
        }
        if (!peerInfosCopy.isEmpty()) {
            for (PeerInfo peer : peerInfosCopy) {
                boolean entryPEXMatchesSource;
                int PEER_SOURCE_FLAG_DHT = 2;
                boolean entryDHTMatchesSource = entryType == SpecialAnnounceEntryType.DHT && (peer.source() & PEER_SOURCE_FLAG_DHT) == PEER_SOURCE_FLAG_DHT;
                int PEER_SOURCE_FLAG_LSD = 8;
                boolean entryLSDMatchesSource = entryType == SpecialAnnounceEntryType.LSD && (peer.source() & PEER_SOURCE_FLAG_LSD) == PEER_SOURCE_FLAG_LSD;
                int PEER_SOURCE_FLAG_PEX = 4;
                boolean bl = entryPEXMatchesSource = entryType == SpecialAnnounceEntryType.PEX && (peer.source() & PEER_SOURCE_FLAG_PEX) == PEER_SOURCE_FLAG_PEX;
                if (!entryDHTMatchesSource && !entryLSDMatchesSource && !entryPEXMatchesSource) continue;
                int PEER_FLAG_SEED = 1024;
                if ((peer.flags() & PEER_FLAG_SEED) == PEER_FLAG_SEED) {
                    ++seeds;
                } else {
                    ++peers;
                }
                downloaded += peer.totalDownload();
            }
        }
        if (entryType == SpecialAnnounceEntryType.PEX) {
            isActive = peers > 0 || seeds > 0;
        }
        boolean stateObjAvailable = status != null;
        boolean activeState = false;
        if (stateObjAvailable) {
            TorrentStatus.State state = status.state();
            activeState = !state.equals((Object)TorrentStatus.State.FINISHED) && !state.equals((Object)TorrentStatus.State.UNKNOWN);
        }
        isActive = isActive && activeState;
        return new TrackerItemHolder(trackerOffset, isActive, seeds, peers, downloaded, entryType.name());
    }

    public static final class TrackerItemHolder {
        final int trackerOffset;
        final boolean isActive;
        final int seeds;
        final int peers;
        final long downloaded;
        final String url;

        TrackerItemHolder(int trackerOffset, boolean isActive, int seeds, int peers, long downloaded, String url) {
            this.trackerOffset = trackerOffset;
            this.isActive = isActive;
            this.seeds = seeds;
            this.peers = peers;
            this.downloaded = downloaded;
            this.url = url;
        }

        TrackerItemHolder(int trackerOffset, AnnounceEntry announceEntry) {
            int s = 0;
            int p = 0;
            long d = 0L;
            boolean a = false;
            for (AnnounceEndpoint endPoint : announceEntry.endpoints()) {
                s = Math.max(endPoint.scrapeComplete(), s);
                p = Math.max(endPoint.scrapeIncomplete(), p);
                d = Math.max((long)endPoint.scrapeDownloaded(), d);
                if (a || !endPoint.isWorking()) continue;
                a = true;
            }
            this.trackerOffset = trackerOffset;
            this.url = announceEntry.url();
            this.seeds = s;
            this.peers = p;
            this.downloaded = d;
            this.isActive = a;
        }

        public int hashCode() {
            return this.trackerOffset;
        }

        public boolean equals(Object obj) {
            return obj instanceof TrackerItemHolder && ((TrackerItemHolder)obj).trackerOffset == this.trackerOffset;
        }
    }

    private static enum SpecialAnnounceEntryType {
        DHT,
        LSD,
        PEX;

    }
}

