/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.transfers;

import com.frostwire.gui.bittorrent.BittorrentDownload;
import com.frostwire.gui.components.transfers.HexHivePanel;
import com.frostwire.gui.components.transfers.TransferDetailComponent;
import com.frostwire.jlibtorrent.PieceIndexBitfield;
import com.frostwire.jlibtorrent.TorrentHandle;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.jlibtorrent.TorrentStatus;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public final class TransferDetailPieces
extends JPanel
implements TransferDetailComponent.TransferDetailPanel {
    private final JLabel pieceSizeLabel;
    private final JLabel totalPiecesLabel;
    private final HexHivePanel hexHivePanel = new HexHivePanel(16, 2506835, 0xF2F2F2, 3388901, 0xFFFFFF, 5, 0, 0, 5, true);
    private final HexHiveAdapter hexHivePanelAdapter = new HexHiveAdapter();
    private boolean pieceSizeAlreadySet = false;
    private BittorrentDownload bittorrentDownload;

    TransferDetailPieces() {
        super(new MigLayout("fillx, insets 0 0 0 0, gap 0 5px"));
        this.pieceSizeLabel = new JLabel("<html><b>" + I18n.tr("Piece Size") + "</b>:</html>");
        this.totalPiecesLabel = new JLabel("<html><b>" + I18n.tr("Total Pieces") + "</b>:</html>");
        this.add((Component)this.totalPiecesLabel, "gapleft 10px");
        this.add((Component)this.pieceSizeLabel, "grow, gapright 10px, wmin 130px, hmax 25px, wrap");
        this.hexHivePanel.setBackground(Color.WHITE);
        this.hexHivePanel.setOpaque(true);
        JScrollPane jScrollPane = new JScrollPane(this.hexHivePanel);
        jScrollPane.setOpaque(true);
        jScrollPane.setBackground(Color.WHITE);
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.add((Component)jScrollPane, "push, grow, height 240px, gap 10px 10px 0px 5px, span 2");
        this.repaint();
    }

    @Override
    public void updateData(BittorrentDownload btDownload) {
        this.pieceSizeAlreadySet = this.bittorrentDownload == btDownload;
        this.bittorrentDownload = btDownload;
        this.hexHivePanelAdapter.updateData(this.bittorrentDownload);
        this.updatePieceSizeLabel(this.hexHivePanelAdapter.getPieceSizeInHuman());
        this.updateTotalPiecesLabel(this.hexHivePanelAdapter.getFullHexagonsCount() + "/" + this.hexHivePanelAdapter.getTotalHexagonsCount());
        if (this.hexHivePanelAdapter.getTotalHexagonsCount() >= 0) {
            this.hexHivePanel.updateData(this.hexHivePanelAdapter);
            this.hexHivePanel.invalidate();
        }
        this.invalidate();
        this.repaint();
    }

    private void updatePieceSizeLabel(String pieceSize) {
        if (!this.pieceSizeAlreadySet) {
            this.pieceSizeLabel.setText("<html><b nowrap>" + I18n.tr("Piece Size") + "</b>:" + pieceSize + "</html>");
            this.pieceSizeAlreadySet = true;
        }
    }

    private void updateTotalPiecesLabel(String totalPieces) {
        this.totalPiecesLabel.setText("<html><b>" + I18n.tr("Total Pieces") + "</b>:" + totalPieces + "</html>");
        this.totalPiecesLabel.paintImmediately(this.totalPiecesLabel.getVisibleRect());
    }

    private static final class HexHiveAdapter
    implements HexHivePanel.HexDataAdapter<BittorrentDownload> {
        private BittorrentDownload bittorrentDownload;
        private int totalPieces;
        private int numFullPieces;
        private PieceIndexBitfield pieces;
        private String pieceSizeInHuman;

        private HexHiveAdapter() {
        }

        @Override
        public void updateData(BittorrentDownload btDownload) {
            this.bittorrentDownload = btDownload;
            TorrentHandle torrentHandle = this.bittorrentDownload.getDl().getTorrentHandle();
            TorrentStatus status = torrentHandle.status(TorrentHandle.QUERY_PIECES);
            TorrentInfo torrentInfo = torrentHandle.torrentFile();
            this.pieceSizeInHuman = GUIUtils.getBytesInHuman(torrentInfo.pieceSize(0));
            this.totalPieces = torrentInfo.numPieces();
            this.pieces = status.pieces();
            if (this.pieces.isAllSet()) {
                this.numFullPieces = this.totalPieces;
            } else if (this.pieces.isNoneSet() || this.pieces.isEmpty()) {
                this.numFullPieces = 0;
            } else {
                this.numFullPieces = 0;
                for (int i2 = 0; i2 < this.pieces.count(); ++i2) {
                    if (!this.pieces.getBit(i2)) continue;
                    ++this.numFullPieces;
                }
            }
        }

        @Override
        public int getTotalHexagonsCount() {
            if (this.bittorrentDownload == null) {
                return 0;
            }
            return this.totalPieces;
        }

        @Override
        public int getFullHexagonsCount() {
            if (this.bittorrentDownload == null) {
                return 0;
            }
            return this.numFullPieces;
        }

        @Override
        public boolean isFull(int hexOffset) {
            return this.pieces.getBit(hexOffset);
        }

        String getPieceSizeInHuman() {
            return this.pieceSizeInHuman;
        }
    }
}

