/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.slides;

import com.frostwire.gui.components.slides.Slide;
import com.frostwire.gui.player.StreamMediaSource;
import com.limegroup.gnutella.gui.GUIMediator;
import org.limewire.util.StringUtils;

class SlidePanelController {
    private final Slide slide;

    SlidePanelController(Slide slide) {
        this.slide = slide;
    }

    public Slide getSlide() {
        return this.slide;
    }

    void downloadSlide() {
        switch (this.slide.method) {
            case 2: {
                if (this.slide.httpDownloadURL == null) break;
                GUIMediator.instance().openSlide(this.slide);
                break;
            }
            case 1: {
                if (this.slide.torrent == null) break;
                if (this.slide.torrent.toLowerCase().startsWith("http")) {
                    GUIMediator.instance().openTorrentURI(this.slide.torrent, false);
                    break;
                }
                if (!this.slide.torrent.toLowerCase().startsWith("magnet:?")) break;
                GUIMediator.instance().openTorrentURI(this.slide.torrent, false);
            }
        }
        if (this.slide.hasFlag(512) && this.slide.clickURL != null) {
            GUIMediator.openURL(this.slide.clickURL);
        }
    }

    void installSlide() {
        if (this.slide.method == 2 && this.slide.hasFlag(4)) {
            this.downloadSlide();
        }
    }

    void previewVideo() {
        String mediaURL = this.slide.videoURL;
        if (mediaURL != null && mediaURL.contains("youtube.com")) {
            GUIMediator.openURL(this.slide.videoURL);
        } else {
            this.previewMedia(mediaURL, true, 32);
        }
    }

    void previewAudio() {
        if (this.slide.hasFlag(16)) {
            GUIMediator.openURL(this.slide.audioURL);
        } else {
            this.previewMedia(this.slide.audioURL, false, 8);
        }
    }

    private void previewMedia(String mediaURL, boolean showMediaPlayer, int flagUsingFWPlayerForMediaType) {
        if (!StringUtils.isNullOrEmpty(mediaURL)) {
            StreamMediaSource mediaSource = new StreamMediaSource(mediaURL, this.slide.title, this.slide.clickURL, showMediaPlayer);
            if (this.slide.hasFlag(flagUsingFWPlayerForMediaType)) {
                GUIMediator.instance().launchMedia(mediaSource, true);
            } else {
                GUIMediator.instance().playInOS(mediaSource);
            }
        }
    }
}

