/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.slides;

import com.frostwire.gui.components.slides.Slide;
import com.frostwire.gui.components.slides.SlideList;
import com.frostwire.gui.components.slides.SlidePanel;
import com.frostwire.gui.components.slides.SlideshowPanel;
import com.frostwire.gui.components.slides.SlideshowPanelControls;
import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.JsonUtils;
import com.frostwire.util.Logger;
import com.frostwire.util.OSUtils;
import com.frostwire.util.http.HttpClient;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import javax.swing.JPanel;

public class MultimediaSlideshowPanel
extends JPanel
implements SlideshowPanel {
    private static final Logger LOG = Logger.getLogger(MultimediaSlideshowPanel.class);
    private SlideshowPanel.SlideshowListener listener;
    private List<Slide> slides;
    private List<Slide> fallbackSlides;
    private JPanel container;
    private boolean useControls;
    private Timer timer;

    public MultimediaSlideshowPanel(List<Slide> slides) {
        this.setupUI();
        this.setup(slides);
    }

    public MultimediaSlideshowPanel(String url, List<Slide> defaultSlides) {
        this.fallbackSlides = defaultSlides;
        this.setupUI();
        new Thread(() -> this.load(url)).start();
    }

    @Override
    public void setListener(SlideshowPanel.SlideshowListener listener) {
        this.listener = listener;
    }

    @Override
    public int getCurrentSlideIndex() {
        Component[] components;
        for (Component c : components = this.getComponents()) {
            if (!c.isVisible() || !(c instanceof SlidePanel)) continue;
            return ((SlidePanel)c).getIndex();
        }
        return -1;
    }

    @Override
    public void switchToSlide(int slideIndex) {
        if (slideIndex >= 0 && slideIndex < this.getNumSlides() && this.getLayout() instanceof CardLayout) {
            ((CardLayout)this.getLayout()).show(this, String.valueOf(slideIndex));
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Override
    public int getNumSlides() {
        if (this.slides == null) {
            return 0;
        }
        return this.slides.size();
    }

    private void setupUI() {
        this.setLayout(new CardLayout());
    }

    private void setup(List<Slide> slides) {
        this.slides = this.filter(slides);
        GUIMediator.safeInvokeLater(() -> {
            if (this.slides != null) {
                List<Slide> slides1 = this.slides;
                try {
                    int i2 = 0;
                    for (Slide s : slides1) {
                        this.add((Component)new SlidePanel(s, i2), String.valueOf(i2));
                        ++i2;
                    }
                    if (this.container != null && this.useControls) {
                        this.container.add((Component)new SlideshowPanelControls(this), "Last");
                    }
                    if (!slides1.isEmpty()) {
                        this.timer = new Timer("SlideShow Timer");
                        this.timer.schedule((TimerTask)new SlideSwitcher(), slides1.get((int)0).duration);
                    }
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), e);
                }
            }
        });
    }

    private void load(String url) {
        try {
            HttpClient client = HttpClientFactory.getInstance(HttpClientFactory.HttpContext.MISC);
            String jsonString = client.get(url);
            if (jsonString != null) {
                SlideList slideList = JsonUtils.toObject(jsonString, SlideList.class);
                try {
                    this.setup(slideList.slides);
                }
                catch (Exception e) {
                    LOG.info("Failed load of Slide Show:" + url, e);
                    this.setup(this.fallbackSlides);
                }
            } else {
                this.setup(this.fallbackSlides);
            }
        }
        catch (Exception e) {
            LOG.info("Failed load of Slide Show:" + url, e);
            this.setup(this.fallbackSlides);
        }
    }

    private boolean isMessageEligibleForMyLang(String lang) {
        if (lang == null || lang.equals("*")) {
            return true;
        }
        String langinapp = ApplicationSettings.getLanguage().toLowerCase();
        if (langinapp.length() > 2) {
            langinapp = langinapp.substring(0, 2);
        }
        return lang.toLowerCase().contains(langinapp);
    }

    private boolean isMessageEligibleForMyOs(String os) {
        if (os == null) {
            return true;
        }
        boolean im_mac_msg_for_me = os.contains("mac") && OSUtils.isMacOSX();
        boolean im_windows_msg_for_me = os.contains("windows") && OSUtils.isWindows();
        boolean im_linux_msg_for_me = os.contains("linux") && OSUtils.isLinux();
        return im_mac_msg_for_me || im_windows_msg_for_me || im_linux_msg_for_me;
    }

    private boolean isMessageEligibleForMyVersion(String versions) {
        if (versions == null || versions.equals("*")) {
            return true;
        }
        String frostWireVersion = FrostWireUtils.getFrostWireVersion();
        for (String pattern : versions.split(",")) {
            if (!Pattern.matches(pattern, frostWireVersion)) continue;
            return true;
        }
        return false;
    }

    private List<Slide> filter(List<Slide> slides) {
        ArrayList<Slide> result = new ArrayList<Slide>(slides.size());
        for (Slide slide : slides) {
            if (!this.isMessageEligibleForMyLang(slide.language) || !this.isMessageEligibleForMyOs(slide.os) || !this.isMessageEligibleForMyVersion(slide.includedVersions)) continue;
            result.add(slide);
        }
        return result;
    }

    @Override
    public void setupContainerAndControls(JPanel container, boolean useControls) {
        this.container = container;
        this.useControls = useControls;
    }

    private SlidePanel getCurrentSlidePanel() {
        Component[] components;
        for (Component c : components = this.getComponents()) {
            if (!c.isVisible() || !(c instanceof SlidePanel)) continue;
            return (SlidePanel)c;
        }
        return null;
    }

    class SlideSwitcher
    extends TimerTask {
        SlideSwitcher() {
        }

        @Override
        public void run() {
            SlidePanel currentSlidePanel = MultimediaSlideshowPanel.this.getCurrentSlidePanel();
            if ((currentSlidePanel == null || !currentSlidePanel.isOverlayVisible()) && MultimediaSlideshowPanel.this.getLayout() instanceof CardLayout) {
                ((CardLayout)MultimediaSlideshowPanel.this.getLayout()).next(MultimediaSlideshowPanel.this);
                if (MultimediaSlideshowPanel.this.listener != null) {
                    MultimediaSlideshowPanel.this.listener.onSlideChanged();
                }
            }
            if (currentSlidePanel != null) {
                MultimediaSlideshowPanel.this.timer.schedule((TimerTask)new SlideSwitcher(), currentSlidePanel.getSlide().duration);
            }
        }
    }
}

