/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.AlphaIcon;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.gui.components.transfers.TransferDetailFiles;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.player.MediaSource;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.FWAbstractJPanelTableCellRenderer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;

public class TransferDetailFilesActionsRenderer
extends FWAbstractJPanelTableCellRenderer {
    private static final ImageIcon play_solid = GUIMediator.getThemeImage("search_result_play_over");
    private static final AlphaIcon play_transparent = new AlphaIcon(play_solid, 0.1f);
    private static final ImageIcon share_solid = GUIMediator.getThemeImage("transfers_sharing_over");
    private static final AlphaIcon share_faded = new AlphaIcon(share_solid, 0.1f);
    private final JLabel playButton;
    private final JLabel shareButton;
    private TransferDetailFiles.TransferItemHolder transferItemHolder;

    public TransferDetailFilesActionsRenderer() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        this.setLayout(new MigLayout("gap 2px, fillx, center, insets 5px 5px 5px 5px", "[20px!][20px!]"));
        this.playButton = new JLabel(play_transparent);
        this.playButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1) {
                    TransferDetailFilesActionsRenderer.this.onPlay();
                }
            }
        });
        this.shareButton = new JLabel(share_faded);
        this.shareButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1) {
                    TransferDetailFilesActionsRenderer.this.onShare();
                }
            }
        });
        this.add((Component)this.playButton, "width 20px!, growx 0, aligny top, push");
        this.add((Component)this.shareButton, "width 20px!, growx 0, aligny top, push");
    }

    @Override
    protected void updateUIData(Object dataHolder, JTable table, int row, int column) {
        this.cancelEdit();
        if (!(dataHolder instanceof TransferDetailFiles.TransferItemHolder)) {
            if (this.transferItemHolder != null) {
                this.updateButtons();
            }
            return;
        }
        this.transferItemHolder = (TransferDetailFiles.TransferItemHolder)dataHolder;
        this.updateButtons();
    }

    private void onPlay() {
        if (!this.transferItemHolder.transferItem.isComplete()) {
            return;
        }
        new PlayAction(this.transferItemHolder).actionPerformed(null);
    }

    private void onShare() {
        if (!this.transferItemHolder.transferItem.isComplete()) {
            return;
        }
        File file = this.transferItemHolder.transferItem.getFile();
        if (TorrentUtil.askForPermissionToSeedAndSeedDownloads(null)) {
            new Thread(() -> {
                TorrentUtil.makeTorrentAndDownload(file, null, true);
                GUIMediator.safeInvokeLater(() -> BTDownloadMediator.instance().updateTableFilters());
            }).start();
        }
    }

    private void updateButtons() {
        if (this.transferItemHolder == null) {
            return;
        }
        this.playButton.setIcon(this.transferItemHolder.transferItem.isComplete() ? play_solid : play_transparent);
        this.shareButton.setIcon(this.transferItemHolder.transferItem.isComplete() ? share_solid : share_faded);
        this.playButton.invalidate();
        this.shareButton.invalidate();
    }

    public static final class PlayAction
    extends AbstractAction {
        private final TransferDetailFiles.TransferItemHolder transferItemHolder;

        public PlayAction(TransferDetailFiles.TransferItemHolder itemHolder) {
            this.transferItemHolder = itemHolder;
            this.putValue("Name", I18n.tr("Play"));
            this.putValue("LimeShortName", I18n.tr("Play"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = this.transferItemHolder.transferItem.getFile();
            if (MediaPlayer.isPlayableFile(file)) {
                MediaPlayer.instance().asyncLoadMedia(new MediaSource(file), false, false);
            } else {
                GUIMediator.launchFile(file);
            }
        }
    }

    public static final class OpenInFolderAction
    extends AbstractAction {
        private final TransferDetailFiles.TransferItemHolder transferItemHolder;

        public OpenInFolderAction(TransferDetailFiles.TransferItemHolder itemHolder) {
            this.transferItemHolder = itemHolder;
            this.putValue("Name", I18n.tr("Explore"));
            this.putValue("LimeShortName", I18n.tr("Explore"));
            this.putValue("ShortDescription", I18n.tr("Open Folder Containing the File"));
            this.putValue("LimeIconName", "LIBRARY_EXPLORE");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            File selectedFile = this.transferItemHolder.transferItem.getFile();
            if (selectedFile.isFile() && selectedFile.getParentFile() != null) {
                GUIMediator.launchExplorer(selectedFile);
            }
        }
    }
}

