/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.theme.ThemeMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TorrentSeedingSettingComponent
extends JPanel {
    private final boolean _precheck;
    private final boolean _border;
    private JRadioButton seedingRadioButton;
    private JRadioButton notSeedingRadioButton;

    public TorrentSeedingSettingComponent(boolean precheck, boolean useBorder) {
        this._precheck = precheck;
        this._border = useBorder;
        this.setupUI();
    }

    private void setupUI() {
        this.setLayout(new GridBagLayout());
        if (this._border) {
            this.setBorder(ThemeMediator.createTitledBorder(I18n.tr("Seeding Settings")));
        }
        this.initOptionButtons();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.gridwidth = 0;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        this.add((Component)this.seedingRadioButton, c);
        this.add((Component)this.notSeedingRadioButton, c);
    }

    private void initOptionButtons() {
        this.seedingRadioButton = new JRadioButton("<html>" + I18n.tr("<strong>Seed finished downloads.</strong> BitTorrent users on the internet will be able<br/>to download file chunks of the data your torrents seed. (Recommended)") + "</html>");
        this.notSeedingRadioButton = new JRadioButton("<html>" + I18n.tr("<strong>Don't seed finished downloads.</strong> BitTorrent users on the internet may<br/>only download file chunks of that torrent from you while you're downloading its<br/>data files. <strong>Some trackers will penalize this Leeching behavior</strong>.") + "</html>");
        ButtonGroup radioGroup = new ButtonGroup();
        radioGroup.add(this.seedingRadioButton);
        radioGroup.add(this.notSeedingRadioButton);
        if (this._precheck) {
            if (SharingSettings.SEED_FINISHED_TORRENTS.getValue()) {
                this.seedingRadioButton.setSelected(true);
                this.notSeedingRadioButton.setSelected(false);
            } else {
                this.notSeedingRadioButton.setSelected(true);
                this.seedingRadioButton.setSelected(false);
            }
        }
    }

    public boolean wantsSeeding() {
        return this.seedingRadioButton.isSelected();
    }

    public boolean hasOneBeenSelected() {
        return this.seedingRadioButton.isSelected() || this.notSeedingRadioButton.isSelected();
    }
}

