/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.bittorrent.BittorrentDownload;
import com.frostwire.gui.bittorrent.HttpBTDownload;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.mp3.ID3Wrapper;
import com.frostwire.mp3.ID3v1Tag;
import com.frostwire.mp3.ID3v23Tag;
import com.frostwire.mp3.Mp3File;
import com.frostwire.search.soundcloud.SoundcloudSearchResult;
import com.frostwire.transfers.TransferState;
import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.OSUtils;
import com.frostwire.util.http.HttpClient;
import com.limegroup.gnutella.gui.iTunesMediator;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.iTunesSettings;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.io.FilenameUtils;

public class SoundcloudDownload
extends HttpBTDownload {
    private static final Executor SOUNDCLOUD_THREAD_POOL = Executors.newFixedThreadPool(6);
    private final SoundcloudSearchResult sr;
    private final File tempAudio;

    SoundcloudDownload(SoundcloudSearchResult sr) {
        super(sr.getFilename(), sr.getSize());
        this.sr = sr;
        String filename = sr.getFilename();
        this.tempAudio = SoundcloudDownload.buildTempFile(FilenameUtils.getBaseName(filename), "mp3");
        this.start();
    }

    @Override
    HttpClient.HttpClientListener createHttpClientListener() {
        return new HttpDownloadListenerImpl(this);
    }

    @Override
    public double getSize() {
        if (this.isCompleted() && this.getSaveLocation().exists()) {
            return this.getSaveLocation().length();
        }
        return this.size;
    }

    @Override
    public String getDisplayName() {
        return this.sr.getDisplayName();
    }

    @Override
    public String getName() {
        return this.sr.getFilename();
    }

    @Override
    public void resume() {
        this.start();
    }

    @Override
    public String getHash() {
        return this.sr.getHash();
    }

    private void start() {
        this.start(this.tempAudio);
    }

    private void start(File temp) {
        this.state = TransferState.WAITING;
        SOUNDCLOUD_THREAD_POOL.execute(() -> {
            String downloadUrl = null;
            try {
                downloadUrl = this.sr.getDownloadUrl();
                this.httpClient.save(downloadUrl, temp, false);
            }
            catch (Throwable e) {
                System.err.println("URL at issue: [" + downloadUrl + "]");
                e.printStackTrace();
                this.httpClientListener.onError(this.httpClient, e);
            }
        });
    }

    @Override
    void cleanupIncomplete() {
        this.cleanupFile(this.tempAudio);
    }

    public boolean equals(Object obj) {
        return obj instanceof SoundcloudDownload && this.sr.getHash().equals(((SoundcloudDownload)obj).sr.getHash());
    }

    private boolean setAlbumArt(String mp3Filename, String mp3outputFilename) {
        try {
            byte[] imageBytes = HttpClientFactory.getInstance(HttpClientFactory.HttpContext.DOWNLOAD).getBytes(this.sr.getThumbnailUrl());
            Mp3File mp3 = new Mp3File(mp3Filename);
            ID3Wrapper newId3Wrapper = new ID3Wrapper(new ID3v1Tag(), new ID3v23Tag());
            newId3Wrapper.setAlbum(this.sr.getUsername() + ": " + this.sr.getDisplayName() + " via SoundCloud.com");
            newId3Wrapper.setArtist(this.sr.getUsername());
            newId3Wrapper.setTitle(this.sr.getDisplayName());
            newId3Wrapper.setAlbumImage(imageBytes, "image/jpg");
            newId3Wrapper.setUrl(this.sr.getDetailsUrl());
            newId3Wrapper.getId3v2Tag().setPadding(true);
            mp3.setId3v1Tag(newId3Wrapper.getId3v1Tag());
            mp3.setId3v2Tag(newId3Wrapper.getId3v2Tag());
            mp3.save(mp3outputFilename);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public File getPreviewFile() {
        if (this.isCompleted()) {
            return this.completeFile;
        }
        return this.tempAudio;
    }

    private final class HttpDownloadListenerImpl
    implements HttpClient.HttpClientListener {
        private final SoundcloudDownload dl;

        HttpDownloadListenerImpl(SoundcloudDownload soundcloudDownload2) {
            this.dl = soundcloudDownload2;
        }

        @Override
        public void onError(HttpClient client, Throwable e) {
            SoundcloudDownload.this.state = TransferState.ERROR;
            SoundcloudDownload.this.cleanup();
        }

        @Override
        public void onData(HttpClient client, byte[] buffer, int offset, int length) {
            if (!SoundcloudDownload.this.state.equals((Object)TransferState.PAUSING) && !SoundcloudDownload.this.state.equals((Object)TransferState.CANCELING)) {
                SoundcloudDownload.this.bytesReceived += (long)length;
                SoundcloudDownload.this.updateAverageDownloadSpeed();
                SoundcloudDownload.this.state = TransferState.DOWNLOADING;
            }
        }

        @Override
        public void onComplete(HttpClient client) {
            if (SoundcloudDownload.this.state != TransferState.REDIRECTING) {
                boolean renameTo;
                if (!SoundcloudDownload.this.setAlbumArt(SoundcloudDownload.this.tempAudio.getAbsolutePath(), SoundcloudDownload.this.completeFile.getAbsolutePath()) && !(renameTo = SoundcloudDownload.this.tempAudio.renameTo(SoundcloudDownload.this.completeFile))) {
                    if (!MediaPlayer.instance().isThisBeingPlayed(SoundcloudDownload.this.tempAudio)) {
                        SoundcloudDownload.this.state = TransferState.ERROR_MOVING_INCOMPLETE;
                        SoundcloudDownload.this.cleanupIncomplete();
                        return;
                    }
                    boolean copiedTo = HttpBTDownload.copyPlayingTemp(SoundcloudDownload.this.tempAudio, SoundcloudDownload.this.completeFile);
                    if (!copiedTo) {
                        SoundcloudDownload.this.state = TransferState.ERROR_MOVING_INCOMPLETE;
                        SoundcloudDownload.this.cleanupIncomplete();
                        return;
                    }
                    SoundcloudDownload.this.state = TransferState.ERROR_MOVING_INCOMPLETE;
                    SoundcloudDownload.this.cleanupIncomplete();
                    return;
                }
                SoundcloudDownload.this.state = TransferState.FINISHED;
                if (SharingSettings.SEED_FINISHED_TORRENTS.getValue()) {
                    BittorrentDownload.RendererHelper.onSeedTransfer(this.dl, false);
                }
                if (iTunesSettings.ITUNES_SUPPORT_ENABLED.getValue() && !iTunesMediator.instance().isScanned(SoundcloudDownload.this.completeFile) && (OSUtils.isMacOSX() || OSUtils.isWindows())) {
                    iTunesMediator.instance().scanForSongs(SoundcloudDownload.this.completeFile);
                }
                SoundcloudDownload.this.cleanupIncomplete();
            }
        }

        @Override
        public void onCancel(HttpClient client) {
            if (SoundcloudDownload.this.state.equals((Object)TransferState.CANCELING)) {
                SoundcloudDownload.this.cleanup();
                SoundcloudDownload.this.state = TransferState.CANCELED;
            } else {
                SoundcloudDownload.this.state = SoundcloudDownload.this.state.equals((Object)TransferState.PAUSING) ? TransferState.PAUSED : TransferState.CANCELED;
            }
        }

        @Override
        public void onHeaders(HttpClient httpClient, Map<String, List<String>> headerFields) {
            if (headerFields != null && headerFields.containsKey("Content-Length")) {
                String lengthStr = headerFields.get("Content-Length").get(0);
                SoundcloudDownload.this.size = Long.parseLong(lengthStr);
            }
        }
    }
}

