/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.bittorrent.BTEngine;
import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.JsonUtils;
import com.frostwire.util.UrlUtils;
import com.frostwire.util.UserAgentGenerator;
import com.frostwire.util.http.HttpClient;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;

public class ShareTorrentDialog
extends JDialog {
    private final TorrentInfo torrent;
    private Container container;
    private JEditorPane textArea;
    private Action[] actions;
    private JLabel feedbackLabel;
    private List<URLShortenerHttpClientListener> shortenerListeners;
    private String link;
    private String info_hash;
    private String torrent_name;

    public ShareTorrentDialog(JFrame frame, TorrentInfo torrent) {
        super(frame);
        this.torrent = torrent;
        this.setupUI();
        this.setLocationRelativeTo(frame);
    }

    private void initURLShortenerListeners() {
        URLShortenerHttpClientListener tinyurlShortenerListener = new URLShortenerHttpClientListener("http://tinyurl.com/api-create.php?url=" + this.getLink());
        GoogleURLShortenerListener googShortenerListener = new GoogleURLShortenerListener("https://www.googleapis.com/urlshortener/v1/url?key=AIzaSyDw6xPSKYZyOIv7rq2A0R9fDvzsrpI25I0");
        this.shortenerListeners = new LinkedList<URLShortenerHttpClientListener>(Arrays.asList(googShortenerListener, tinyurlShortenerListener));
    }

    private void updateTextArea() {
        GUIMediator.safeInvokeLater(() -> {
            this.textArea.setText(I18n.tr("Download") + " \"" + this.torrent_name.replace("_", " ") + "\" " + I18n.tr("at") + " " + this.getLink().trim() + " " + I18n.tr("via FrostWire"));
            this.textArea.selectAll();
        });
    }

    private void setupUI() {
        this.setupWindow();
        this.initTorrentName();
        this.initInfoHash();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(20, 10, 10, 10);
        boolean folderTorrent = this.torrent.numFiles() > 1;
        JLabel _introLabel = new JLabel(folderTorrent ? String.format(I18n.tr("Use the following text to share the \"%s\" folder"), this.torrent_name) : String.format(I18n.tr("Use the following text to share the \"%s\" file"), this.torrent_name));
        _introLabel.setFont(new Font("Dialog", 1, 13));
        this.container.add((Component)_introLabel, c);
        c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.6;
        c.gridwidth = 0;
        c.insets = new Insets(1, 10, 1, 10);
        this.textArea = new JEditorPane();
        this.textArea.setEditable(false);
        this.updateTextArea();
        Font f = new Font("Dialog", 0, 14);
        this.textArea.setFont(f);
        this.textArea.setMargin(new Insets(10, 10, 10, 10));
        this.textArea.setBorder(BorderFactory.createEtchedBorder());
        this.textArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ShareTorrentDialog.this.textArea.selectAll();
            }
        });
        this.textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                boolean allTextAlreadySelected;
                boolean bl = allTextAlreadySelected = ShareTorrentDialog.this.textArea.getSelectedText() != null && ShareTorrentDialog.this.textArea.getSelectedText().equals(ShareTorrentDialog.this.textArea.getText());
                if (allTextAlreadySelected || SwingUtilities.isRightMouseButton(e)) {
                    ShareTorrentDialog.this.textArea.select(0, 0);
                    return;
                }
                ShareTorrentDialog.this.textArea.selectAll();
            }
        });
        this.container.add((Component)this.textArea, c);
        this.initURLShortenerListeners();
        this.performAsyncURLShortening(this.shortenerListeners.get(new Random().nextInt(this.shortenerListeners.size() - 1)));
        this.initActions();
        c = new GridBagConstraints();
        c.anchor = 10;
        c.gridwidth = 0;
        c.insets = new Insets(10, 10, 10, 10);
        ButtonRow buttonRow = new ButtonRow(this.actions, 0, 13);
        this.fixButtonsFont(buttonRow);
        this.fixButtonBorders(buttonRow);
        ToolTipManager.sharedInstance().setInitialDelay(200);
        this.container.add((Component)buttonRow, c);
        c = new GridBagConstraints();
        c.anchor = 21;
        c.gridwidth = 0;
        c.insets = new Insets(0, 10, 0, 10);
        this.container.add((Component)new JLabel(I18n.tr("Tips")), c);
        c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.insets = new Insets(10, 10, 10, 10);
        JLabel _tipsLabel = new JLabel("<html><p> > " + I18n.tr("<strong>Keep FrostWire Open</strong> until the file has been downloaded by at least one other friend.") + "</p><p>&nbsp;</p><p> >" + I18n.tr("<strong>The more, the merrier.</strong> The more people sharing the faster it can be downloaded by others.") + "</p><p>&nbsp;</p><p> >" + I18n.tr("<strong>Your files can be discovered by others.</strong> Once you share this link and you seed the files they will be available to everybody on the BitTorrent network.") + "</p></html>");
        _tipsLabel.setFont(new Font("Dialog", 0, 14));
        Border tipsBorder = BorderFactory.createSoftBevelBorder(1);
        tipsBorder.getBorderInsets(_tipsLabel).set(20, 20, 20, 20);
        _tipsLabel.setBorder(tipsBorder);
        this.container.add((Component)_tipsLabel, c);
        JPanel glass = (JPanel)this.getGlassPane();
        glass.setLayout(null);
        glass.setVisible(true);
        this.feedbackLabel = new JLabel(I18n.tr("Feedback here to clipboard"));
        this.feedbackLabel.setVisible(false);
        this.feedbackLabel.setFont(new Font("Arial", 1, 14));
        glass.add(this.feedbackLabel);
        this.feedbackLabel.setBounds(100, 100, 300, 20);
        this.addEscapeKeyListener();
        GUIUtils.addHideAction((JComponent)this.getContentPane());
        this.pack();
    }

    private void addEscapeKeyListener() {
        this.getRootPane().registerKeyboardAction(e -> this.dispose(), KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void fixButtonsFont(ButtonRow buttonRow) {
        if (this.actions == null) {
            return;
        }
        for (int i2 = 0; i2 < this.actions.length; ++i2) {
            JButton buttonAtIndex = buttonRow.getButtonAtIndex(i2);
            buttonAtIndex.setFont(new Font("Lucida Grande", 1, 16));
        }
    }

    private void fixButtonBorders(ButtonRow buttonRow) {
        if (this.actions == null) {
            return;
        }
        for (int i2 = 0; i2 < this.actions.length; ++i2) {
            JButton buttonAtIndex = buttonRow.getButtonAtIndex(i2);
            buttonAtIndex.setBorderPainted(true);
        }
    }

    private void initTorrentName() {
        this.torrent_name = this.torrent.name();
    }

    private void initInfoHash() {
        this.info_hash = this.torrent.infoHash().toString();
    }

    private String getLink() {
        if (this.link == null) {
            this.link = "http://maglnk.xyz/" + this.info_hash + "/?" + TorrentUtil.getMagnetURLParameters(this.torrent);
        }
        return this.link;
    }

    private void performAsyncURLShortening(URLShortenerHttpClientListener listener) {
        HttpClient browser = HttpClientFactory.getInstance(HttpClientFactory.HttpContext.MISC);
        browser.setListener(listener);
        GUIMediator.instance().uiThreadPool().execute(listener.getHttpRequestRunnable(browser));
    }

    private void initActions() {
        this.actions = new Action[4];
        this.actions[0] = new TwitterAction();
        this.actions[1] = new CopyToClipboardAction();
        this.actions[2] = new CopyLinkAction();
        this.actions[3] = new CopyMagnetAction();
    }

    private void setupWindow() {
        this.setTitle(I18n.tr("All done! Now share the link"));
        Dimension prefDimension = new Dimension(640, 390);
        this.setSize(prefDimension);
        this.setMinimumSize(prefDimension);
        this.setPreferredSize(prefDimension);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        GUIUtils.addHideAction((JComponent)this.getContentPane());
        this.container = this.getContentPane();
        this.container.setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(this){

            @Override
            public void windowClosing(WindowEvent e) {
                ToolTipManager.sharedInstance().setInitialDelay(500);
            }
        });
    }

    private void showFeedback(String title, double x, double y) {
        int startY = (int)(y - this.getLocationOnScreen().getY() - 40.0);
        this.feedbackLabel.setLocation((int)(x - this.getLocationOnScreen().getX()), startY);
        this.feedbackLabel.setVisible(true);
        this.feedbackLabel.setText(title);
    }

    private class URLShortenerHttpClientListener
    extends HttpClient.HttpClientListenerAdapter {
        private final String shortenerUri;

        URLShortenerHttpClientListener(String uri) {
            this.shortenerUri = uri;
        }

        @Override
        public void onError(HttpClient client, Throwable e) {
            if (ShareTorrentDialog.this.shortenerListeners.size() > 1) {
                ShareTorrentDialog.this.shortenerListeners.remove(0);
                ShareTorrentDialog.this.performAsyncURLShortening(ShareTorrentDialog.this.shortenerListeners.get(0));
                System.out.println(">>> URLShortenerHttpClientListener ERROR >>>");
                e.printStackTrace();
                System.out.println();
                System.out.println("Try shortening with URL: [" + this.shortenerUri + "]");
                System.out.println(">>> URLShortenerHttpClientListener ERROR >>>");
            }
        }

        String getShortenerURL() {
            return this.shortenerUri;
        }

        Runnable getHttpRequestRunnable(HttpClient browser) {
            return () -> {
                try {
                    System.out.println("Shortening with " + this.getShortenerURL());
                    ShareTorrentDialog.this.link = browser.get(this.getShortenerURL(), 2000);
                    ShareTorrentDialog.this.updateTextArea();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            };
        }
    }

    private class GoogleURLShortenerListener
    extends URLShortenerHttpClientListener {
        GoogleURLShortenerListener(String uri) {
            super(uri);
        }

        @Override
        protected Runnable getHttpRequestRunnable(HttpClient browser) {
            return () -> {
                try {
                    String jsonRequest = "{\"longUrl\": \"" + ShareTorrentDialog.this.getLink() + "\"}";
                    String jsonResponse = browser.post(this.getShortenerURL(), 2000, UserAgentGenerator.getUserAgent(), jsonRequest, "application/json", false);
                    GoogleURLShortenerResponse response = JsonUtils.toObject(jsonResponse, GoogleURLShortenerResponse.class);
                    ShareTorrentDialog.this.link = response.id;
                    ShareTorrentDialog.this.updateTextArea();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            };
        }
    }

    private class TwitterAction
    extends AbstractAction {
        TwitterAction() {
            this.putValue("Name", I18n.tr("Twitter it"));
            this.putValue("ShortDescription", I18n.tr("Send the message above to Twitter"));
            this.putValue("LimeIconName", "TWITTER");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GUIMediator.openURL("http://twitter.com/intent/tweet?source=FrostWire&text=" + UrlUtils.encode(ShareTorrentDialog.this.textArea.getText()));
        }
    }

    private class CopyToClipboardAction
    extends AbstractAction {
        CopyToClipboardAction() {
            this.putValue("Name", I18n.tr("Copy Text"));
            this.putValue("ShortDescription", I18n.tr("Copy entire message to Clipboard"));
            this.putValue("LimeIconName", "COPY_PASTE");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GUIMediator.setClipboardContent(ShareTorrentDialog.this.textArea.getText());
            ShareTorrentDialog.this.setTitle(I18n.tr("Message copied to clipboard."));
            JButton source2 = (JButton)e.getSource();
            ShareTorrentDialog.this.showFeedback(ShareTorrentDialog.this.getTitle(), source2.getLocationOnScreen().getX(), source2.getLocationOnScreen().getY());
        }
    }

    class CopyLinkAction
    extends AbstractAction {
        CopyLinkAction() {
            this.putValue("Name", I18n.tr("Copy Link"));
            this.putValue("ShortDescription", I18n.tr("Copy Link to Clipboard"));
            this.putValue("LimeIconName", "LINK");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GUIMediator.setClipboardContent(ShareTorrentDialog.this.link);
            ShareTorrentDialog.this.setTitle(I18n.tr("Link copied to clipboard."));
            JButton source2 = (JButton)e.getSource();
            ShareTorrentDialog.this.showFeedback(ShareTorrentDialog.this.getTitle(), source2.getLocationOnScreen().getX(), source2.getLocationOnScreen().getY());
        }
    }

    private class CopyMagnetAction
    extends AbstractAction {
        CopyMagnetAction() {
            this.putValue("Name", I18n.tr("Copy Magnet"));
            this.putValue("ShortDescription", I18n.tr("Copy Magnet URL to Clipboard"));
            this.putValue("LimeIconName", "MAGNET");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GUIMediator.setClipboardContent(TorrentUtil.getMagnet(ShareTorrentDialog.this.info_hash) + BTEngine.getInstance().magnetPeers());
            ShareTorrentDialog.this.setTitle(I18n.tr("Magnet copied to clipboard."));
            JButton source2 = (JButton)e.getSource();
            ShareTorrentDialog.this.showFeedback(ShareTorrentDialog.this.getTitle(), source2.getLocationOnScreen().getX(), source2.getLocationOnScreen().getY());
        }
    }

    private class GoogleURLShortenerResponse {
        String id;

        private GoogleURLShortenerResponse(ShareTorrentDialog shareTorrentDialog) {
        }
    }
}

