/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.jlibtorrent.swig.error_code;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JProgressBar;

public class SendFileProgressDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(SendFileProgressDialog.class);
    private final TorrentMakerListener torrentMakerListener;
    private JProgressBar _progressBar;
    private Container _container;
    private File _preselectedFile;

    public SendFileProgressDialog(JFrame frame, File file) {
        this(frame);
        this._preselectedFile = file;
    }

    public SendFileProgressDialog(JFrame frame) {
        super(frame);
        this.setupUI();
        this.setLocationRelativeTo(frame);
        this.torrentMakerListener = new TorrentMakerListener();
    }

    private void setupUI() {
        this.setupWindow();
        this.initProgressBar();
        this.initCancelButton();
    }

    private void setupWindow() {
        String itemType = I18n.tr("Preparing selection");
        this.setTitle(itemType + ", " + I18n.tr("please wait..."));
        Dimension prefDimension = new Dimension(512, 100);
        this.setSize(prefDimension);
        this.setMinimumSize(prefDimension);
        this.setPreferredSize(prefDimension);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                SendFileProgressDialog.this.this_windowOpened();
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }
        });
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        GUIUtils.addHideAction((JComponent)this.getContentPane());
        this._container = this.getContentPane();
        this._container.setLayout(new GridBagLayout());
    }

    private void initCancelButton() {
        JButton _cancelButton = new JButton(I18n.tr("Cancel"));
        _cancelButton.addActionListener(e -> this.onCancelButton());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 22;
        c.insets = new Insets(10, 0, 10, 10);
        this._container.add((Component)_cancelButton, c);
    }

    private void onCancelButton() {
        this.dispose();
    }

    private void initProgressBar() {
        this._progressBar = new JProgressBar(0, 100);
        this._progressBar.setStringPainted(true);
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 21;
        c.insets = new Insets(10, 10, 10, 10);
        c.gridwidth = -1;
        this._container.add((Component)this._progressBar, c);
    }

    private void this_windowOpened() {
        if (this._preselectedFile == null) {
            this.chooseFile();
        } else {
            new Thread(() -> this.onApprovedFileSelectionToSend(this._preselectedFile.getAbsoluteFile())).start();
        }
    }

    private void chooseFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setDialogTitle(I18n.tr("Select the content you want to send"));
        fileChooser.setApproveButtonText(I18n.tr("Select"));
        int result = fileChooser.showOpenDialog(this);
        if (result == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            new Thread(() -> this.onApprovedFileSelectionToSend(selectedFile.getAbsoluteFile())).start();
        } else if (result == 1) {
            this.onCancelButton();
        } else if (result == -1) {
            LOG.error("Error selecting the file");
        }
    }

    private void onApprovedFileSelectionToSend(File absoluteFile) {
        TorrentUtil.makeTorrentAndDownload(absoluteFile, this.torrentMakerListener, true);
    }

    private class TorrentMakerListener
    implements TorrentUtil.UITorrentMakerListener {
        private TorrentMakerListener() {
        }

        @Override
        public void onCreateTorrentError(error_code ec) {
            GUIMediator.safeInvokeLater(() -> SendFileProgressDialog.this._progressBar.setString("Error: " + ec.message()));
        }

        @Override
        public void beforeOpenForSeedInUIThread() {
            SendFileProgressDialog.this.dispose();
        }

        @Override
        public void onException() {
            GUIMediator.safeInvokeLater(() -> SendFileProgressDialog.this._progressBar.setString("There was an error. Make sure the file/folder is not empty."));
        }
    }
}

