/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.bittorrent.BTEngine;
import com.frostwire.bittorrent.PaymentOptions;
import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadActions;
import com.frostwire.gui.bittorrent.BTDownloadButtons;
import com.frostwire.gui.bittorrent.BTDownloadDataLine;
import com.frostwire.gui.bittorrent.BTDownloadMediatorAdvancedMenuFactory;
import com.frostwire.gui.bittorrent.BTDownloadRowFilteredModel;
import com.frostwire.gui.bittorrent.BTDownloadTransferHandler;
import com.frostwire.gui.bittorrent.BittorrentDownload;
import com.frostwire.gui.bittorrent.HttpDownload;
import com.frostwire.gui.bittorrent.PartialFilesDialog;
import com.frostwire.gui.bittorrent.PaymentOptionsRenderer;
import com.frostwire.gui.bittorrent.SeedingHolder;
import com.frostwire.gui.bittorrent.SlideDownload;
import com.frostwire.gui.bittorrent.SoundcloudDownload;
import com.frostwire.gui.bittorrent.TorrentFetcherDownload;
import com.frostwire.gui.bittorrent.TransferActionsRenderer;
import com.frostwire.gui.bittorrent.TransferDetailFilesActionsRenderer;
import com.frostwire.gui.bittorrent.TransferHolder;
import com.frostwire.gui.bittorrent.TransferSeedingRenderer;
import com.frostwire.gui.components.slides.Slide;
import com.frostwire.gui.components.transfers.TransferDetailFiles;
import com.frostwire.gui.filters.TableLineFilter;
import com.frostwire.gui.library.LibraryFilesTableMediator;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.tabs.TransfersTab;
import com.frostwire.gui.theme.SkinMenu;
import com.frostwire.gui.theme.SkinMenuItem;
import com.frostwire.gui.theme.SkinPopupMenu;
import com.frostwire.mp4.Mp4Demuxer;
import com.frostwire.mp4.Mp4Info;
import com.frostwire.search.soundcloud.SoundcloudSearchPerformer;
import com.frostwire.search.soundcloud.SoundcloudSearchResult;
import com.frostwire.search.torrent.TorrentItemSearchResult;
import com.frostwire.search.torrent.TorrentSearchResult;
import com.frostwire.transfers.TransferState;
import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.Logger;
import com.frostwire.util.OSUtils;
import com.frostwire.util.http.HttpClient;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.VPNDropGuard;
import com.limegroup.gnutella.gui.iTunesMediator;
import com.limegroup.gnutella.gui.search.GenericCellEditor;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.BittorrentSettings;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.TablesHandlerSettings;
import com.limegroup.gnutella.settings.iTunesSettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;
import org.limewire.util.FileUtils;

public final class BTDownloadMediator
extends AbstractTableMediator<BTDownloadRowFilteredModel, BTDownloadDataLine, BTDownload>
implements TransfersTab.TransfersFilterModeListener {
    public static final int MIN_HEIGHT = 150;
    private static final Logger LOG = Logger.getLogger(BTDownloadMediator.class);
    private static BTDownloadMediator INSTANCE;
    private BTDownloadSelectionListener transferTabSelectionListener;
    private Action retryAction;
    private Action removeAction;
    private Action removeYouTubeAction;
    private Action resumeAction;
    private Action pauseAction;
    private Action exploreAction;
    private Action copyMagnetAction;
    private Action copyHashAction;
    private Action shareTorrentAction;
    private Action showInLibraryAction;
    private Action clearInactiveAction;
    private TransfersFilter transfersFilter;
    private Action sendToItunesAction;
    private BTDownloadActions.PlaySingleMediaFileAction playSingleMediaFileAction;

    private BTDownloadMediator() {
        super("DOWNLOAD_TABLE");
        this.TABLE.setRowHeight(30);
        GUIMediator.addRefreshListener(this);
        this.restoreSorting();
    }

    public static BTDownloadMediator instance() {
        if (INSTANCE == null) {
            INSTANCE = new BTDownloadMediator();
        }
        return INSTANCE;
    }

    private static boolean isActive(BTDownload dl) {
        if (dl == null) {
            return false;
        }
        TransferState state = dl.getState();
        return state == TransferState.CHECKING || state == TransferState.DOWNLOADING || state == TransferState.DOWNLOADING_METADATA || state == TransferState.DOWNLOADING_TORRENT || state == TransferState.SEEDING || state == TransferState.UPLOADING;
    }

    public void selectBTDownload(BTDownload lastSelectedDownload) {
        if (lastSelectedDownload == null) {
            return;
        }
        BTDownloadDataLine btDownloadDataLine = (BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(lastSelectedDownload);
        if (btDownloadDataLine == null) {
            return;
        }
        int row = ((BTDownloadRowFilteredModel)this.DATA_MODEL).getRow(btDownloadDataLine);
        if (row == -1) {
            return;
        }
        this.TABLE.setSelectedRow(row);
        this.TABLE.ensureRowVisible(row);
    }

    public void ensureDownloadVisible(BTDownload download) {
        if (download == null) {
            return;
        }
        BTDownloadDataLine btDownloadDataLine = (BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(download);
        if (btDownloadDataLine == null) {
            return;
        }
        int row = ((BTDownloadRowFilteredModel)this.DATA_MODEL).getRow(btDownloadDataLine);
        if (row == -1) {
            return;
        }
        this.TABLE.validate();
        this.TABLE.ensureRowVisible(row);
    }

    @Override
    protected void buildSettings() {
        this.SETTINGS = new TableSettings(this, this.ID){

            @Override
            public boolean getDefaultTooltips() {
                return false;
            }
        };
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setDragEnabled(true);
        this.TABLE.setTransferHandler(new BTDownloadTransferHandler());
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        this.clearInactiveAction = BTDownloadActions.CLEAR_INACTIVE_ACTION;
        this.retryAction = BTDownloadActions.RETRY_ACTION;
        this.removeAction = BTDownloadActions.REMOVE_ACTION;
        this.removeYouTubeAction = BTDownloadActions.REMOVE_YOUTUBE_ACTION;
        this.resumeAction = BTDownloadActions.RESUME_ACTION;
        this.pauseAction = BTDownloadActions.PAUSE_ACTION;
        this.exploreAction = BTDownloadActions.EXPLORE_ACTION;
        this.showInLibraryAction = BTDownloadActions.SHOW_IN_LIBRARY_ACTION;
        this.copyMagnetAction = BTDownloadActions.COPY_MAGNET_ACTION;
        this.copyHashAction = BTDownloadActions.COPY_HASH_ACTION;
        this.shareTorrentAction = BTDownloadActions.SHARE_TORRENT_ACTION;
        this.sendToItunesAction = BTDownloadActions.SEND_TO_ITUNES_ACTION;
        this.playSingleMediaFileAction = BTDownloadActions.PLAY_SINGLE_AUDIO_FILE_ACTION;
    }

    public Action[] getActions() {
        return new Action[]{this.resumeAction, this.pauseAction, this.retryAction, this.showInLibraryAction, this.exploreAction, this.removeAction, this.clearInactiveAction};
    }

    @Override
    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel();
        this.transfersFilter = new TransfersFilter(this);
        this.DATA_MODEL = new BTDownloadRowFilteredModel(this.transfersFilter);
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this.TABLE.setAutoResizeMode(2);
        BTDownloadButtons downloadButtons = new BTDownloadButtons(this);
        this.BUTTON_ROW = downloadButtons.getComponent();
    }

    private BTDownload findBTDownload(File saveLocation) {
        if (saveLocation == null) {
            return null;
        }
        try {
            List<BTDownload> downloads = this.getDownloads();
            for (BTDownload dl : downloads) {
                File dlSaveLocation = dl.getSaveLocation();
                if (saveLocation.equals(dlSaveLocation)) {
                    return dl;
                }
                if (!(dl instanceof BittorrentDownload) || !saveLocation.equals(dlSaveLocation = ((BittorrentDownload)dl).getDl().getContentSavePath())) continue;
                return dl;
            }
        }
        catch (Throwable e) {
            LOG.error("Error looking for transfer by save location", e);
        }
        return null;
    }

    public boolean isActiveTorrentDownload(File saveLocation) {
        if (saveLocation == null) {
            return false;
        }
        int active = this.getActiveDownloads() + this.getActiveUploads();
        if (active == 0) {
            return false;
        }
        BTDownload btDownload = this.findBTDownload(saveLocation);
        return BTDownloadMediator.isActive(btDownload);
    }

    @Override
    public void onFilterUpdate(TransfersTab.FilterMode mode, String searchKeywords) {
        this.transfersFilter.update(mode, searchKeywords);
        this.updateTableFilters();
    }

    @Override
    public void onFilterUpdate(String searchKeywords) {
        this.transfersFilter.update(searchKeywords);
        this.updateTableFilters();
    }

    public void setBTDownloadSelectionListener(BTDownloadSelectionListener transferSelectionListener) {
        this.transferTabSelectionListener = transferSelectionListener;
    }

    void updateTableFilters() {
        if (this.TABLE == null || this.DATA_MODEL == null) {
            return;
        }
        BTDownload[] selectedDownloaders = this.getSelectedDownloaders();
        ((BTDownloadRowFilteredModel)this.DATA_MODEL).filtersChanged();
        if (selectedDownloaders.length == 1) {
            List<BTDownload> downloads = this.getDownloads();
            for (BTDownload d : downloads) {
                if (selectedDownloaders[0] != d) continue;
                this.selectBTDownload(d);
                this.ensureDownloadVisible(d);
                return;
            }
        }
    }

    @Override
    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Download Window..."));
    }

    @Override
    public void doRefresh() {
        BTDownload dl;
        BTDownloadDataLine dataLine;
        int[] selRows;
        if (this.DATA_MODEL == null) {
            return;
        }
        ((BTDownloadRowFilteredModel)this.DATA_MODEL).refresh();
        if (this.TABLE != null && (selRows = this.TABLE.getSelectedRows()).length > 0 && (dataLine = (BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(selRows[0])) != null && (dl = (BTDownload)dataLine.getInitializeObject()) != null) {
            boolean completed = dl.isCompleted();
            this.retryAction.setEnabled(dl.getState() == TransferState.ERROR_NOT_ENOUGH_PEERS);
            this.resumeAction.setEnabled(dl.isResumable());
            this.pauseAction.setEnabled(dl.isPausable());
            this.exploreAction.setEnabled(completed);
            this.showInLibraryAction.setEnabled(completed);
        }
        int n = ((BTDownloadRowFilteredModel)this.DATA_MODEL).getRowCount();
        boolean anyClearable = false;
        for (int i2 = n - 1; i2 >= 0; --i2) {
            BTDownload initializeObject;
            BTDownloadDataLine btDownloadDataLine = (BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(i2);
            if (btDownloadDataLine == null || (initializeObject = (BTDownload)btDownloadDataLine.getInitializeObject()) == null || !this.isClearable(initializeObject)) continue;
            anyClearable = true;
            break;
        }
        this.clearInactiveAction.setEnabled(anyClearable);
    }

    public int getActiveDownloads() {
        return ((BTDownloadRowFilteredModel)this.DATA_MODEL).getActiveDownloads();
    }

    public int getActiveUploads() {
        return ((BTDownloadRowFilteredModel)this.DATA_MODEL).getActiveUploads();
    }

    public int getTotalDownloads() {
        return ((BTDownloadRowFilteredModel)this.DATA_MODEL).getTotalDownloads();
    }

    private double getBandwidth(boolean download) {
        double totalBandwidth;
        BTEngine engine = BTEngine.getInstance();
        double d = totalBandwidth = download ? (double)engine.downloadRate() : (double)engine.uploadRate();
        if (download) {
            double httpBandwidth = 0.0;
            for (BTDownload btDownload : this.getDownloads()) {
                if (!(btDownload instanceof HttpDownload) && !(btDownload instanceof SoundcloudDownload)) continue;
                httpBandwidth += btDownload.getDownloadSpeed();
            }
            totalBandwidth += (httpBandwidth *= 1000.0);
        }
        return totalBandwidth;
    }

    public double getDownloadsBandwidth() {
        return this.getBandwidth(true) / 1000.0;
    }

    public double getUploadsBandwidth() {
        return this.getBandwidth(false) / 1000.0;
    }

    @Override
    public void add(BTDownload downloader) {
        if (!((BTDownloadRowFilteredModel)this.DATA_MODEL).contains(downloader)) {
            int row;
            super.add(downloader, ((BTDownloadRowFilteredModel)this.DATA_MODEL).getRowCount());
            if (((BTDownloadRowFilteredModel)this.DATA_MODEL).getRowCount() > 0 && (row = ((BTDownloadRowFilteredModel)this.DATA_MODEL).getRow(downloader)) != -1) {
                this.TABLE.setSelectedRow(row);
                this.TABLE.ensureSelectionVisible();
            }
        }
    }

    @Override
    public void remove(BTDownload downloader) {
        super.remove(downloader);
        downloader.remove();
    }

    BTDownload[] getSelectedBTDownloads() {
        int[] sel = this.TABLE.getSelectedRows();
        ArrayList<BTDownload> btdownloadList = new ArrayList<BTDownload>(sel.length);
        for (int aSel : sel) {
            BTDownloadDataLine btDownloadDataLine = (BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(aSel);
            if (!((BTDownload)btDownloadDataLine.getInitializeObject()).isCompleted()) continue;
            btdownloadList.add((BTDownload)btDownloadDataLine.getInitializeObject());
        }
        return btdownloadList.toArray(new BTDownload[0]);
    }

    @Override
    public void handleActionKey() {
        BTDownload[] selectedDownloaders = this.getSelectedDownloaders();
        if (selectedDownloaders.length == 1) {
            this.playSingleMediaFileAction.setEnabled(this.selectionHasMediaFiles(selectedDownloaders[0]));
        }
        if (this.playSingleMediaFileAction.isEnabled()) {
            this.playSingleMediaFileAction.actionPerformed(null);
        }
        if (this.showInLibraryAction.isEnabled()) {
            this.showInLibraryAction.actionPerformed(null);
        }
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        SkinPopupMenu menu = new SkinPopupMenu();
        if (this.playSingleMediaFileAction.isEnabled()) {
            menu.add(new SkinMenuItem(this.playSingleMediaFileAction));
        }
        menu.add(new SkinMenuItem(this.resumeAction));
        menu.add(new SkinMenuItem(this.pauseAction));
        menu.add(new SkinMenuItem(this.retryAction));
        ((JPopupMenu)menu).addSeparator();
        menu.add(new SkinMenuItem(this.showInLibraryAction));
        menu.add(new SkinMenuItem(this.exploreAction));
        ((JPopupMenu)menu).addSeparator();
        menu.add(new SkinMenuItem(this.shareTorrentAction));
        if (OSUtils.isMacOSX() || OSUtils.isWindows()) {
            menu.add(new SkinMenuItem(this.sendToItunesAction));
        }
        menu.add(new SkinMenuItem(this.copyMagnetAction));
        menu.add(new SkinMenuItem(this.copyHashAction));
        ((JPopupMenu)menu).addSeparator();
        menu.add(new SkinMenuItem(this.removeAction));
        menu.add(new SkinMenuItem(BTDownloadActions.REMOVE_TORRENT_ACTION));
        menu.add(new SkinMenuItem(BTDownloadActions.REMOVE_TORRENT_AND_DATA_ACTION));
        menu.add(new SkinMenuItem(this.removeYouTubeAction));
        SkinMenu advancedMenu = BTDownloadMediatorAdvancedMenuFactory.createAdvancedSubMenu();
        if (advancedMenu != null) {
            ((JPopupMenu)menu).addSeparator();
            menu.add(advancedMenu);
        }
        return menu;
    }

    private boolean selectionHasMP4s(File saveLocation) {
        return saveLocation != null && (LibraryUtils.directoryContainsExtension(saveLocation, "mp4") || saveLocation.isFile() && FileUtils.hasExtension(saveLocation.getAbsolutePath(), "mp4"));
    }

    private boolean selectionIsSingleFile(File saveLocation) {
        return saveLocation != null && saveLocation.isFile();
    }

    private boolean selectionHasMediaFiles(BTDownload d) {
        if (d instanceof SoundcloudDownload) {
            return true;
        }
        File saveLocation = d.getSaveLocation();
        if (saveLocation != null && saveLocation.isDirectory() && LibraryUtils.directoryContainsASinglePlayableFile(saveLocation)) {
            try {
                saveLocation = saveLocation.listFiles()[0];
            }
            catch (Throwable t) {
                saveLocation = null;
            }
        }
        return saveLocation != null && (LibraryUtils.directoryContainsPlayableExtensions(saveLocation) || saveLocation.isFile() && MediaPlayer.isPlayableFile(saveLocation));
    }

    private boolean isHttpTransfer(BTDownload d) {
        return d instanceof SoundcloudDownload || d instanceof HttpDownload;
    }

    @Override
    public void handleNoSelection() {
        this.removeAction.setEnabled(false);
        this.resumeAction.setEnabled(false);
        this.retryAction.setEnabled(false);
        this.clearInactiveAction.setEnabled(false);
        this.pauseAction.setEnabled(false);
        this.exploreAction.setEnabled(false);
        this.showInLibraryAction.setEnabled(false);
        this.copyMagnetAction.setEnabled(false);
        this.copyHashAction.setEnabled(false);
        this.shareTorrentAction.setEnabled(false);
        this.sendToItunesAction.setEnabled(false);
        this.playSingleMediaFileAction.setEnabled(false);
        BTDownloadActions.REMOVE_TORRENT_ACTION.setEnabled(false);
        BTDownloadActions.REMOVE_TORRENT_AND_DATA_ACTION.setEnabled(false);
        this.removeYouTubeAction.setEnabled(false);
        this.notifyTransferTabSelectionListener(null);
    }

    @Override
    public void handleSelection(int row) {
        BTDownloadDataLine dataLine = (BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(row);
        BTDownload dl = (BTDownload)dataLine.getInitializeObject();
        boolean pausable = dl.isPausable();
        boolean resumable = dl.isResumable();
        boolean isTransferFinished = dl.isCompleted();
        File saveLocation = dl.getSaveLocation();
        boolean hasMediaFiles = this.selectionHasMediaFiles((BTDownload)dataLine.getInitializeObject());
        boolean hasMP4s = this.selectionHasMP4s(saveLocation);
        boolean isSingleFile = this.selectionIsSingleFile(saveLocation);
        this.removeAction.putValue("Name", I18n.tr("Cancel Download"));
        this.removeAction.putValue("LimeShortName", I18n.tr("Cancel"));
        this.removeAction.putValue("ShortDescription", I18n.tr("Cancel Selected Downloads"));
        this.exploreAction.setEnabled(dl.isCompleted());
        this.showInLibraryAction.setEnabled(dl.isCompleted());
        this.removeAction.setEnabled(true);
        this.resumeAction.setEnabled(resumable);
        this.retryAction.setEnabled(dl.getState() == TransferState.ERROR_NOT_ENOUGH_PEERS);
        this.pauseAction.setEnabled(pausable);
        this.copyMagnetAction.setEnabled(!this.isHttpTransfer(dl));
        this.copyHashAction.setEnabled(!this.isHttpTransfer(dl));
        this.sendToItunesAction.setEnabled(isTransferFinished && (hasMediaFiles || hasMP4s));
        this.shareTorrentAction.setEnabled(this.getSelectedDownloaders().length == 1 && dl.isPausable());
        this.playSingleMediaFileAction.setEnabled(this.getSelectedDownloaders().length == 1 && hasMediaFiles && isSingleFile);
        this.removeYouTubeAction.setEnabled(this.isHttpTransfer(dl));
        BTDownloadActions.REMOVE_TORRENT_ACTION.setEnabled(!this.isHttpTransfer(dl));
        BTDownloadActions.REMOVE_TORRENT_AND_DATA_ACTION.setEnabled(!this.isHttpTransfer(dl));
        if (GUIMediator.Tabs.TRANSFERS.equals((Object)GUIMediator.instance().getSelectedTab())) {
            this.notifyTransferTabSelectionListener(dl);
        }
    }

    private void notifyTransferTabSelectionListener(BTDownload selected) {
        if (this.transferTabSelectionListener != null) {
            try {
                this.transferTabSelectionListener.onTransferSelected(selected);
            }
            catch (Throwable t) {
                LOG.warn("notifyTransferTabSelectionListener() failed: ", t);
            }
        }
    }

    public void openTorrentURI(String uri, boolean partialDownload) {
        SwingUtilities.invokeLater(() -> {
            TorrentFetcherDownload downloader = new TorrentFetcherDownload(uri, partialDownload);
            this.add(downloader);
        });
    }

    public void openTorrentFileForSeed(File torrentFile, File saveDir) {
        if (VPNDropGuard.canUseBitTorrent()) {
            GUIMediator.safeInvokeLater(() -> {
                block2: {
                    try {
                        BTEngine.getInstance().download(torrentFile, saveDir, null);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        if (e.toString().contains("No files selected by user")) break block2;
                        GUIMediator.showError(I18n.tr("FrostWire was unable to load the torrent file \"{0}\", - it may be malformed or FrostWire does not have permission to access this file.", torrentFile.getName()), QuestionsHandler.TORRENT_OPEN_FAILURE);
                    }
                }
            });
        }
    }

    @Override
    protected void setDefaultRenderers() {
        super.setDefaultRenderers();
        this.TABLE.setDefaultRenderer(PaymentOptions.class, new PaymentOptionsRenderer());
        this.TABLE.setDefaultRenderer(TransferHolder.class, new TransferActionsRenderer());
        this.TABLE.setDefaultRenderer(SeedingHolder.class, new TransferSeedingRenderer());
        this.TABLE.setDefaultRenderer(TransferDetailFiles.TransferItemHolder.class, new TransferDetailFilesActionsRenderer());
    }

    @Override
    protected void setDefaultEditors() {
        BTDownloadDataLine.PAYMENT_OPTIONS_COLUMN.setCellEditor(new GenericCellEditor(this.getPaymentOptionsRenderer()));
        BTDownloadDataLine.ACTIONS_COLUMN.setCellEditor(new GenericCellEditor(this.getTransferActionsRenderer()));
        BTDownloadDataLine.SEEDING_COLUMN.setCellEditor(new GenericCellEditor(this.getSeedingRenderer()));
    }

    public void openTorrentFile(File torrentFile, boolean partialDownload, Runnable onOpenRunnableForUIThread) {
        if (VPNDropGuard.canUseBitTorrent()) {
            SwingUtilities.invokeLater(() -> {
                block8: {
                    try {
                        boolean[] filesSelection = null;
                        if (partialDownload) {
                            PartialFilesDialog dlg = new PartialFilesDialog(GUIMediator.getAppFrame(), torrentFile);
                            dlg.setVisible(true);
                            filesSelection = dlg.getFilesSelection();
                            if (filesSelection == null) {
                                return;
                            }
                        }
                        if (onOpenRunnableForUIThread != null) {
                            onOpenRunnableForUIThread.run();
                        }
                        File saveDir = null;
                        String seedDataFilename = FilenameUtils.removeExtension(torrentFile.getName());
                        File seedDataFile = new File(torrentFile.getParentFile(), seedDataFilename);
                        if (seedDataFile.exists()) {
                            saveDir = torrentFile.getParentFile();
                        }
                        if (saveDir == null) {
                            BTEngine.getInstance().download(torrentFile, null, filesSelection);
                        } else {
                            GUIMediator.instance().openTorrentForSeed(torrentFile, saveDir);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (e.toString().contains("No files selected by user")) break block8;
                        GUIMediator.showError(I18n.tr("FrostWire was unable to load the torrent file \"{0}\", - it may be malformed or FrostWire does not have permission to access this file.", torrentFile.getName()), QuestionsHandler.TORRENT_OPEN_FAILURE);
                    }
                }
            });
        }
    }

    public void openTorrentSearchResult(TorrentSearchResult sr, boolean partialDownload) {
        GUIMediator.safeInvokeLater(() -> {
            TorrentFetcherDownload d;
            if (!partialDownload && sr instanceof TorrentItemSearchResult) {
                String relativePath = ((TorrentItemSearchResult)sr).getFilePath();
                d = new TorrentFetcherDownload(sr.getTorrentUrl(), sr.getReferrerUrl(), sr.getDisplayName(), false, relativePath);
            } else {
                d = new TorrentFetcherDownload(sr.getTorrentUrl(), sr.getReferrerUrl(), sr.getDisplayName(), partialDownload);
            }
            this.add(d);
        });
    }

    BTDownload[] getSelectedDownloaders() {
        int[] sel = this.TABLE.getSelectedRows();
        ArrayList<BTDownload> downloaders = new ArrayList<BTDownload>(sel.length);
        for (int aSel : sel) {
            BTDownloadDataLine line = (BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(aSel);
            BTDownload downloader = (BTDownload)line.getInitializeObject();
            downloaders.add(downloader);
        }
        return downloaders.toArray(new BTDownload[0]);
    }

    public List<BTDownload> getDownloads() {
        int count = this.TABLE.getRowCount();
        ArrayList<BTDownload> downloads = new ArrayList<BTDownload>(count);
        for (int i2 = 0; i2 < count; ++i2) {
            try {
                if (i2 >= ((BTDownloadRowFilteredModel)this.DATA_MODEL).getRowCount()) continue;
                BTDownloadDataLine line = (BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(i2);
                BTDownload downloader = (BTDownload)line.getInitializeObject();
                downloads.add(downloader);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return downloads;
    }

    public long getTotalBytesDownloaded() {
        BTEngine engine = BTEngine.getInstance();
        return engine.totalDownload();
    }

    public long getTotalBytesUploaded() {
        BTEngine engine = BTEngine.getInstance();
        return engine.totalUpload();
    }

    private boolean isClearable(BTDownload initializeObject) {
        TransferState state = initializeObject.getState();
        return state != TransferState.SEEDING && state != TransferState.CHECKING && initializeObject.isCompleted();
    }

    void removeCompleted() {
        int n = ((BTDownloadRowFilteredModel)this.DATA_MODEL).getRowCount();
        for (int i2 = n - 1; i2 >= 0; --i2) {
            BTDownloadDataLine btDownloadDataLine = (BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(i2);
            BTDownload initializeObject = (BTDownload)btDownloadDataLine.getInitializeObject();
            if (!this.isClearable(initializeObject)) continue;
            ((BTDownloadRowFilteredModel)this.DATA_MODEL).remove(i2);
        }
        this.updateTableFilters();
    }

    public void stopCompleted() {
        int n = ((BTDownloadRowFilteredModel)this.DATA_MODEL).getRowCount();
        for (int i2 = n - 1; i2 >= 0; --i2) {
            BTDownloadDataLine btDownloadDataLine = (BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(i2);
            BTDownload initializeObject = (BTDownload)btDownloadDataLine.getInitializeObject();
            if (!initializeObject.isCompleted()) continue;
            initializeObject.pause();
        }
    }

    public boolean isDownloading(String hash) {
        return ((BTDownloadRowFilteredModel)this.DATA_MODEL).isDownloading(hash);
    }

    public void addDownload(com.frostwire.bittorrent.BTDownload dl) {
        try {
            this.add(new BittorrentDownload(dl));
        }
        catch (Throwable e) {
            LOG.error("Error adding bittorrent download", e);
        }
    }

    public void updateDownload(com.frostwire.bittorrent.BTDownload dl) {
        try {
            int count = this.TABLE.getRowCount();
            for (int i2 = 0; i2 < count; ++i2) {
                BittorrentDownload bt;
                BTDownloadDataLine line;
                BTDownload downloader;
                if (i2 >= ((BTDownloadRowFilteredModel)this.DATA_MODEL).getRowCount() || !((downloader = (BTDownload)(line = (BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(i2)).getInitializeObject()) instanceof BittorrentDownload) || !(bt = (BittorrentDownload)downloader).getHash().equals(dl.getInfoHash())) continue;
                ((BittorrentDownload)downloader).updateUI(dl);
                break;
            }
        }
        catch (Throwable e) {
            LOG.error("Error updating bittorrent download", e);
        }
    }

    private void restoreSorting() {
        int sortIndex = BittorrentSettings.BTMEDIATOR_COLUMN_SORT_INDEX.getValue();
        boolean sortOrder = BittorrentSettings.BTMEDIATOR_COLUMN_SORT_ORDER.getValue();
        LimeTableColumn column = BTDownloadDataLine.staticGetColumn(sortIndex);
        if (sortIndex != -1 && column != null && TablesHandlerSettings.getVisibility(column.getId(), column.getDefaultVisibility()).getValue()) {
            ((BTDownloadRowFilteredModel)this.DATA_MODEL).sort(sortIndex);
            if (!sortOrder) {
                ((BTDownloadRowFilteredModel)this.DATA_MODEL).sort(sortIndex);
            }
        } else {
            ((BTDownloadRowFilteredModel)this.DATA_MODEL).sort(BTDownloadDataLine.DATE_CREATED_COLUMN.getModelIndex());
        }
    }

    public void downloadSoundcloudFromTrackUrlOrSearchResult(String trackUrl, SoundcloudSearchResult sr, boolean fromPastedUrl) {
        if (sr != null) {
            BackgroundExecutorService.schedule(() -> {
                System.out.println("BTDownloadMediator.downloadSoundcloudFromTrackUrlOrSearchResult about to get download url");
                String downloadUrl = sr.getDownloadUrl();
                System.out.println("BTDownloadMediator.downloadSoundcloudFromTrackUrlOrSearchResult: " + downloadUrl);
                GUIMediator.safeInvokeLater(() -> {
                    if (this.isDownloading(downloadUrl)) {
                        ((BTDownloadRowFilteredModel)this.DATA_MODEL).remove(downloadUrl);
                        this.doRefresh();
                        return;
                    }
                    SoundcloudDownload downloader = new SoundcloudDownload(sr);
                    this.add(downloader);
                });
            });
        } else if (trackUrl != null) {
            BackgroundExecutorService.schedule(() -> {
                try {
                    String url = trackUrl;
                    if (trackUrl.contains("?in=")) {
                        url = trackUrl.substring(0, trackUrl.indexOf("?in="));
                    }
                    String resolveURL = SoundcloudSearchPerformer.resolveUrl(url);
                    HttpClient client = HttpClientFactory.getInstance(HttpClientFactory.HttpContext.DOWNLOAD);
                    String json = client.get(resolveURL, 10000);
                    LinkedList<SoundcloudSearchResult> results = SoundcloudSearchPerformer.fromJson(json, fromPastedUrl);
                    if (results.isEmpty()) {
                        GUIMediator.safeInvokeLater(() -> GUIMediator.showError(I18n.tr("Sorry, Couldn't find a valid download location at") + "<br><br><a href=\"" + trackUrl + "\">" + trackUrl + "</a>"));
                        return;
                    }
                    for (SoundcloudSearchResult urlSr : results) {
                        this.downloadSoundcloudFromTrackUrlOrSearchResult(trackUrl, urlSr, fromPastedUrl);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public void openSlide(Slide slide) {
        GUIMediator.safeInvokeLater(() -> {
            SlideDownload downloader = new SlideDownload(slide);
            this.add(downloader);
        });
    }

    public void openHttp(String httpUrl, String title, String saveFileAs, double fileSize, final boolean extractAudio) {
        GUIMediator.safeInvokeLater(() -> {
            HttpDownload downloader = new HttpDownload(httpUrl, title, saveFileAs, fileSize, null, false, true){

                @Override
                protected void onComplete() {
                    File savedFile = this.getSaveLocation();
                    if (savedFile.exists()) {
                        if (extractAudio) {
                            File m4a = BTDownloadMediator.this.extractAudio(savedFile);
                            if (m4a != null) {
                                GUIMediator.safeInvokeLater(() -> {
                                    GUIMediator.instance().setWindow(GUIMediator.Tabs.LIBRARY);
                                    LibraryMediator.instance().getLibraryExplorer().selectAudio();
                                    LibraryMediator.instance().getLibraryExplorer().refreshSelection(true);
                                    BackgroundExecutorService.schedule(() -> {
                                        Thread.yield();
                                        GUIMediator.safeInvokeLater(() -> LibraryFilesTableMediator.instance().setSelectedRow(0));
                                    });
                                });
                                if (iTunesSettings.ITUNES_SUPPORT_ENABLED.getValue() && !iTunesMediator.instance().isScanned(m4a) && (OSUtils.isMacOSX() || OSUtils.isWindows())) {
                                    iTunesMediator.instance().scanForSongs(m4a);
                                }
                            }
                        } else if (iTunesSettings.ITUNES_SUPPORT_ENABLED.getValue() && !iTunesMediator.instance().isScanned(savedFile)) {
                            if (OSUtils.isMacOSX() || OSUtils.isWindows()) {
                                iTunesMediator.instance().scanForSongs(savedFile);
                            }
                            GUIMediator.safeInvokeLater(() -> BTDownloadMediator.instance().updateTableFilters());
                        }
                    }
                }
            };
            this.add(downloader);
        });
    }

    private File extractAudio(File videoMp4) {
        File mp4 = videoMp4.getAbsoluteFile();
        File extractedAudio = new File(mp4.getParentFile(), FilenameUtils.getBaseName(mp4.getName()) + ".m4a").getAbsoluteFile();
        Mp4Info inf = Mp4Info.audio(null, null, null, null);
        try {
            Mp4Demuxer.audio(mp4, extractedAudio, inf, null);
        }
        catch (IOException e) {
            LOG.error("BTDownloadMediator.extractAudioAndRemoveOriginalVideo() error extracting audio from mp4 file: " + mp4.getAbsolutePath(), e);
            return null;
        }
        return extractedAudio;
    }

    private class TransfersFilter
    implements TableLineFilter<BTDownloadDataLine> {
        private TransfersTab.FilterMode mode = TransfersTab.FilterMode.ALL;
        private String searchKeywords;

        private TransfersFilter(BTDownloadMediator bTDownloadMediator) {
        }

        @Override
        public boolean allow(BTDownloadDataLine line) {
            if (line == null) {
                return false;
            }
            boolean result = false;
            if (this.mode == TransfersTab.FilterMode.SEEDING) {
                result = line.isSeeding();
            } else if (this.mode == TransfersTab.FilterMode.DOWNLOADING) {
                result = line.isDownloading();
            } else if (this.mode == TransfersTab.FilterMode.FINISHED) {
                result = line.isFinished();
            } else if (this.mode == TransfersTab.FilterMode.ALL) {
                result = true;
            }
            return result && this.matchKeywords(line, this.searchKeywords);
        }

        private boolean matchKeywords(BTDownloadDataLine line, String searchKeywords) {
            if (searchKeywords == null || searchKeywords.equals("") || searchKeywords.trim().equals(TransfersTab.FILTER_TEXT_HINT)) {
                return true;
            }
            String hayStack = line.getDisplayName().toLowerCase();
            String[] tokens = searchKeywords.split("\\s");
            if (tokens.length == 1) {
                return hayStack.contains(tokens[0].toLowerCase());
            }
            for (String needle : tokens) {
                if (hayStack.contains(needle.toLowerCase())) continue;
                return false;
            }
            return true;
        }

        void update(TransfersTab.FilterMode mode, String searchKeywords) {
            this.mode = mode;
            this.searchKeywords = searchKeywords;
        }

        void update(String searchKeywords) {
            this.searchKeywords = searchKeywords;
        }
    }

    public static interface BTDownloadSelectionListener {
        public void onTransferSelected(BTDownload var1);
    }
}

