/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class HideExitDialog
extends JDialog {
    public static final int NONE = 0;
    public static final int HIDE = 1;
    private static final int EXIT = 2;
    private JCheckBox _checkBox;
    private int _result = 0;

    public HideExitDialog(JFrame frame) {
        super((Frame)frame, I18n.tr("Do you want to hide FrostWire?"));
        this.setupUI();
        this.setLocationRelativeTo(frame);
    }

    private void setupUI() {
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        JLabel _label = new JLabel("<html>" + I18n.tr("Closing the FrostWire window will only hide the application") + "<p>" + I18n.tr("This way file transfers may continue in the background.") + "</html>");
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)_label, c);
        this._checkBox = new JCheckBox(I18n.tr("Don't show this again"));
        this._checkBox.setSelected(true);
        c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this._checkBox, c);
        JButton _buttonHide = new JButton(I18n.tr("Hide"));
        _buttonHide.addActionListener(this::buttonHide_actionPerformed);
        c = new GridBagConstraints();
        c.insets = new Insets(4, 430, 8, 4);
        c.fill = 0;
        c.gridwidth = -1;
        c.anchor = 13;
        c.ipadx = 20;
        this.getContentPane().add((Component)_buttonHide, c);
        JButton _buttonExit = new JButton(I18n.tr("Exit"));
        _buttonExit.addActionListener(this::buttonExit_actionPerformed);
        c = new GridBagConstraints();
        c.insets = new Insets(4, 0, 8, 6);
        c.fill = 0;
        c.gridwidth = 0;
        c.anchor = 13;
        c.ipadx = 18;
        this.getContentPane().add((Component)_buttonExit, c);
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.getRootPane().setDefaultButton(_buttonHide);
        GUIUtils.addHideAction((JComponent)this.getContentPane());
    }

    private void buttonHide_actionPerformed(ActionEvent e) {
        this._result = 1;
        if (this._checkBox.isSelected()) {
            ApplicationSettings.MINIMIZE_TO_TRAY.setValue(true);
            ApplicationSettings.SHOW_HIDE_EXIT_DIALOG.setValue(false);
        }
        GUIUtils.getDisposeAction().actionPerformed(e);
    }

    private void buttonExit_actionPerformed(ActionEvent e) {
        this._result = 2;
        if (this._checkBox.isSelected()) {
            ApplicationSettings.MINIMIZE_TO_TRAY.setValue(false);
            ApplicationSettings.SHOW_HIDE_EXIT_DIALOG.setValue(false);
        }
        GUIUtils.getDisposeAction().actionPerformed(e);
    }

    public int getResult() {
        return this._result;
    }
}

