/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;

public class DigestUtils {
    public static boolean checkMD5(File f, String expectedMD5, DigestProgressListener listener) {
        if (DigestUtils.isInvalidMD5(expectedMD5)) {
            return false;
        }
        String md5 = DigestUtils.getMD5(f, listener);
        return DigestUtils.compareMD5(md5, expectedMD5);
    }

    public static boolean compareMD5(String md5a, String md5b) {
        if (DigestUtils.isInvalidMD5(md5a) || DigestUtils.isInvalidMD5(md5b)) {
            return false;
        }
        return md5a.equalsIgnoreCase(md5b);
    }

    private static boolean isInvalidMD5(String md5) {
        if (md5 == null) {
            return true;
        }
        return !md5.matches("^[0-9A-Fa-f]{32}+$");
    }

    public static String getMD5(File f) {
        return DigestUtils.getMD5(f, null);
    }

    private static String getMD5(File f, DigestProgressListener listener) {
        try {
            return DigestUtils.getMD5(new FileInputStream(f), f.length(), listener);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private static String getMD5(InputStream is, long streamLength, DigestProgressListener listener) {
        try {
            int num_read;
            MessageDigest m = MessageDigest.getInstance("MD5");
            byte[] buf = new byte[4096];
            BufferedInputStream in = new BufferedInputStream(is);
            long total_read = 0L;
            boolean stopped = false;
            while (!stopped && (num_read = ((InputStream)in).read(buf)) != -1) {
                total_read += (long)num_read;
                m.update(buf, 0, num_read);
                if (listener == null) continue;
                if (streamLength > 0L) {
                    int progressPercentage = (int)(total_read * 100L / streamLength);
                    try {
                        listener.onProgress(progressPercentage);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!listener.stopDigesting()) continue;
                stopped = true;
            }
            ((InputStream)in).close();
            if (!stopped) {
                StringBuilder result = new StringBuilder(new BigInteger(1, m.digest()).toString(16));
                if (result.length() < 32) {
                    int paddingSize = 32 - result.length();
                    for (int i2 = 0; i2 < paddingSize; ++i2) {
                        result.insert(0, "0");
                    }
                }
                return result.toString();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static interface DigestProgressListener {
        public void onProgress(int var1);

        public boolean stopDigesting();
    }
}

