/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.database.sqlite;

import com.frostwire.content.Context;
import com.frostwire.database.sqlite.SQLiteDatabase;
import com.frostwire.util.Logger;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Objects;

public abstract class SQLiteOpenHelper {
    private static final Logger LOG = Logger.getLogger(SQLiteOpenHelper.class);
    private final SQLiteDatabase db;
    private String folderpath;

    protected SQLiteOpenHelper(Context context, String name, int version, String extraArgs) {
        String dbpath = context.getDatabasePath(name).getAbsolutePath();
        this.db = this.openDatabase(dbpath, name, version, extraArgs);
    }

    private static long folderSize(File directory) {
        long length = 0L;
        for (File file : Objects.requireNonNull(directory.listFiles())) {
            if (file.isFile()) {
                length += file.length();
                continue;
            }
            length += SQLiteOpenHelper.folderSize(file);
        }
        return length;
    }

    public synchronized SQLiteDatabase getWritableDatabase() {
        return this.db;
    }

    public synchronized SQLiteDatabase getReadableDatabase() {
        return this.db;
    }

    protected abstract void onCreate(SQLiteDatabase var1);

    public abstract void onUpgrade(SQLiteDatabase var1, int var2, int var3);

    private SQLiteDatabase openDatabase(String dbpath, String name, int version, String extraArgs) {
        try {
            boolean create;
            StringBuilder sb = new StringBuilder();
            sb.append("jdbc:sqlite:");
            this.folderpath = dbpath + "." + version;
            String fullpath = this.folderpath + File.separator + name;
            sb.append(fullpath);
            if (extraArgs != null) {
                sb.append(";").append(extraArgs);
            }
            boolean dbFolderExists = new File(this.folderpath).exists();
            boolean dbFileExists = new File(fullpath).exists();
            boolean bl = create = !dbFolderExists || !dbFileExists;
            if (create) {
                if (!dbFolderExists && !new File(this.folderpath).mkdirs()) {
                    LOG.error("SQLiteOpenHelper.openDatabase(): Error creating database folder: " + this.folderpath);
                    throw new RuntimeException("SQLiteOpenHelper.openDatabase(): Could not create database folder: " + this.folderpath);
                }
                if (!dbFileExists) {
                    try {
                        new File(fullpath).createNewFile();
                    }
                    catch (Throwable e) {
                        LOG.error("SQLiteOpenHelper.openDatabase(): Error creating database file: " + fullpath, e);
                        throw new RuntimeException("SQLiteOpenHelper.openDatabase(): Could not create database file: " + fullpath, e);
                    }
                }
            }
            Connection connection = DriverManager.getConnection(sb.toString(), "SA", "");
            SQLiteDatabase db = new SQLiteDatabase(fullpath, connection);
            if (create) {
                this.onCreate(db);
            }
            return db;
        }
        catch (Throwable e) {
            LOG.error("SQLiteOpenHelper.openDatabase(): Error opening the database", e);
            throw new RuntimeException(e);
        }
    }

    public long sizeInBytes() {
        File dbFolder;
        if (this.folderpath != null && (dbFolder = new File(this.folderpath)).exists() && dbFolder.isDirectory()) {
            return SQLiteOpenHelper.folderSize(dbFolder);
        }
        return 0L;
    }
}

