/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.concurrent.concurrent;

import com.frostwire.service.ErrorService;

class ManagedThread
extends Thread {
    private static final Thread.UncaughtExceptionHandler HANDLER = new ErrorServiceHandler();

    ManagedThread(Runnable r, String name) {
        super(r, name);
        this.setPriority(5);
        this.setUncaughtExceptionHandler(HANDLER);
    }

    private static class ErrorServiceHandler
    implements Thread.UncaughtExceptionHandler {
        private ErrorServiceHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            ErrorService.error(e, "Uncaught thread error: " + t.getName());
        }
    }
}

