/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.bittorrent;

import com.frostwire.jlibtorrent.PiecesTracker;
import com.frostwire.jlibtorrent.Priority;
import com.frostwire.jlibtorrent.TorrentHandle;
import com.frostwire.transfers.TransferItem;
import java.io.File;

public class BTDownloadItem
implements TransferItem {
    private final TorrentHandle th;
    private final int index;
    private final File file;
    private final String name;
    private final long size;
    private PiecesTracker piecesTracker;

    public BTDownloadItem(TorrentHandle th, int index, String filePath, long fileSize, PiecesTracker piecesTracker) {
        this.th = th;
        this.index = index;
        this.file = new File(th.savePath(), filePath);
        this.name = this.file.getName();
        this.size = fileSize;
        this.piecesTracker = piecesTracker;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public boolean isSkipped() {
        return this.th.filePriority(this.index) == Priority.IGNORE;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getDownloaded() {
        if (!this.th.isValid()) {
            return 0L;
        }
        long[] progress = this.th.fileProgress(TorrentHandle.FileProgressFlags.PIECE_GRANULARITY);
        return progress[this.index];
    }

    @Override
    public int getProgress() {
        if (!this.th.isValid() || this.size == 0L) {
            return 0;
        }
        long downloaded = this.getDownloaded();
        int progress = downloaded == this.size ? 100 : (int)((float)(this.getDownloaded() * 100L) / (float)this.size);
        return progress;
    }

    @Override
    public boolean isComplete() {
        return this.getDownloaded() == this.size;
    }

    public long getSequentialDownloaded() {
        return this.piecesTracker != null ? this.piecesTracker.getSequentialDownloadedBytes(this.index) : 0L;
    }
}

