/*
 * Decompiled with CFR 0.152.
 */
package com.apple.concurrent;

import com.apple.concurrent.LibDispatchMainQueue;
import com.apple.concurrent.LibDispatchNative;
import java.util.concurrent.Executor;

public final class Dispatch {
    private static final Dispatch instance = new Dispatch();
    private Executor nonBlockingMainQueue = null;
    private Executor blockingMainQueue = null;

    private Dispatch() {
    }

    public static Dispatch getInstance() {
        if (!LibDispatchNative.nativeIsDispatchSupported()) {
            return null;
        }
        return instance;
    }

    public synchronized Executor getNonBlockingMainQueueExecutor() {
        if (this.nonBlockingMainQueue != null) {
            return this.nonBlockingMainQueue;
        }
        this.nonBlockingMainQueue = new LibDispatchMainQueue.ASync();
        return this.nonBlockingMainQueue;
    }

    public synchronized Executor getBlockingMainQueueExecutor() {
        if (this.blockingMainQueue != null) {
            return this.blockingMainQueue;
        }
        this.blockingMainQueue = new LibDispatchMainQueue.Sync();
        return this.blockingMainQueue;
    }
}

