/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.jna.macos.cocoa;

import com.sun.jna.Pointer;
import dorkbox.util.ImageUtil;
import dorkbox.util.jna.macos.cocoa.NSData;
import dorkbox.util.jna.macos.cocoa.NSObject;
import dorkbox.util.jna.macos.cocoa.NSString;
import dorkbox.util.jna.macos.foundation.ObjectiveC;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

public class NSImage
extends NSObject {
    private static final Pointer objectClass = ObjectiveC.objc_lookUpClass("NSImage");
    private static final Pointer initWithContentsOfFile = ObjectiveC.sel_getUid("initWithContentsOfFile:");
    private static final Pointer initWithData = ObjectiveC.sel_getUid("initWithData:");

    public NSImage(NSData data) {
        super(ObjectiveC.class_createInstance(objectClass, 0));
        ObjectiveC.objc_msgSend(this, initWithData, new Object[]{data});
    }

    public NSImage(BufferedImage image) throws IOException {
        this(ImageUtil.toBytes(image));
    }

    public NSImage(byte[] imageBytes) {
        this(new NSData(imageBytes));
    }

    public NSImage(File file) {
        super(ObjectiveC.class_createInstance(objectClass, 0));
        ObjectiveC.objc_msgSend(this, initWithContentsOfFile, new Object[]{new NSString(file.getAbsolutePath())});
    }
}

