/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import java.lang.reflect.Method;
import org.slf4j.LoggerFactory;

public class Swt {
    public static final boolean isLoaded;
    public static final boolean isGtk3;
    private static final Object currentDisplay;
    private static final Thread currentDisplayThread;
    private static final Method syncExecMethod;
    private static final Method disposeExecMethod;
    private static final int version;

    public static void dispatch(Runnable runnable) {
        try {
            syncExecMethod.invoke(currentDisplay, runnable);
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(Swt.class).error("Unable to execute JavaFX runLater(). Please create an issue with your OS and Java version so we may further investigate this issue.");
        }
    }

    public static boolean isEventThread() {
        return Thread.currentThread() == currentDisplayThread;
    }

    public static void onShutdown(Runnable runnable) {
        try {
            disposeExecMethod.invoke(currentDisplay, runnable);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(Swt.class).error("Unable to set disposeal method", e);
        }
    }

    public static int getVersion() {
        return version;
    }

    static {
        boolean isSwtLoaded_ = false;
        boolean isSwtGtk3_ = false;
        try {
            ClassLoader ourCL;
            Method m = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            m.setAccessible(true);
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            boolean bl = isSwtLoaded_ = null != m.invoke((Object)cl, "org.eclipse.swt.widgets.Display");
            if (!isSwtLoaded_ && (ourCL = Swt.class.getClassLoader()) != cl) {
                boolean bl2 = isSwtLoaded_ = null != m.invoke((Object)ourCL, "org.eclipse.swt.widgets.Display");
            }
            if (isSwtLoaded_) {
                String swt_gtk3 = System.getProperty("SWT_GTK3");
                boolean bl3 = isSwtGtk3_ = swt_gtk3 != null && !swt_gtk3.equals("0");
                if (!isSwtGtk3_) {
                    String property = System.getProperty("org.eclipse.swt.internal.gtk.version");
                    isSwtGtk3_ = property != null && !property.startsWith("2.");
                }
            }
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(Swt.class).debug("Error detecting if SWT is loaded", e);
        }
        isLoaded = isSwtLoaded_;
        isGtk3 = isSwtGtk3_;
        Object _currentDisplay = null;
        Thread _currentDisplayThread = null;
        Method _syncExecMethod = null;
        Method _disposeExecMethod = null;
        int _version = 0;
        if (isSwtLoaded_) {
            try {
                Class<?> clazz = Class.forName("org.eclipse.swt.SWT");
                Method getVersionMethod = clazz.getMethod("getVersion", new Class[0]);
                _version = (Integer)getVersionMethod.invoke(null, new Object[0]);
                clazz = Class.forName("org.eclipse.swt.widgets.Display");
                Method getCurrentMethod = clazz.getMethod("getCurrent", new Class[0]);
                Method getThreadMethod = clazz.getMethod("getThread", new Class[0]);
                _syncExecMethod = clazz.getDeclaredMethod("syncExec", Runnable.class);
                _disposeExecMethod = clazz.getMethod("disposeExec", Runnable.class);
                _currentDisplay = getCurrentMethod.invoke(null, new Object[0]);
                _currentDisplayThread = (Thread)getThreadMethod.invoke(_currentDisplay, new Object[0]);
            }
            catch (Throwable e) {
                LoggerFactory.getLogger(Swt.class).error("Cannot initialize SWT", e);
            }
        }
        currentDisplay = _currentDisplay;
        currentDisplayThread = _currentDisplayThread;
        syncExecMethod = _syncExecMethod;
        disposeExecMethod = _disposeExecMethod;
        version = _version;
    }
}

