/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.swing;

import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinDef;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.ui.swing.SwingMenu;
import dorkbox.systemTray.ui.swing.TrayPopup;
import dorkbox.util.ImageUtil;
import dorkbox.util.SwingUtil;
import dorkbox.util.jna.windows.HBITMAPWrap;
import dorkbox.util.jna.windows.HICONWrap;
import dorkbox.util.jna.windows.Listener;
import dorkbox.util.jna.windows.Shell32;
import dorkbox.util.jna.windows.User32;
import dorkbox.util.jna.windows.WindowsEventDispatch;
import dorkbox.util.jna.windows.structs.NOTIFYICONDATA;
import java.awt.Point;
import java.io.File;
import javax.swing.ImageIcon;

public class _WindowsNativeTray
extends Tray {
    private final Listener quitListener;
    private final Listener menuListener;
    private final Listener showListener;
    private volatile TrayPopup popupMenu;
    private volatile boolean visible = true;
    private volatile File imageFile;
    private volatile HICONWrap imageIcon;
    private volatile String tooltipText = "";

    public _WindowsNativeTray(SystemTray systemTray) {
        SwingMenu swingMenu = new SwingMenu(null, null){

            @Override
            public void setImage(MenuItem menuItem) {
                _WindowsNativeTray.this.imageFile = menuItem.getImage();
                if (_WindowsNativeTray.this.imageIcon != null) {
                    _WindowsNativeTray.this.imageIcon.close();
                }
                _WindowsNativeTray.this.imageIcon = _WindowsNativeTray.convertImage(_WindowsNativeTray.this.imageFile);
                NOTIFYICONDATA nid = new NOTIFYICONDATA();
                nid.hWnd = WindowsEventDispatch.get();
                if (_WindowsNativeTray.this.imageIcon != null) {
                    nid.setIcon(_WindowsNativeTray.this.imageIcon);
                }
                if (!Shell32.Shell_NotifyIcon(1, nid)) {
                    SystemTray.logger.error("Error setting the image for the tray. {}", (Object)Kernel32Util.getLastErrorMessage());
                }
                _WindowsNativeTray.this.setTooltip_(_WindowsNativeTray.this.tooltipText);
                SwingUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (_WindowsNativeTray.this.popupMenu == null) {
                            TrayPopup popupMenu = (TrayPopup)_native;
                            popupMenu.pack();
                            popupMenu.setFocusable(true);
                            _WindowsNativeTray.this.popupMenu = popupMenu;
                        }
                        _WindowsNativeTray.this.popupMenu.setTitleBarImage(_WindowsNativeTray.this.imageFile);
                    }
                });
            }

            @Override
            public void setEnabled(MenuItem menuItem) {
                boolean enabled = menuItem.getEnabled();
                if (_WindowsNativeTray.this.visible && !enabled) {
                    _WindowsNativeTray.this.hide();
                } else if (!_WindowsNativeTray.this.visible && enabled) {
                    _WindowsNativeTray.this.show();
                }
            }

            @Override
            public void setText(MenuItem menuItem) {
            }

            @Override
            public void setShortcut(MenuItem menuItem) {
            }

            @Override
            public void setTooltip(MenuItem menuItem) {
                String text = menuItem.getTooltip();
                _WindowsNativeTray.this.setTooltip_(text);
            }

            @Override
            public void remove() {
                _WindowsNativeTray.this.hide();
                super.remove();
                User32.User32.PostMessage(WindowsEventDispatch.get(), 18, new WinDef.WPARAM(0L), new WinDef.LPARAM(0L));
            }
        };
        WindowsEventDispatch.start();
        WinDef.HWND hWnd = WindowsEventDispatch.get();
        if (hWnd == null) {
            throw new RuntimeException("The Windows System Tray is not supported! Please write an issue and include your OS type and configuration");
        }
        this.showListener = new Listener(){

            @Override
            public void run(WinDef.HWND hWnd, WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
                _WindowsNativeTray.this.show();
            }
        };
        this.quitListener = new Listener(){

            @Override
            public void run(WinDef.HWND hWnd, WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
                WindowsEventDispatch.stop();
                WindowsEventDispatch.removeListener(_WindowsNativeTray.this.showListener);
                WindowsEventDispatch.removeListener(_WindowsNativeTray.this.quitListener);
                WindowsEventDispatch.removeListener(_WindowsNativeTray.this.menuListener);
            }
        };
        this.menuListener = new Listener(){
            final WinDef.POINT mousePosition = new WinDef.POINT();

            @Override
            public void run(WinDef.HWND hWnd, WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
                int lp = lParam.intValue();
                switch (lp) {
                    case 514: 
                    case 517: {
                        if (_WindowsNativeTray.this.popupMenu == null || !User32.User32.GetCursorPos(this.mousePosition)) break;
                        Point point = new Point(this.mousePosition.x, this.mousePosition.y);
                        _WindowsNativeTray.this.popupMenu.doShow(point, 0);
                        break;
                    }
                }
            }
        };
        WindowsEventDispatch.addListener(WindowsEventDispatch.WM_TASKBARCREATED, this.showListener);
        WindowsEventDispatch.addListener(18, this.quitListener);
        WindowsEventDispatch.addListener(1025, this.menuListener);
        this.show();
        this.bind(swingMenu, null, systemTray);
    }

    private void setTooltip_(String text) {
        if (this.tooltipText != null && this.tooltipText.equals(text)) {
            return;
        }
        this.tooltipText = text;
        NOTIFYICONDATA nid = new NOTIFYICONDATA();
        nid.hWnd = WindowsEventDispatch.get();
        if (text != null) {
            nid.setTooltip(text);
        }
        Shell32.Shell_NotifyIcon(1, nid);
    }

    private void hide() {
        if (this.imageIcon != null) {
            this.imageIcon.close();
            this.imageIcon = null;
        }
        if (this.visible) {
            NOTIFYICONDATA nid = new NOTIFYICONDATA();
            nid.hWnd = WindowsEventDispatch.get();
            if (!Shell32.Shell_NotifyIcon(2, nid)) {
                SystemTray.logger.error("Error hiding tray. {}", (Object)Kernel32Util.getLastErrorMessage());
            }
            this.visible = false;
        }
    }

    private void show() {
        if (this.imageIcon != null) {
            this.imageIcon.close();
        }
        this.imageIcon = _WindowsNativeTray.convertImage(this.imageFile);
        NOTIFYICONDATA nid = new NOTIFYICONDATA();
        nid.hWnd = WindowsEventDispatch.get();
        nid.setTooltip(this.tooltipText);
        nid.setIcon(this.imageIcon);
        nid.setCallback(1025);
        if (!Shell32.Shell_NotifyIcon(0, nid)) {
            SystemTray.logger.error("Error showing tray. {}", (Object)Kernel32Util.getLastErrorMessage());
        }
        this.visible = true;
    }

    private static HICONWrap convertImage(File imageFile) {
        if (imageFile != null) {
            ImageIcon imageIcon = new ImageIcon(imageFile.getAbsolutePath());
            imageIcon = new ImageIcon(imageIcon.getImage());
            HBITMAPWrap hbitmapTrayIcon = new HBITMAPWrap(ImageUtil.getBufferedImage(imageIcon));
            return new HICONWrap(hbitmapTrayIcon);
        }
        return null;
    }

    @Override
    public boolean hasImage() {
        return this.imageFile != null;
    }
}

