/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.osx;

import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.CheckboxPeer;
import dorkbox.systemTray.ui.osx.OsxBaseMenuItem;
import dorkbox.systemTray.ui.osx.OsxClickAction;
import dorkbox.systemTray.ui.osx.OsxMenu;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.util.jna.macos.cocoa.NSString;
import dorkbox.util.jna.macos.cocoa.OsxClickCallback;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class OsxMenuItemCheckbox
extends OsxBaseMenuItem
implements CheckboxPeer,
OsxClickCallback {
    private final OsxClickAction clickAction = new OsxClickAction(this);
    private NSString tooltip;
    private NSString title;
    private NSString keyEquivalent;
    private volatile ActionListener callback;
    private volatile boolean isChecked = false;

    OsxMenuItemCheckbox(OsxMenu parent) {
        super(parent);
        this._native.setTarget(this.clickAction);
        this._native.setAction(OsxClickAction.action);
    }

    @Override
    public void click() {
        ActionListener callback = this.callback;
        if (callback != null) {
            callback.actionPerformed(null);
        }
    }

    @Override
    public void setEnabled(Checkbox menuItem) {
        this._native.setEnabled(menuItem.getEnabled());
    }

    @Override
    public void setText(Checkbox menuItem) {
        String text = menuItem.getText();
        this.title = text == null || text.isEmpty() ? null : new NSString(text);
        this._native.setTitle(this.title);
    }

    @Override
    public void setCallback(final Checkbox menuItem) {
        this.callback = menuItem.getCallback();
        this.callback = this.callback != null ? new ActionListener(){
            final ActionListener cb;
            {
                this.cb = menuItem.getCallback();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                menuItem.setChecked(!OsxMenuItemCheckbox.this.isChecked);
                EventDispatch.runLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            cb.actionPerformed(new ActionEvent(menuItem, 1001, ""));
                        }
                        catch (Throwable throwable) {
                            SystemTray.logger.error("Error calling menu entry {} click event.", (Object)menuItem.getText(), (Object)throwable);
                        }
                    }
                });
            }
        } : new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                menuItem.setChecked(!OsxMenuItemCheckbox.this.isChecked);
            }
        };
    }

    @Override
    public void setShortcut(Checkbox menuItem) {
        char shortcut = menuItem.getShortcut();
        this.keyEquivalent = shortcut != '\u0000' ? new NSString(Character.toString(shortcut).toLowerCase()) : new NSString("");
        this._native.setKeyEquivalent(this.keyEquivalent);
    }

    @Override
    public void setChecked(Checkbox menuItem) {
        boolean checked = menuItem.getChecked();
        if (checked != this.isChecked) {
            this.isChecked = checked;
            if (this.isChecked) {
                this._native.setState(1);
            } else {
                this._native.setState(0);
            }
        }
    }

    @Override
    public void setTooltip(Checkbox menuItem) {
        String tooltip = menuItem.getTooltip();
        this.tooltip = tooltip == null || tooltip.isEmpty() ? null : new NSString(tooltip);
        this._native.setToolTip(this.tooltip);
    }

    @Override
    public void remove() {
        super.remove();
        this.title = null;
        this.tooltip = null;
        this.keyEquivalent = null;
        this.callback = null;
        this._native.setTarget(null);
        this._native.setAction(null);
        this.clickAction.remove();
    }
}

