/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.osx;

import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.EntryPeer;
import dorkbox.systemTray.ui.osx.OsxMenu;
import dorkbox.util.ImageUtil;
import dorkbox.util.jna.macos.cocoa.NSImage;
import dorkbox.util.jna.macos.cocoa.NSInteger;
import dorkbox.util.jna.macos.cocoa.NSMenuItem;
import java.awt.image.BufferedImage;

abstract class OsxBaseMenuItem
implements EntryPeer {
    static final NSImage transparentIcon;
    protected final OsxMenu parent;
    protected final NSMenuItem _native = new NSMenuItem();
    private final NSInteger indentationLevel = new NSInteger(1L);

    OsxBaseMenuItem(OsxMenu parent) {
        this.parent = parent;
        this._native.setIndentationLevel(this.indentationLevel);
        this._native.setImage(transparentIcon);
        parent.addItem(this._native);
    }

    @Override
    public void remove() {
        this._native.setImage(null);
        if (this.parent != null) {
            this.parent.removeItem(this._native);
        }
    }

    static {
        NSImage transparentIcon_;
        try {
            int menuImageSize = SystemTray.get().getMenuImageSize();
            BufferedImage image = ImageUtil.createImageAsBufferedImage(3, menuImageSize, null);
            transparentIcon_ = new NSImage(ImageUtil.toBytes(image));
        }
        catch (Exception e) {
            transparentIcon_ = null;
            SystemTray.logger.error("Error creating transparent image.", e);
        }
        transparentIcon = transparentIcon_;
    }
}

