/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.awt;

import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.CheckboxPeer;
import dorkbox.systemTray.ui.awt.AwtMenu;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.util.SwingUtil;
import java.awt.CheckboxMenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class AwtMenuItemCheckbox
implements CheckboxPeer {
    private final AwtMenu parent;
    private final CheckboxMenuItem _native = new CheckboxMenuItem();
    private volatile ItemListener callback;
    private volatile boolean isChecked = false;

    AwtMenuItemCheckbox(AwtMenu parent) {
        this.parent = parent;
        parent._native.add(this._native);
    }

    @Override
    public void setEnabled(final Checkbox menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenuItemCheckbox.this._native.setEnabled(menuItem.getEnabled());
            }
        });
    }

    @Override
    public void setText(final Checkbox menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenuItemCheckbox.this._native.setLabel(menuItem.getText());
            }
        });
    }

    @Override
    public void setCallback(final Checkbox menuItem) {
        ActionListener callback;
        if (this.callback != null) {
            this._native.removeItemListener(this.callback);
        }
        if ((callback = menuItem.getCallback()) != null) {
            this.callback = new ItemListener(){
                final ActionListener cb;
                {
                    this.cb = menuItem.getCallback();
                }

                @Override
                public void itemStateChanged(ItemEvent e) {
                    menuItem.setChecked(!AwtMenuItemCheckbox.this.isChecked);
                    EventDispatch.runLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                cb.actionPerformed(new ActionEvent(menuItem, 1001, ""));
                            }
                            catch (Throwable throwable) {
                                SystemTray.logger.error("Error calling menu checkbox entry {} click event.", (Object)menuItem.getText(), (Object)throwable);
                            }
                        }
                    });
                }
            };
            this._native.addItemListener(this.callback);
        }
    }

    @Override
    public void setShortcut(Checkbox menuItem) {
        final int vKey = SwingUtil.getVirtualKey(menuItem.getShortcut());
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenuItemCheckbox.this._native.setShortcut(new MenuShortcut(vKey));
            }
        });
    }

    @Override
    public void setTooltip(Checkbox menuItem) {
    }

    @Override
    public void setChecked(Checkbox menuItem) {
        boolean checked = menuItem.getChecked();
        if (checked != this.isChecked) {
            this.isChecked = checked;
            SwingUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AwtMenuItemCheckbox.this._native.setState(AwtMenuItemCheckbox.this.isChecked);
                }
            });
        }
    }

    @Override
    public void remove() {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenuItemCheckbox.this._native.deleteShortcut();
                AwtMenuItemCheckbox.this._native.setEnabled(false);
                if (AwtMenuItemCheckbox.this.callback != null) {
                    AwtMenuItemCheckbox.this._native.removeItemListener(AwtMenuItemCheckbox.this.callback);
                    AwtMenuItemCheckbox.this.callback = null;
                }
                ((AwtMenuItemCheckbox)AwtMenuItemCheckbox.this).parent._native.remove(AwtMenuItemCheckbox.this._native);
                AwtMenuItemCheckbox.this._native.removeNotify();
            }
        });
    }
}

