/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.systray;

import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.systray.TrayDelegate;
import com.biglybt.ui.swt.systray.TrayDork;
import com.biglybt.ui.swt.systray.TrayItemDelegate;
import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Separator;
import dorkbox.systemTray.SystemTray;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TrayItemDork
implements TrayItemDelegate {
    SystemTray systemTray;
    private boolean visible = true;

    public TrayItemDork(TrayDelegate tray) {
        this.systemTray = ((TrayDork)tray).getSystemTray();
    }

    public void setImage(String key, File file) {
        if (this.isDisposed()) {
            return;
        }
        if (file == null || !file.exists() || file.getName().endsWith(".svg")) {
            InputStream imageStream = ImageLoader.getInstance().getImageStream(key);
            this.systemTray.setImage(imageStream);
        } else {
            this.systemTray.setImage(file);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean b) {
        this.visible = b;
        this.systemTray.setEnabled(b);
    }

    public void addListener(int id, Listener listener) {
        if (id == 13) {
            // empty if block
        }
    }

    public boolean isDisposed() {
        return this.systemTray == null;
    }

    public void dispose() {
        this.systemTray.shutdown();
        this.systemTray = null;
    }

    public void setToolTipText(String s) {
        this.systemTray.setTooltip(s);
    }

    public void setMenu(org.eclipse.swt.widgets.Menu menu, MenuBuildUtils.MenuBuilder menuBuilder) {
        Event event = new Event();
        event.type = 22;
        event.widget = menu;
        Object[] existingItems = menu.getItems();
        Utils.disposeSWTObjects((Object[])existingItems);
        menuBuilder.buildMenu(menu, new MenuEvent(event));
        try {
            org.eclipse.swt.widgets.MenuItem[] items;
            Menu trayMenu = this.systemTray.getMenu();
            if (trayMenu == null) {
                System.err.println("No trayMenu");
                return;
            }
            trayMenu.removeAllEntries();
            for (org.eclipse.swt.widgets.MenuItem item : items = menu.getItems()) {
                try {
                    this.addMenuItem(trayMenu, item);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void addMenuItem(Menu menuToAddTo, org.eclipse.swt.widgets.MenuItem item) {
        int style = item.getStyle();
        String text = item.getText().replaceAll("&", "");
        if (style == 2) {
            menuToAddTo.add(new Separator());
        } else if (style == 64) {
            Menu newMenu = new Menu(text);
            menuToAddTo.add(newMenu);
            org.eclipse.swt.widgets.Menu subMenu = item.getMenu();
            if (subMenu != null) {
                org.eclipse.swt.widgets.MenuItem[] items;
                subMenu.notifyListeners(22, null);
                for (org.eclipse.swt.widgets.MenuItem subItem : items = subMenu.getItems()) {
                    this.addMenuItem(newMenu, subItem);
                }
            }
        } else if ((item.getStyle() & 0x20) > 0) {
            Checkbox cb = new Checkbox(text);
            cb.setEnabled(item.getEnabled());
            cb.setChecked(item.getSelection());
            ActionListener actionListener = e -> item.getDisplay().asyncExec(() -> {
                Listener[] listeners;
                Event event = new Event();
                event.type = 13;
                event.widget = item;
                for (Listener l : listeners = item.getListeners(13)) {
                    l.handleEvent(event);
                }
            });
            cb.setCallback(actionListener);
            cb.setShortcut(item.getAccelerator());
            menuToAddTo.add(cb);
        } else {
            ActionListener actionListener = e -> item.getDisplay().asyncExec(() -> {
                Listener[] listeners;
                Event event = new Event();
                event.type = 13;
                event.widget = item;
                for (Listener l : listeners = item.getListeners(13)) {
                    l.handleEvent(event);
                }
            });
            MenuItem dorkItem = new MenuItem(text, actionListener);
            dorkItem.setEnabled(item.isEnabled());
            dorkItem.setShortcut(item.getAccelerator());
            menuToAddTo.add(dorkItem);
        }
    }
}

