/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.update;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.pif.PluginInterface;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

public class UpdaterUtils {
    public static String AZUPDATER_PLUGIN_ID = "azupdater";
    public static String AZUPDATERPATCHER_PLUGIN_ID = "azupdaterpatcher";
    protected static String AZUPNPAV_PLUGIN_ID = "azupnpav";

    public static boolean disableNativeCode(String version) {
        File plugin_dir;
        block4: {
            try {
                plugin_dir = null;
                File shared_plugin_dir = FileUtil.getApplicationFile("plugins");
                File shared_updater_plugin = new File(shared_plugin_dir, AZUPDATER_PLUGIN_ID);
                if (shared_updater_plugin.exists()) {
                    plugin_dir = shared_updater_plugin;
                }
                if (plugin_dir != null) break block4;
                return false;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }
        return new File(plugin_dir, "disnat" + version).exists();
    }

    public static void checkBootstrapPlugins() {
        try {
            File target_props = UpdaterUtils.getPropsIfNotPresent(AZUPDATER_PLUGIN_ID, true);
            if (target_props != null) {
                UpdaterUtils.writePluginProperties(target_props, new String[]{"plugin.class=com.biglybt.update.UpdaterUpdateChecker;com.biglybt.update.UpdaterPatcher", "plugin.name=BiglyBT Update Support;BiglyBT Updater Support Patcher"});
            }
            if ((target_props = UpdaterUtils.getPropsIfNotPresent(AZUPNPAV_PLUGIN_ID, false)) != null) {
                UpdaterUtils.writePluginProperties(target_props, new String[]{"plugin.class=com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaServer", "plugin.name=UPnP Media Server", "plugin.id=azupnpav"});
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected static void writePluginProperties(File target, String[] lines) {
        try {
            try (PrintWriter pw = null;){
                target.getParentFile().mkdirs();
                pw = new PrintWriter(new FileWriter(target));
                int i = 0;
                while (i < lines.length) {
                    pw.println(lines[i]);
                    ++i;
                }
                pw.println("plugin.install_if_missing=yes");
            }
            if (!target.exists()) {
                throw new Exception("Failed to write '" + target.toString() + "'");
            }
        }
        catch (Throwable e) {
            Logger.log(new LogAlert(false, "Plugin bootstrap: initialisation error for " + target, e));
        }
    }

    protected static File getPropsIfNotPresent(String id, boolean use_shared) {
        File user_plugin_dir = FileUtil.getUserFile("plugins");
        File user_plugin = new File(user_plugin_dir, id);
        File user_props = new File(user_plugin, "plugin.properties");
        if (user_props.exists()) {
            return null;
        }
        File shared_plugin_dir = FileUtil.getApplicationFile("plugins");
        File shared_plugin = new File(shared_plugin_dir, id);
        File shared_props = new File(shared_plugin, "plugin.properties");
        if (shared_props.exists()) {
            return null;
        }
        if (use_shared) {
            FileUtil.mkdirs(shared_plugin);
            return shared_props;
        }
        FileUtil.mkdirs(user_plugin);
        return user_props;
    }

    public static String getUpdaterPluginVersion() {
        try {
            String version;
            PluginInterface pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID(AZUPDATER_PLUGIN_ID, false);
            if (pi != null && (version = pi.getPluginVersion()) != null) {
                return version;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "0";
    }
}

