/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.update;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AETemporaryFileHandler;
import com.biglybt.core.util.AEVerifier;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.versioncheck.VersionCheckClient;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.update.UpdatableComponent;
import com.biglybt.pif.update.Update;
import com.biglybt.pif.update.UpdateCheckInstance;
import com.biglybt.pif.update.UpdateChecker;
import com.biglybt.pif.update.UpdateInstaller;
import com.biglybt.pif.utils.StaticUtilities;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderAdapter;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderException;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderFactory;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderListener;
import com.biglybt.platform.win32.access.AEWin32Access;
import com.biglybt.platform.win32.access.AEWin32Manager;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class CoreUpdateChecker
implements Plugin,
UpdatableComponent {
    public static final String LATEST_VERSION_PROPERTY = "latest_version";
    public static final String MESSAGE_PROPERTY = "message";
    public static final int RD_GET_DETAILS_RETRIES = 3;
    public static final int RD_GET_MIRRORS_RETRIES = 3;
    public static final int RD_SIZE_RETRIES = 3;
    public static final int RD_SIZE_TIMEOUT = 10000;
    public static final String RES_EXPLICIT_FILE = "CoreUpdateChecker.explicit";
    protected static volatile CoreUpdateChecker singleton;
    protected PluginInterface plugin_interface;
    protected ResourceDownloaderFactory rdf;
    protected LoggerChannel log;
    protected ResourceDownloaderListener rd_logger;
    protected boolean first_check = true;

    public static CoreUpdateChecker getSingleton() {
        return singleton;
    }

    public static void doUsageStats() {
        singleton.doUsageStatsSupport();
    }

    public CoreUpdateChecker() {
        singleton = this;
    }

    protected void doUsageStatsSupport() {
        try {
            Map decoded = VersionCheckClient.getSingleton().getVersionCheckInfo(this.first_check ? "us" : "up");
            this.displayUserMessage(decoded);
        }
        finally {
            this.first_check = false;
        }
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Core Updater");
        this.log = this.plugin_interface.getLogger().getChannel("CoreUpdater");
        this.log.setDiagnostic();
        this.log.setForce(true);
        this.rd_logger = new ResourceDownloaderAdapter(){

            @Override
            public void reportActivity(ResourceDownloader downloader, String activity) {
                CoreUpdateChecker.this.log.log(activity);
            }
        };
        Properties props = this.plugin_interface.getPluginProperties();
        props.setProperty("plugin.version", this.plugin_interface.getApplicationVersion());
        this.rdf = this.plugin_interface.getUtilities().getResourceDownloaderFactory();
        this.plugin_interface.getUpdateManager().registerUpdatableComponent(this, true);
    }

    @Override
    public String getName() {
        return "BiglyBT Core";
    }

    @Override
    public int getMaximumCheckTime() {
        return 30;
    }

    @Override
    public void checkForUpdate(final UpdateChecker checker) {
        block31: {
            try {
                URL full_download_url;
                String update_name = "Core BiglyBT Version";
                UpdateCheckInstance check_inst = checker.getCheckInstance();
                Map overrides = (Map)check_inst.getProperty(7);
                if (overrides != null && overrides.containsKey(RES_EXPLICIT_FILE)) {
                    final File file = (File)overrides.get(RES_EXPLICIT_FILE);
                    ResourceDownloader rd = this.rdf.create(file);
                    String current_version = this.plugin_interface.getApplicationVersion();
                    final String latest_version = "explicit";
                    final Update update = checker.addUpdate(update_name, new String[]{"Explicit update"}, current_version, latest_version, rd, 2);
                    rd.addListener(new ResourceDownloaderAdapter(){

                        @Override
                        public boolean completed(ResourceDownloader downloader, InputStream data) {
                            CoreUpdateChecker.this.installUpdate(checker, update, downloader, file.getName(), latest_version, data);
                            return true;
                        }

                        @Override
                        public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
                            update.complete(false);
                        }
                    });
                    break block31;
                }
                String current_version = this.plugin_interface.getApplicationVersion();
                this.log.log("Update check starts: current = " + current_version);
                VersionCheckClient vc = VersionCheckClient.getSingleton();
                Map decoded = vc.getVersionCheckInfo(this.first_check ? "us" : "up");
                this.displayUserMessage(decoded);
                Throwable error = vc.getError();
                if (error != null) {
                    throw error;
                }
                if (decoded.isEmpty()) {
                    return;
                }
                byte[] b_version = (byte[])decoded.get("version");
                if (b_version == null) {
                    throw new Exception("No version found in reply");
                }
                String latest_version = new String(b_version);
                this.plugin_interface.getPluginProperties().setProperty(LATEST_VERSION_PROPERTY, latest_version);
                byte[] b_filename = (byte[])decoded.get("filename");
                if (b_filename == null) {
                    throw new Exception("No update file details in reply");
                }
                String latest_file_name = new String(b_filename);
                String msg = "Core: latest_version = '" + latest_version + "', file = '" + latest_file_name + "'";
                if (latest_file_name.startsWith("http")) {
                    try {
                        full_download_url = new URL(latest_file_name);
                    }
                    catch (Throwable e) {
                        full_download_url = null;
                        this.log.log(e);
                    }
                    int pos = latest_file_name.lastIndexOf(47);
                    latest_file_name = latest_file_name.substring(pos + 1);
                } else {
                    full_download_url = null;
                }
                checker.reportProgress(msg);
                this.log.log(msg);
                if (!CoreUpdateChecker.shouldUpdate(current_version, latest_version)) {
                    return;
                }
                try {
                    final String f_latest_version = latest_version;
                    final String f_latest_file_name = latest_file_name;
                    if (full_download_url == null) {
                        throw new Exception("No download URL available");
                    }
                    ResourceDownloader full_rd = this.rdf.create(full_download_url);
                    ResourceDownloader full_ap_rd = this.rdf.createWithAutoPluginProxy(full_download_url);
                    full_rd = this.rdf.getSuffixBasedDownloader(full_rd);
                    ResourceDownloader top_downloader = this.rdf.getAlternateDownloader(new ResourceDownloader[]{full_rd, full_ap_rd});
                    top_downloader.addListener(this.rd_logger);
                    top_downloader.getSize();
                    byte[] info_b = (byte[])decoded.get("info");
                    String info = null;
                    if (info_b != null) {
                        try {
                            info = new String(info_b, "UTF-8");
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    byte[] info_url_bytes = (byte[])decoded.get("info_url");
                    String info_url = null;
                    if (info_url_bytes != null) {
                        try {
                            info_url = new String(info_url_bytes);
                        }
                        catch (Exception e) {
                            Debug.out(e);
                        }
                    }
                    if (info != null || info_url != null) {
                        String check = info == null ? info_url : (info_url == null ? info : String.valueOf(info) + "|" + info_url);
                        byte[] sig = (byte[])decoded.get("info_sig");
                        boolean ok = false;
                        if (sig == null) {
                            Logger.log(new LogEvent(LogIDs.LOGGER, "info signature check failed - missing signature"));
                        } else {
                            try {
                                AEVerifier.verifyData(check, sig);
                                ok = true;
                            }
                            catch (Throwable e) {
                                Logger.log(new LogEvent(LogIDs.LOGGER, "info signature check failed", e));
                            }
                        }
                        if (!ok) {
                            info = null;
                            info_url = null;
                        }
                    }
                    String[] desc = info == null ? new String[]{update_name} : new String[]{update_name, info};
                    final Update update = checker.addUpdate(update_name, desc, current_version, latest_version, top_downloader, 2);
                    if (info_url != null) {
                        update.setDescriptionURL(info_url);
                    }
                    top_downloader.addListener(new ResourceDownloaderAdapter(){

                        @Override
                        public boolean completed(ResourceDownloader downloader, InputStream data) {
                            CoreUpdateChecker.this.installUpdate(checker, update, downloader, f_latest_file_name, f_latest_version, data);
                            return true;
                        }

                        @Override
                        public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
                            update.complete(false);
                        }
                    });
                }
                catch (Throwable e) {
                    this.log.log(e);
                    Debug.printStackTrace(e);
                    checker.reportProgress("Failed to check for core update: " + Debug.getNestedExceptionMessage(e));
                    checker.setFailed(new Exception("Failed to check for core update", e));
                }
            }
            finally {
                checker.completed();
                this.first_check = false;
            }
        }
    }

    private void displayUserMessage(Map reply) {
        try {
            for (String key : reply.keySet()) {
                boolean completed;
                boolean repeatable;
                String last_message_key;
                String message;
                block30: {
                    byte[] message_bytes;
                    if (key.startsWith("message_sig") || !key.startsWith(MESSAGE_PROPERTY) || (message_bytes = (byte[])reply.get(key)) == null || message_bytes.length <= 0) continue;
                    try {
                        message = new String(message_bytes, "UTF-8");
                    }
                    catch (Throwable e) {
                        message = new String(message_bytes);
                    }
                    int pos = key.indexOf(95);
                    String sig_key = pos == -1 ? "message_sig" : "message_sig" + key.substring(pos);
                    last_message_key = "CoreUpdateChecker.last" + key;
                    String last = COConfigurationManager.getStringParameter(last_message_key, "");
                    if (message.equals(last)) continue;
                    repeatable = false;
                    byte[] signature = (byte[])reply.get(sig_key);
                    if (signature == null) {
                        Logger.log(new LogEvent(LogIDs.LOGGER, "Signature missing from message"));
                        return;
                    }
                    try {
                        AEVerifier.verifyData(message, signature);
                    }
                    catch (Throwable e) {
                        Logger.log(new LogEvent(LogIDs.LOGGER, "Message signature check failed", e));
                        return;
                    }
                    completed = false;
                    if (message.startsWith("x:") || message.startsWith("y:")) {
                        repeatable = message.startsWith("y:");
                        try {
                            URL jar_url = new URL(message.substring(2));
                            if (!repeatable) {
                                Logger.log(new LogEvent(LogIDs.LOGGER, "Patch application requsted: url=" + jar_url));
                            }
                            File temp_dir = AETemporaryFileHandler.createTempDir();
                            File jar_file = new File(temp_dir, "patch.jar");
                            InputStream is = this.rdf.create(jar_url).download();
                            try {
                                FileUtil.copyFile(is, jar_file);
                                is = null;
                                AEVerifier.verifyData(jar_file);
                                ClassLoader cl = CoreUpdateChecker.class.getClassLoader();
                                if (cl instanceof URLClassLoader) {
                                    URL[] old = ((URLClassLoader)cl).getURLs();
                                    URL[] new_urls = new URL[old.length + 1];
                                    System.arraycopy(old, 0, new_urls, 1, old.length);
                                    new_urls[0] = jar_file.toURI().toURL();
                                    cl = new URLClassLoader(new_urls, cl);
                                } else {
                                    cl = new URLClassLoader(new URL[]{jar_file.toURI().toURL()}, cl);
                                }
                                Class<?> cla = cl.loadClass("com.biglybt.update.version.Patch");
                                cla.newInstance();
                                completed = true;
                                break block30;
                            }
                            finally {
                                if (is != null) {
                                    is.close();
                                }
                                jar_file.delete();
                                temp_dir.delete();
                            }
                        }
                        catch (Throwable e) {
                            if (!repeatable) {
                                Logger.log(new LogEvent(LogIDs.LOGGER, "Patch application failed", e));
                            }
                            break block30;
                        }
                    }
                    if (message.startsWith("u:") && message.length() > 4) {
                        try {
                            String type = message.substring(2, 3);
                            String url = message.substring(4);
                            UIFunctions uif = UIFunctionsManager.getUIFunctions();
                            if (uif != null) {
                                uif.viewURL(url, null, 0.9, 0.9, true, type.equals("1"));
                            }
                        }
                        catch (Throwable t) {
                            Logger.log(new LogEvent(LogIDs.LOGGER, "URL message failed", t));
                        }
                        completed = true;
                    } else {
                        UIFunctions uif;
                        int alert_type = 1;
                        String alert_text = message;
                        boolean force = false;
                        if (alert_text.startsWith("f:")) {
                            force = true;
                            alert_text = alert_text.substring(2);
                        }
                        if (alert_text.startsWith("i:")) {
                            alert_type = 0;
                            alert_text = alert_text.substring(2);
                        }
                        this.plugin_interface.getPluginProperties().setProperty(MESSAGE_PROPERTY, alert_text);
                        if (force && (uif = UIFunctionsManager.getUIFunctions()) != null) {
                            try {
                                uif.forceNotify(0, null, alert_text, null, null, 0);
                                completed = true;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (!completed) {
                            Logger.log(new LogAlert(false, alert_type, alert_text, 0));
                        }
                        completed = true;
                    }
                }
                if (!completed || repeatable) continue;
                COConfigurationManager.setParameter(last_message_key, message);
                COConfigurationManager.save();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected void installUpdate(UpdateChecker checker, Update update, ResourceDownloader rd, String filename, String version, InputStream data) {
        block14: {
            try {
                try {
                    data = update.verifyData(data, true);
                    rd.reportActivity("Data verified successfully");
                    if (filename.toLowerCase().contains(".zip.torrent")) {
                        this.handleZIPUpdate(checker, data);
                    } else {
                        String temp_jar_name = "BiglyBT_" + version + ".jar";
                        String target_jar_name = "BiglyBT.jar";
                        UpdateInstaller installer = checker.createInstaller();
                        installer.addResource(temp_jar_name, data);
                        installer.addMoveAction(temp_jar_name, new File(installer.getInstallDir(), target_jar_name).getAbsolutePath());
                    }
                    update.complete(true);
                }
                catch (Throwable e) {
                    update.complete(false);
                    rd.reportActivity("Update install failed:" + e.getMessage());
                    if (data == null) break block14;
                    try {
                        data.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            finally {
                if (data != null) {
                    try {
                        data.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    protected void handleZIPUpdate(UpdateChecker checker, InputStream data) throws Exception {
        ZipInputStream zip = null;
        Properties update_properties = new Properties();
        File temp_dir = AETemporaryFileHandler.createTempDir();
        File update_file = null;
        this.log.log("Update is zip based");
        try {
            zip = new ZipInputStream(data);
            ZipEntry entry = null;
            while ((entry = zip.getNextEntry()) != null) {
                String name = entry.getName().trim();
                this.log.log("    entry: " + name);
                if (name.equals("azureus.sig") || name.endsWith("/") || name.length() == 0) continue;
                if (name.equals("update.properties")) {
                    update_properties.load(zip);
                    continue;
                }
                if (update_file != null) {
                    throw new Exception("Multiple update files are not supported");
                }
                update_file = new File(temp_dir, name);
                FileUtil.copyFile((InputStream)zip, update_file, false);
                this.log.log("        extracted to " + update_file);
            }
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (Throwable throwable) {}
            }
        }
        if (update_properties == null) {
            throw new Exception("Update properties missing");
        }
        if (update_file == null) {
            throw new Exception("Update file missing");
        }
        String info_url = update_properties.getProperty("info.url");
        if (info_url == null) {
            throw new Exception("Update property 'info.url' missing");
        }
        String s_args = update_properties.getProperty("launch.args", "").trim();
        final String[] args = s_args.length() > 0 ? GeneralUtils.splitQuotedTokens(s_args) : new String[]{};
        UIFunctions uif = UIFunctionsManager.getUIFunctions();
        if (uif == null) {
            throw new Exception("Update can't proceed - UI functions unavailable");
        }
        checker.getCheckInstance().setProperty(4, true);
        final File f_update_file = update_file;
        boolean silent = update_properties.getProperty("launch.silent", "false").equals("true");
        if (silent) {
            String app_name;
            this.log.log("Update is silent");
            if (!(!Constants.isOSX || (app_name = SystemProperties.getApplicationName()).equals("Vuze") || app_name.equals("Azureus") || app_name.equals("BiglyBT") || app_name.equals("BiglyBT"))) {
                UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                String details = MessageText.getString("update.fail.app.changed", new String[]{app_name});
                ui_manager.showMessageBox("update.fail.app.changed.title", "!" + details + "!", 1L);
                return;
            }
            uif.performAction(2, !FileUtil.canReallyWriteToAppDirectory(), new UIFunctions.actionListener(){

                @Override
                public void actionComplete(Object result) {
                    if (((Boolean)result).booleanValue()) {
                        CoreUpdateChecker.this.launchUpdate(f_update_file, args);
                    }
                }
            });
        } else {
            uif.performAction(1, info_url, new UIFunctions.actionListener(){

                @Override
                public void actionComplete(Object result) {
                    if (((Boolean)result).booleanValue()) {
                        CoreUpdateChecker.this.launchUpdate(f_update_file, args);
                    }
                }
            });
        }
    }

    protected void launchUpdate(File file, String[] args) {
        block30: {
            try {
                Throwable unzip_error;
                File dir;
                block31: {
                    if (file.getName().endsWith(".exe")) {
                        try {
                            AEWin32Access accessor = AEWin32Manager.getAccessor(true);
                            String s_args = null;
                            if (args.length > 0) {
                                s_args = "";
                                String[] stringArray = args;
                                int n = args.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String s = stringArray[n2];
                                    s_args = String.valueOf(s_args) + (s_args.length() == 0 ? "" : " ") + s;
                                    ++n2;
                                }
                            }
                            accessor.shellExecute(null, file.getAbsolutePath(), s_args, SystemProperties.getApplicationPath(), 1);
                        }
                        catch (Throwable e) {
                            Logger.log(new LogEvent(LogIDs.LOGGER, "AEWin32Access failed", e));
                            if (args.length > 0) {
                                String[] s_args = new String[args.length + 1];
                                s_args[0] = file.getAbsolutePath();
                                System.arraycopy(args, 0, s_args, 1, args.length);
                                Runtime.getRuntime().exec(s_args);
                                break block30;
                            }
                            Runtime.getRuntime().exec(new String[]{file.getAbsolutePath()});
                        }
                        break block30;
                    }
                    dir = file.getParentFile();
                    ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
                    unzip_error = null;
                    String chmod_command = CoreUpdateChecker.findCommand("chmod");
                    while (true) {
                        while (true) {
                            String[] to_run;
                            ZipEntry entry;
                            if ((entry = zis.getNextEntry()) == null) {
                                break block31;
                            }
                            if (entry.isDirectory()) continue;
                            String name = entry.getName();
                            FileOutputStream entry_os = null;
                            File entry_file = null;
                            if (!name.endsWith("/")) {
                                entry_file = new File(dir, name.replace('/', File.separatorChar));
                                entry_file.getParentFile().mkdirs();
                                entry_os = new FileOutputStream(entry_file);
                            }
                            try {
                                int len;
                                byte[] buffer = new byte[65536];
                                while ((len = zis.read(buffer)) > 0) {
                                    if (entry_os == null) continue;
                                    entry_os.write(buffer, 0, len);
                                }
                            }
                            catch (Throwable throwable) {
                                if (entry_os != null) {
                                    entry_os.close();
                                    if (name.endsWith(".jnilib") || name.endsWith("JavaApplicationStub")) {
                                        try {
                                            to_run = new String[]{chmod_command, "a+x", entry_file.getAbsolutePath()};
                                            CoreUpdateChecker.runCommand(to_run, true);
                                        }
                                        catch (Throwable e) {
                                            unzip_error = e;
                                        }
                                    }
                                }
                                throw throwable;
                            }
                            if (entry_os == null) continue;
                            entry_os.close();
                            if (!name.endsWith(".jnilib") && !name.endsWith("JavaApplicationStub")) continue;
                            try {
                                to_run = new String[]{chmod_command, "a+x", entry_file.getAbsolutePath()};
                                CoreUpdateChecker.runCommand(to_run, true);
                            }
                            catch (Throwable e) {
                                unzip_error = e;
                            }
                        }
                        break;
                    }
                    finally {
                        zis.close();
                    }
                }
                if (unzip_error != null) {
                    throw unzip_error;
                }
                File[] files = dir.listFiles();
                boolean launched = false;
                File[] fileArray = files;
                int n = files.length;
                int n3 = 0;
                while (n3 < n) {
                    File f = fileArray[n3];
                    if (f.getName().endsWith(".app")) {
                        String[] to_run;
                        if (args.length == 0 || !Constants.isOSX) {
                            to_run = new String[]{"/bin/sh", "-c", "open \"" + f.getAbsolutePath() + "\""};
                        } else {
                            to_run = new String[3 + args.length];
                            to_run[0] = CoreUpdateChecker.findCommand("open");
                            to_run[1] = f.getAbsolutePath();
                            to_run[2] = "--args";
                            System.arraycopy(args, 0, to_run, 3, args.length);
                        }
                        CoreUpdateChecker.runCommand(to_run, false);
                        launched = true;
                    }
                    ++n3;
                }
                if (!launched) {
                    throw new Exception("No .app files found in '" + dir + "'");
                }
            }
            catch (Throwable e) {
                Logger.log(new LogEvent(LogIDs.LOGGER, "Failed to launch update '" + file + "'", e));
            }
        }
    }

    private static String findCommand(String name) {
        String[] locations;
        String[] stringArray = locations = new String[]{"/bin", "/usr/bin"};
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            File f = new File(s, name);
            if (f.exists() && f.canRead()) {
                return f.getAbsolutePath();
            }
            ++n2;
        }
        return name;
    }

    private static void runCommand(String[] command, boolean wait) throws Throwable {
        try {
            String str = "";
            String[] stringArray = command;
            int n = command.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                str = String.valueOf(str) + (str.length() == 0 ? "" : " ") + s;
                ++n2;
            }
            System.out.println("running " + str);
            Process proc = Runtime.getRuntime().exec(command);
            if (wait) {
                proc.waitFor();
            }
        }
        catch (Throwable e) {
            System.err.println(e);
            throw e;
        }
    }

    protected static boolean shouldUpdate(String current_version, String latest_version) {
        String current_base = Constants.getBaseVersion(current_version);
        int current_inc = Constants.getIncrementalBuild(current_version);
        String latest_base = Constants.getBaseVersion(latest_version);
        int latest_inc = Constants.getIncrementalBuild(latest_version);
        int major_comp = Constants.compareVersions(current_base, latest_base);
        if (major_comp < 0 && latest_inc >= 0) {
            return true;
        }
        return major_comp == 0 && current_inc > 0 && latest_inc > 0 && latest_inc > current_inc;
    }

    public static void main(String[] args) {
        String[][] tests = new String[][]{{"2.4.0.0", "2.4.0.2", "true"}, {"2.4.0.1_CVS", "2.4.0.2", "true"}, {"2.4.0.1_B12", "2.4.0.2", "true"}, {"2.4.0.1_B12", "2.4.0.1_B34", "true"}, {"2.4.0.1_B12", "2.4.0.1_B6", "false"}, {"2.4.0.0", "2.4.0.1_CVS", "false"}, {"2.4.0.0", "2.4.0.1_B12", "true"}, {"2.4.0.0", "2.4.0.0", "false"}, {"2.4.0.1_CVS", "2.4.0.1_CVS", "false"}, {"2.4.0.1_B2", "2.4.0.1_B2", "false"}, {"2.4.0.1_CVS", "2.4.0.1_B2", "false"}, {"2.4.0.1_B2", "2.4.0.1_CVS", "false"}};
        int i = 0;
        while (i < tests.length) {
            System.out.println(String.valueOf(CoreUpdateChecker.shouldUpdate(tests[i][0], tests[i][1])) + " / " + tests[i][2]);
            ++i;
        }
    }
}

