/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.update;

import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AETemporaryFileHandler;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.update.UpdatableComponent;
import com.biglybt.pif.update.Update;
import com.biglybt.pif.update.UpdateCheckInstance;
import com.biglybt.pif.update.UpdateCheckInstanceListener;
import com.biglybt.pif.update.UpdateChecker;
import com.biglybt.pif.update.UpdateInstaller;
import com.biglybt.pif.update.UpdateListener;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.update.CorePatchLevel;
import com.biglybt.update.UpdateJarPatcher;
import com.biglybt.update.UpdaterUpdateChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class CorePatchChecker
implements Plugin,
UpdatableComponent,
UpdateCheckInstanceListener {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final boolean TESTING = false;
    protected PluginInterface plugin_interface;
    private Map<UpdateCheckInstance, Update> my_updates = new HashMap<UpdateCheckInstance, Update>(1);

    @Override
    public void initialize(PluginInterface _plugin_interface) throws PluginException {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Core Patcher (level=" + CorePatchLevel.getCurrentPatchLevel() + ")");
        if (!Constants.isCVSVersion()) {
            this.plugin_interface.getUpdateManager().registerUpdatableComponent(this, false);
        }
    }

    @Override
    public String getName() {
        return "Core Patch Checker";
    }

    @Override
    public int getMaximumCheckTime() {
        return 0;
    }

    @Override
    public void checkForUpdate(UpdateChecker checker) {
        try {
            UpdateCheckInstance inst = checker.getCheckInstance();
            inst.addListener(this);
            this.my_updates.put(inst, checker.addUpdate("Core Patch Checker", new String[0], "", "", new ResourceDownloader[0], 3));
        }
        finally {
            checker.completed();
        }
    }

    @Override
    public void cancelled(UpdateCheckInstance instance) {
        Update update = this.my_updates.remove(instance);
        if (update != null) {
            update.cancel();
        }
    }

    @Override
    public void complete(final UpdateCheckInstance instance) {
        Update my_update = this.my_updates.remove(instance);
        if (my_update != null) {
            my_update.complete(true);
        }
        Update[] updates = instance.getUpdates();
        final PluginInterface updater_plugin = this.plugin_interface.getPluginManager().getPluginInterfaceByClass(UpdaterUpdateChecker.class);
        int i = 0;
        while (i < updates.length) {
            Update update = updates[i];
            Object user_object = update.getUserObject();
            if (user_object != null && user_object == updater_plugin) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Core Patcher: updater update found"));
                }
                update.setRestartRequired(3);
                update.addListener(new UpdateListener(){

                    @Override
                    public void complete(Update update) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Core Patcher: updater update complete"));
                        }
                        CorePatchChecker.this.patch(instance, update, updater_plugin);
                    }

                    @Override
                    public void cancelled(Update update) {
                    }
                });
            }
            ++i;
        }
    }

    protected void patch(UpdateCheckInstance instance, Update updater_update, PluginInterface updater_plugin) {
        block21: {
            try {
                ResourceDownloader rd_log = updater_update.getDownloaders()[0];
                File[] files = new File(updater_plugin.getPluginDirectoryName()).listFiles();
                if (files == null) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Core Patcher: no files in plugin dir!!!"));
                    }
                    return;
                }
                String patch_prefix = "BiglyBT_" + Constants.getBaseVersion() + "_P";
                int highest_p = -1;
                File highest_p_file = null;
                int i = 0;
                while (i < files.length) {
                    String name = files[i].getName();
                    if (name.startsWith(patch_prefix) && name.endsWith(".pat")) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Core Patcher: found patch file '" + name + "'"));
                        }
                        try {
                            int this_p = Integer.parseInt(name.substring(patch_prefix.length(), name.indexOf(".pat")));
                            if (this_p > highest_p) {
                                highest_p = this_p;
                                highest_p_file = files[i];
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    ++i;
                }
                if (CorePatchLevel.getCurrentPatchLevel() >= highest_p) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Core Patcher: no applicable patch found (highest = " + highest_p + ")"));
                    }
                    if (updater_update.getRestartRequired() == 3) {
                        updater_update.setRestartRequired(1);
                    }
                    break block21;
                }
                rd_log.reportActivity("Applying patch '" + highest_p_file.getName() + "'");
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Core Patcher: applying patch '" + highest_p_file.toString() + "'"));
                }
                FileInputStream pis = new FileInputStream(highest_p_file);
                try {
                    CorePatchChecker.patchBiglyBT(instance, pis, "P" + highest_p, this.plugin_interface.getLogger().getChannel("CorePatcher"));
                    Logger.log(new LogAlert(false, 0, "Patch " + highest_p_file.getName() + " ready to be applied"));
                    String done_file = highest_p_file.toString();
                    done_file = String.valueOf(done_file.substring(0, done_file.length() - 1)) + "x";
                    highest_p_file.renameTo(new File(done_file));
                    updater_update.setRestartRequired(2);
                }
                finally {
                    try {
                        ((InputStream)pis).close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                Logger.log(new LogAlert(false, "Core Patcher failed", e));
            }
        }
    }

    public static void patchBiglyBT(UpdateCheckInstance instance, InputStream pis, String resource_tag, LoggerChannel log) throws Exception {
        OutputStream os = null;
        InputStream is = null;
        try {
            String resource_name = "BiglyBT_" + resource_tag + ".jar";
            UpdateInstaller installer = instance.createInstaller();
            File tmp = AETemporaryFileHandler.createTempFile();
            os = new FileOutputStream(tmp);
            String jarPath = installer.getInstallDir();
            File jarFile = new File(jarPath, "BiglyBT.jar");
            is = new FileInputStream(jarFile);
            new UpdateJarPatcher(is, pis, os, log);
            is.close();
            is = null;
            pis.close();
            pis = null;
            os.close();
            os = null;
            installer.addResource(resource_name, new FileInputStream(tmp));
            tmp.delete();
            installer.addMoveAction(resource_name, jarFile.getAbsolutePath());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Throwable throwable) {}
            }
            if (pis != null) {
                try {
                    pis.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

