/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.telnet;

import com.biglybt.ui.console.UserProfile;
import com.biglybt.ui.console.multiuser.UserManager;
import com.biglybt.ui.telnet.UI;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Set;

final class SocketServer
implements Runnable {
    private final ServerSocket serverSocket;
    private final Set allowedHosts;
    private final int maxLoginAttempts;
    private final UserManager userManager;
    private final UI ui;

    public SocketServer(UI ui, int port, Set allowedHosts, UserManager userManager, int maxLoginAttempts) throws IOException {
        this.ui = ui;
        this.allowedHosts = allowedHosts;
        this.userManager = userManager;
        this.serverSocket = new ServerSocket(port);
        this.maxLoginAttempts = maxLoginAttempts;
    }

    @Override
    public void run() {
        int threadNum = 1;
        System.out.println("Telnet server started. Listening on port: " + this.serverSocket.getLocalPort());
        try {
            block2: while (true) {
                Socket socket;
                InetSocketAddress addr;
                if ((addr = (InetSocketAddress)(socket = this.serverSocket.accept()).getRemoteSocketAddress()).isUnresolved() || !this.isAllowed(addr)) {
                    System.out.println("TelnetUI: rejecting connection from: " + addr + " as address is not allowed");
                    socket.close();
                    continue;
                }
                System.out.println("TelnetUI: accepting connection from: " + addr);
                int loginAttempts = 0;
                do {
                    UserProfile profile;
                    if ((profile = this.login(socket.getInputStream(), socket.getOutputStream())) == null) continue;
                    this.ui.createNewConsoleInput("Telnet Console " + threadNum++, socket.getInputStream(), new PrintStream(socket.getOutputStream()), profile);
                    continue block2;
                } while (++loginAttempts < this.maxLoginAttempts);
                System.out.println("TelnetUI: rejecting connection from: " + addr + " as number of failed connections > max login attempts (" + this.maxLoginAttempts + ")");
                socket.close();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
    }

    private UserProfile login(InputStream in, OutputStream out) throws IOException {
        if (this.userManager == null) {
            return UserProfile.DEFAULT_USER_PROFILE;
        }
        PrintStream ps = new PrintStream(out);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        ps.print("Username: ");
        String username = br.readLine();
        ps.print("Password: ");
        String password = br.readLine();
        UserProfile userProfile = this.userManager.authenticate(username, password);
        if (userProfile != null) {
            ps.println("Login successful");
            return userProfile;
        }
        ps.println("Login failed");
        return null;
    }

    private boolean isAllowed(InetSocketAddress addr) {
        InetAddress address = addr.getAddress();
        if (this.checkHost(address.getHostAddress())) {
            return true;
        }
        return this.checkHost(address.getHostName());
    }

    private boolean checkHost(String hostName) {
        if (hostName == null) {
            return false;
        }
        hostName = hostName.toLowerCase();
        for (String allowedHost : this.allowedHosts) {
            if (!hostName.equals(allowedHost)) continue;
            return true;
        }
        return false;
    }
}

