/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.wizard;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.wizard.IWizardPanel;
import com.biglybt.ui.swt.wizard.WizardListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Wizard {
    private static final int DEFAULT_WIDTH = 500;
    List<WizardListener> listeners = new ArrayList<WizardListener>(1);
    private final String wizardKey;
    private final boolean hasShellMetrics;
    Display display;
    Shell wizardWindow;
    Label title;
    Label currentInfo;
    Label errorMessage;
    IWizardPanel<?> currentPanel;
    Composite panel;
    Font titleFont;
    protected Button previous;
    protected Button next;
    protected Button finish;
    protected Button cancel;
    Listener closeCatcher;
    int wizardHeight;
    private boolean completed;

    public Wizard(String keyTitle) {
        this(keyTitle, false);
    }

    public Wizard(String keyTitle, boolean modal) {
        this(keyTitle, modal, 500);
    }

    public Wizard(String keyTitle, boolean modal, int width) {
        this.wizardKey = "Wizard.shell:" + keyTitle;
        int style = 2160;
        if (modal) {
            style |= 0x10000;
        }
        this.wizardWindow = ShellFactory.createMainShell(style);
        this.display = this.wizardWindow.getDisplay();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.wizardWindow.setLayout((Layout)layout);
        Utils.setShellIcon(this.wizardWindow);
        Messages.setLanguageText((Widget)this.wizardWindow, keyTitle);
        this.hasShellMetrics = Utils.hasShellMetricsConfig(this.wizardKey);
        Utils.linkShellMetricsToConfig(this.wizardWindow, this.wizardKey);
        Composite cTitle = new Composite((Composite)this.wizardWindow, 0);
        Color bg = Utils.isDarkAppearanceNative() ? null : Colors.getSystemColor((Device)this.display, 1);
        cTitle.setBackground(bg);
        GridData gridData = new GridData(768);
        cTitle.setLayoutData((Object)gridData);
        GridLayout titleLayout = new GridLayout();
        titleLayout.numColumns = 1;
        cTitle.setLayout((Layout)titleLayout);
        this.title = new Label(cTitle, 0);
        this.title.setBackground(bg);
        gridData = new GridData(768);
        this.title.setLayoutData((Object)gridData);
        Font font = this.title.getFont();
        FontData[] data = font.getFontData();
        int i = 0;
        while (i < data.length) {
            data[i].setStyle(1);
            ++i;
        }
        this.titleFont = new Font((Device)this.display, data);
        this.title.setFont(this.titleFont);
        this.currentInfo = new Label(cTitle, 64);
        gridData = Utils.getWrappableLabelGridData(1, 768);
        this.currentInfo.setLayoutData((Object)gridData);
        this.currentInfo.setBackground(bg);
        this.errorMessage = new Label(cTitle, 0);
        gridData = new GridData(768);
        this.errorMessage.setLayoutData((Object)gridData);
        this.errorMessage.setBackground(bg);
        Color red = Colors.getSystemColor((Device)this.display, 3);
        this.errorMessage.setForeground(red);
        gridData = new GridData(768);
        Utils.createSkinnedLabelSeparator((Composite)this.wizardWindow, 256).setLayoutData((Object)gridData);
        this.panel = new Composite((Composite)this.wizardWindow, 0);
        gridData = new GridData(1808);
        this.panel.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        Utils.createSkinnedLabelSeparator((Composite)this.wizardWindow, 256).setLayoutData((Object)gridData);
        Composite cButtons = new Composite((Composite)this.wizardWindow, 0);
        gridData = new GridData(768);
        cButtons.setLayoutData((Object)gridData);
        GridLayout layoutButtons = new GridLayout();
        layoutButtons.numColumns = 5;
        cButtons.setLayout((Layout)layoutButtons);
        gridData = new GridData(768);
        new Label(cButtons, 0).setLayoutData((Object)gridData);
        this.cancel = new Button(cButtons, 8);
        gridData = new GridData();
        gridData.widthHint = 90;
        gridData.horizontalAlignment = 2;
        this.cancel.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.cancel, "Button.cancel");
        this.previous = new Button(cButtons, 8);
        gridData = new GridData();
        gridData.widthHint = 90;
        gridData.horizontalAlignment = 3;
        this.previous.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.previous, "wizard.previous");
        this.next = new Button(cButtons, 8);
        gridData = new GridData();
        gridData.widthHint = 90;
        gridData.horizontalAlignment = 1;
        this.next.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.next, "wizard.next");
        this.finish = new Button(cButtons, 8);
        gridData = new GridData();
        gridData.widthHint = 90;
        gridData.horizontalAlignment = 2;
        this.finish.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.finish, "wizard.finish");
        this.previous.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                Wizard.this.clearPanel();
                Wizard.this.currentPanel = Wizard.this.currentPanel.getPreviousPanel();
                Wizard.this.refresh();
            }
        });
        this.next.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                IWizardPanel<?> nextPanel = Wizard.this.currentPanel.getNextPanel();
                Wizard.this.clearPanel();
                Wizard.this.currentPanel = nextPanel;
                Wizard.this.refresh();
            }
        });
        this.closeCatcher = new Listener(){

            public void handleEvent(Event event2) {
                event2.doit = false;
            }
        };
        this.finish.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                Wizard.this.finishSelected();
            }
        });
        this.cancel.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                Wizard.this.cancelSelected();
            }
        });
        this.wizardWindow.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent de) {
                Wizard.this.onClose();
            }
        });
        this.wizardWindow.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b' && Wizard.this.cancel.isEnabled()) {
                    Wizard.this.wizardWindow.dispose();
                }
            }
        });
        if (!this.hasShellMetrics) {
            this.wizardHeight = this.wizardWindow.computeSize((int)width, (int)-1).y - 50;
            this.wizardWindow.setSize(width, 400);
        }
    }

    private void cancelSelected() {
        this.completed = true;
        if (this.currentPanel != null) {
            this.currentPanel.cancelled();
        }
        this.wizardWindow.dispose();
    }

    private void finishSelected() {
        if (this.currentPanel.isFinishSelectionOK()) {
            this.completed = true;
            this.wizardWindow.addListener(21, this.closeCatcher);
            this.clearPanel();
            this.currentPanel = this.currentPanel.getFinishPanel();
            this.refresh();
            this.currentPanel.finish();
        }
    }

    private void clearPanel() {
        if (this.panel.isDisposed()) {
            return;
        }
        Control[] controls = this.panel.getChildren();
        int i = 0;
        while (i < controls.length) {
            if (controls[i] != null && !controls[i].isDisposed()) {
                controls[i].dispose();
            }
            ++i;
        }
        this.setTitle("");
        this.setCurrentInfo("");
    }

    private void refresh() {
        if (this.currentPanel == null) {
            this.setDefaultButton();
            return;
        }
        this.previous.setEnabled(this.currentPanel.isPreviousEnabled());
        this.next.setEnabled(this.currentPanel.isNextEnabled());
        this.finish.setEnabled(this.currentPanel.isFinishEnabled());
        this.setDefaultButton();
        this.currentPanel.show();
        this.panel.layout();
        this.panel.redraw();
        this.ensureSize();
    }

    private void setDefaultButton() {
        if (!this.wizardWindow.isDisposed()) {
            this.display.asyncExec((Runnable)new AERunnable(){

                @Override
                public void runSupport() {
                    if (!Wizard.this.wizardWindow.isDisposed()) {
                        Button default_button = null;
                        if (Wizard.this.next.isEnabled()) {
                            default_button = Wizard.this.next;
                        } else if (Wizard.this.finish.isEnabled()) {
                            default_button = Wizard.this.finish;
                        } else if (Wizard.this.previous.isEnabled()) {
                            default_button = Wizard.this.previous;
                        } else if (Wizard.this.cancel.isEnabled()) {
                            default_button = Wizard.this.cancel;
                        }
                        if (default_button != null) {
                            Wizard.this.wizardWindow.setDefaultButton(default_button);
                        }
                    }
                }
            });
        }
    }

    public Composite getPanel() {
        return this.panel;
    }

    public void setTitle(String title) {
        this.title.setText(title);
    }

    public void setTitleAsResourceID(String id) {
        Messages.setLanguageText((Widget)this.title, id);
    }

    public void setCurrentInfo(String currentInfo) {
        currentInfo = currentInfo.replaceAll("\n", "\n\t");
        this.currentInfo.setText("\t" + currentInfo);
        this.currentInfo.getParent().layout();
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage.setText(errorMessage);
    }

    public void setNextEnabled(boolean enabled) {
        this.next.setEnabled(enabled);
        this.setDefaultButton();
    }

    public void setPreviousEnabled(boolean enabled) {
        this.previous.setEnabled(enabled);
        this.setDefaultButton();
    }

    public void setFinishEnabled(boolean enabled) {
        this.finish.setEnabled(enabled);
        this.setDefaultButton();
    }

    public void setFirstPanel(IWizardPanel<?> panel) {
        this.currentPanel = panel;
        this.refresh();
        this.ensureSize();
        if (!this.hasShellMetrics) {
            Utils.centreWindow(this.wizardWindow);
        }
        this.wizardWindow.open();
    }

    public Shell getWizardWindow() {
        return this.wizardWindow;
    }

    public String getErrorMessage() {
        return this.errorMessage.getText();
    }

    public Display getDisplay() {
        return this.display;
    }

    public void switchToClose() {
        this.switchToClose(null);
    }

    public void switchToClose(final Runnable do_it) {
        if (!this.wizardWindow.isDisposed()) {
            this.display.asyncExec((Runnable)new AERunnable(){

                @Override
                public void runSupport() {
                    if (Wizard.this.closeCatcher != null && Wizard.this.wizardWindow != null && !Wizard.this.wizardWindow.isDisposed()) {
                        Wizard.this.wizardWindow.removeListener(21, Wizard.this.closeCatcher);
                        Wizard.this.cancel.setText(MessageText.getString("wizard.close"));
                        Wizard.this.cancel.setEnabled(true);
                        Wizard.this.setDefaultButton();
                        if (do_it != null) {
                            do_it.run();
                        }
                    }
                }
            });
        }
    }

    public void close() {
        this.completed = true;
        if (!this.wizardWindow.isDisposed()) {
            this.wizardWindow.dispose();
        }
    }

    public void onClose() {
        if (this.titleFont != null && !this.titleFont.isDisposed()) {
            this.titleFont.dispose();
            this.titleFont = null;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).closed();
            ++i;
        }
        if (!this.completed) {
            this.completed = true;
            if (this.currentPanel != null) {
                this.currentPanel.cancelled();
            }
        }
    }

    public IWizardPanel<?> getCurrentPanel() {
        return this.currentPanel;
    }

    private void ensureSize() {
        if (!this.hasShellMetrics) {
            Point p = this.panel.computeSize(this.wizardWindow.getSize().x, -1);
            int height = p.y + this.wizardHeight;
            if (height > this.wizardWindow.getSize().y) {
                this.wizardWindow.setSize(p.x, height);
            }
        }
    }

    public void addListener(WizardListener l) {
        if (this.wizardWindow.isDisposed() && this.closeCatcher != null) {
            l.closed();
        }
        this.listeners.add(l);
    }

    public void removeListener(WizardListener l) {
        this.listeners.remove(l);
    }
}

