/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.widgets;

import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.utils.ColorCache;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class TabFolderRenderer
extends CTabFolderRenderer {
    private static final int PADDING_BUBBLE_X = 5;
    private static final int PADDING_INDICATOR_X1 = 5;
    private static final int PADDING_INDICATOR_AND_CLOSE = 5;
    private final CTabFolder tabFolder;
    private final Adapter provider;

    public TabFolderRenderer(CTabFolder _tabFolder, Adapter _provider) {
        super(_tabFolder);
        this.tabFolder = _tabFolder;
        this.provider = _provider;
        this.tabFolder.setRenderer((CTabFolderRenderer)this);
    }

    protected Point computeSize(int part, int state, GC gc, int wHint, int hHint) {
        gc.setAntialias(1);
        Point pt = super.computeSize(part, state, gc, wHint, hHint);
        if (this.tabFolder.isDisposed()) {
            return pt;
        }
        if (part < 0 || part >= this.tabFolder.getItemCount()) {
            return pt;
        }
        CTabItem item = this.tabFolder.getItem(part);
        if (item == null) {
            return pt;
        }
        TabbedEntry entry = this.provider.getTabbedEntryFromTabItem(item);
        if (entry == null) {
            return pt;
        }
        int ourWidth = 0;
        ViewTitleInfo viewTitleInfo = entry.getTabbedEntryViewTitleInfo();
        if (viewTitleInfo != null) {
            Object titleRight = viewTitleInfo.getTitleInfoProperty(0);
            if (titleRight != null) {
                String textIndicator = titleRight.toString();
                item.setData("textIndicator", (Object)textIndicator);
                Point size = gc.textExtent(textIndicator, 0);
                ourWidth += size.x + 10 + 5;
            } else {
                item.setData("textIndicator", null);
            }
        } else {
            item.setData("textIndicator", null);
        }
        boolean showUnselectedClose = this.tabFolder.getUnselectedCloseVisible();
        boolean selected = (state & 2) != 0;
        boolean parentHasClose = (this.tabFolder.getStyle() & 0x40) != 0;
        boolean showingClose = !(!parentHasClose && !item.getShowClose() || !showUnselectedClose && !selected);
        List<TabbedEntryVitalityImage> vitalityImages = entry.getTabbedEntryVitalityImages();
        boolean first = true;
        for (TabbedEntryVitalityImage vitalityImage : vitalityImages) {
            Image image;
            if (vitalityImage == null || !vitalityImage.isVisible() || vitalityImage.getAlignment() != 131072 || vitalityImage.getShowOutsideOfEntry() || !selected && vitalityImage.getShowOnlyOnSelection() || !ImageLoader.isRealImage(image = vitalityImage.getImage())) continue;
            ourWidth += image.getBounds().width;
            if (first && !vitalityImage.getAlwaysLast()) {
                first = false;
            }
            ourWidth += 5;
        }
        if (!selected) {
            ourWidth += 5;
        }
        pt.x += ourWidth;
        return pt;
    }

    protected Rectangle computeTrim(int part, int state, int x, int y, int width, int height) {
        Rectangle trim = super.computeTrim(part, state, x, y, width, height);
        if (part < 0 || part >= this.tabFolder.getItemCount()) {
            return trim;
        }
        CTabItem item = this.tabFolder.getItem(part);
        if (item != null && item.getImage() == null) {
            trim.x -= 5;
            trim.width += 5;
        }
        return trim;
    }

    protected void draw(int part, int state, Rectangle bounds, GC gc) {
        block45: {
            if (part < 0 || part >= this.tabFolder.getItemCount()) {
                try {
                    super.draw(part, state, bounds, gc);
                }
                catch (Throwable t) {
                    Debug.out(t);
                }
                return;
            }
            try {
                super.draw(part, state & 0xFFFFFFEF, bounds, gc);
            }
            catch (Throwable t) {
                Debug.out(t);
            }
            if (bounds.width == 0 || bounds.height == 0) {
                return;
            }
            try {
                CTabItem item = this.tabFolder.getItem(part);
                if (item == null) {
                    return;
                }
                TabbedEntry entry_maybe_null = this.provider.getTabbedEntryFromTabItem(item);
                int x2 = bounds.x + bounds.width;
                boolean showUnselectedClose = this.tabFolder.getUnselectedCloseVisible();
                boolean selected = (state & 2) != 0;
                boolean parentHasClose = (this.tabFolder.getStyle() & 0x40) != 0;
                boolean showingClose = !(!parentHasClose && !item.getShowClose() || !showUnselectedClose && !selected);
                Rectangle closeRect = null;
                int closeImageState = 0;
                if (showingClose) {
                    try {
                        Field fldCloseRect = CTabItem.class.getDeclaredField("closeRect");
                        fldCloseRect.setAccessible(true);
                        closeRect = (Rectangle)fldCloseRect.get(item);
                        if (item.getShowClose() && closeRect != null && closeRect.x > 0) {
                            x2 = closeRect.x;
                        }
                        Field fldCloseImageState = CTabItem.class.getDeclaredField("closeImageState");
                        fldCloseImageState.setAccessible(true);
                        closeImageState = (Integer)fldCloseImageState.get(item);
                    }
                    catch (Throwable t) {
                        x2 -= 20;
                    }
                } else {
                    x2 -= 5;
                }
                int oldAntiAlias = gc.getAntialias();
                boolean oldAdvanced = gc.getAdvanced();
                try {
                    gc.setAdvanced(true);
                    gc.setAntialias(1);
                    if (entry_maybe_null != null) {
                        String textIndicator;
                        int startX;
                        List<TabbedEntryVitalityImage> vitalityImages = entry_maybe_null.getTabbedEntryVitalityImages();
                        Collections.reverse(vitalityImages);
                        boolean first = true;
                        for (TabbedEntryVitalityImage vitalityImage : vitalityImages) {
                            if (vitalityImage == null || !vitalityImage.isVisible() || vitalityImage.getAlignment() != 131072 || vitalityImage.getShowOutsideOfEntry()) continue;
                            if (!selected && vitalityImage.getShowOnlyOnSelection()) {
                                vitalityImage.setHitArea(null);
                                continue;
                            }
                            vitalityImage.switchSuffix(entry_maybe_null.isTabbedEntryActive() ? "-selected" : "");
                            Image image = vitalityImage.getImage();
                            if (image == null || image.isDisposed()) continue;
                            Rectangle imageBounds = image.getBounds();
                            startX = x2 - imageBounds.width;
                            int startY = bounds.y + (bounds.height - imageBounds.height) / 2 + 1;
                            if (first && !vitalityImage.getAlwaysLast()) {
                                first = false;
                            }
                            gc.drawImage(image, startX, startY);
                            vitalityImage.setHitArea(new Rectangle(startX, startY, imageBounds.width, imageBounds.height));
                            x2 = startX;
                            x2 -= 5;
                        }
                        ViewTitleInfo viewTitleInfo = entry_maybe_null.getTabbedEntryViewTitleInfo();
                        if (viewTitleInfo != null && (textIndicator = (String)item.getData("textIndicator")) != null) {
                            Point textSize = gc.textExtent(textIndicator, 0);
                            int width = textSize.x + 10 + 5;
                            startX = x2 - width;
                            if (first) {
                                startX -= 5;
                                first = false;
                            }
                            int textOffsetY = 0;
                            int height = textSize.y + 1;
                            int startY = bounds.y + (bounds.height - height) / 2 + 1;
                            Color default_color = ColorCache.getSchemedColor(gc.getDevice(), "#5b6e87");
                            Object color = viewTitleInfo.getTitleInfoProperty(8);
                            if (color instanceof int[]) {
                                gc.setBackground(ColorCache.getColor(gc.getDevice(), (int[])color));
                            } else {
                                gc.setBackground(default_color);
                            }
                            Color text_color = Colors.white;
                            int bubbleStartX = startX + 5;
                            int bubbleStartY = startY;
                            int bubbleWidth = width - 5;
                            gc.fillRoundRectangle(bubbleStartX, bubbleStartY, bubbleWidth, height, textSize.y * 2 / 3, height * 2 / 3);
                            if (color != null) {
                                text_color = Colors.getInstance().getReadableColor(gc.getBackground());
                                gc.setBackground(default_color);
                                gc.drawRoundRectangle(bubbleStartX, bubbleStartY, bubbleWidth, height, textSize.y * 2 / 3, height * 2 / 3);
                            }
                            gc.setForeground(text_color);
                            GCStringPrinter.printString(gc, textIndicator, new Rectangle(bubbleStartX, bubbleStartY + textOffsetY, bubbleWidth, height), true, false, 0x1000000);
                            x2 = startX;
                        }
                    }
                    if ((state & 0x10) == 0) break block45;
                    Rectangle trim = this.computeTrim(part, 0, 0, 0, 0, 0);
                    int xDraw = bounds.x - trim.x;
                    Image image = item.getImage();
                    if (image != null && !image.isDisposed() && this.tabFolder.getUnselectedImageVisible()) {
                        Rectangle imageBounds = image.getBounds();
                        int maxImageWidth = bounds.x + bounds.width - xDraw - (trim.width + trim.x);
                        if (showingClose && closeRect != null) {
                            maxImageWidth -= closeRect.width + 4;
                        }
                        if (imageBounds.width < maxImageWidth) {
                            int imageX = xDraw;
                            int imageHeight = imageBounds.height;
                            int imageY = bounds.y + (bounds.height - imageHeight) / 2;
                            boolean onBottom = (this.tabFolder.getStyle() & 0x400) != 0;
                            int n = onBottom ? -1 : 1;
                            int imageWidth = imageBounds.width * imageHeight / imageBounds.height;
                            gc.drawImage(image, imageBounds.x, imageBounds.y, imageBounds.width, imageBounds.height, imageX, imageY += n, imageWidth, imageHeight);
                            xDraw += imageWidth + 4;
                        }
                    }
                    if (showingClose) {
                        if (closeImageState == 0 && Utils.isDarkAppearanceNative() && Constants.isOSX) {
                            Image img = new Image(gc.getDevice(), closeRect);
                            GC gcImg = new GC((Drawable)img);
                            gcImg.setBackground(Colors.black);
                            gcImg.fillRectangle(0, 0, closeRect.width, closeRect.height);
                            try {
                                Method methDrawClose = CTabFolderRenderer.class.getDeclaredMethod("drawClose", GC.class, Rectangle.class, Integer.TYPE);
                                methDrawClose.setAccessible(true);
                                methDrawClose.invoke((Object)this, gcImg, new Rectangle(0, 0, closeRect.width, closeRect.height), closeImageState);
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            ImageData idata = img.getImageData();
                            PaletteData pdata = idata.palette;
                            int redMask = pdata.redMask;
                            int greenMask = pdata.greenMask;
                            int blueMask = pdata.blueMask;
                            int redShift = pdata.redShift;
                            int greenShift = pdata.greenShift;
                            int blueShift = pdata.blueShift;
                            int i = 0;
                            while (i < closeRect.width) {
                                int j = 0;
                                while (j < closeRect.height) {
                                    int pixel = idata.getPixel(i, j);
                                    int red = pixel & redMask;
                                    red = redShift < 0 ? red >>> -redShift : red << redShift;
                                    int green = pixel & greenMask;
                                    green = greenShift < 0 ? green >>> -greenShift : green << greenShift;
                                    int blue = pixel & blueMask;
                                    blue = blueShift < 0 ? blue >>> -blueShift : blue << blueShift;
                                    int rgb = red << 16 | green << 8 | blue;
                                    if (rgb != 0) {
                                        Color c = new Color(gc.getDevice(), new RGB(red + 75, green + 75, blue + 75));
                                        gc.setForeground(c);
                                        gc.drawPoint(closeRect.x + i, closeRect.y + j);
                                        c.dispose();
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                            gcImg.dispose();
                            img.dispose();
                        } else if (closeImageState == 0 && Utils.isDarkAppearanceNative() && Constants.isLinux) {
                            ImageLoader imageLoader = ImageLoader.getInstance();
                            Image img = imageLoader.getImage("image.tabfolder.close.up._dark");
                            Rectangle b = img.getBounds();
                            gc.drawImage(img, closeRect.x + (closeRect.width - b.width) / 2, closeRect.y + 1 + (closeRect.height - b.height) / 2);
                            imageLoader.releaseImage("image.tabfolder.close.up._dark");
                        } else {
                            try {
                                Method methDrawClose = CTabFolderRenderer.class.getDeclaredMethod("drawClose", GC.class, Rectangle.class, Integer.TYPE);
                                methDrawClose.setAccessible(true);
                                methDrawClose.invoke((Object)this, gc, closeRect, closeImageState);
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                    }
                    Rectangle printArea = new Rectangle(xDraw, bounds.y + 1, x2 - xDraw + 1, bounds.height);
                    gc.setForeground(selected ? this.tabFolder.getSelectionForeground() : this.tabFolder.getForeground());
                    Font gcFont = gc.getFont();
                    gc.setFont(item.getFont() == null ? this.tabFolder.getFont() : item.getFont());
                    GCStringPrinter sp = new GCStringPrinter(gc, item.getText(), printArea, false, true, 0);
                    sp.printString();
                    gc.setFont(gcFont);
                    if (this.tabFolder.isFocusControl() && selected) {
                        Display display = this.tabFolder.getDisplay();
                        if (this.tabFolder.getSimple() || this.tabFolder.getSingle()) {
                            Rectangle drawRect = sp.getCalculatedDrawRect();
                            if (drawRect != null) {
                                gc.setBackground(Colors.getSystemColor((Device)display, 2));
                                gc.setForeground(Colors.getSystemColor((Device)display, 1));
                                gc.drawFocus(drawRect.x - 1, drawRect.y - 1, drawRect.width + 2, drawRect.height + 2);
                            }
                        } else {
                            gc.setForeground(display.getSystemColor(17));
                            int lineY = this.tabFolder.getTabHeight();
                            int lineX2 = xDraw + sp.getCalculatedSize().x + 1;
                            gc.drawLine(xDraw, lineY, lineX2, lineY);
                        }
                    }
                }
                finally {
                    gc.setAntialias(oldAntiAlias);
                    gc.setAdvanced(oldAdvanced);
                }
            }
            catch (Throwable t) {
                Debug.out(t);
            }
        }
    }

    public void redraw(TabbedEntry entry) {
        this.redraw(entry.getTabbedEntryItem());
    }

    public void redraw(int index) {
        CTabItem[] items = this.tabFolder.getItems();
        if (index > 0 && index < items.length) {
            this.redraw(items[index]);
        }
    }

    public void redraw(CTabItem item) {
        Utils.execSWTThread(() -> {
            if (item == null || item.isDisposed()) {
                return;
            }
            Rectangle bounds = item.getBounds();
            GC gc = new GC((Drawable)this.parent);
            Point point = this.computeSize(this.parent.indexOf(item), this.parent.getSelection() == item ? 2 : 0, gc, -1, -1);
            gc.dispose();
            if (point.x != bounds.width) {
                this.parent.notifyListeners(11, new Event());
            } else {
                this.parent.redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
            }
        });
    }

    public static interface Adapter {
        public TabbedEntry getTabbedEntryFromTabItem(CTabItem var1);
    }

    public static interface TabbedEntry {
        public CTabItem getTabbedEntryItem();

        public ViewTitleInfo getTabbedEntryViewTitleInfo();

        public List<TabbedEntryVitalityImage> getTabbedEntryVitalityImages();

        public boolean isTabbedEntryActive();
    }

    public static interface TabbedEntryVitalityImage {
        public boolean isVisible();

        public Image getImage();

        public void setHitArea(Rectangle var1);

        public void switchSuffix(String var1);

        public int getAlignment();

        public boolean getShowOnlyOnSelection();

        public boolean getAlwaysLast();

        public boolean getShowOutsideOfEntry();
    }
}

