/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.utils;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.category.Category;
import com.biglybt.core.category.CategoryManager;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.plugin.net.buddy.BuddyPlugin;
import com.biglybt.plugin.net.buddy.BuddyPluginBuddy;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.views.ViewUtils;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import com.biglybt.ui.swt.views.utils.TagUIUtils;
import com.biglybt.ui.swt.views.utils.TrancodeUIUtils;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class CategoryUIUtils {
    public static void setupCategoryMenu(final Menu menu, final Category category, final Predicate<Taggable> filter2) {
        menu.addMenuListener(new MenuListener(){
            boolean bShown = false;

            public void menuHidden(MenuEvent e) {
                this.bShown = false;
                if (Constants.isOSX || e.display == null) {
                    return;
                }
                e.display.asyncExec((Runnable)new AERunnable(){

                    @Override
                    public void runSupport() {
                        if (bShown || menu.isDisposed()) {
                            return;
                        }
                        Utils.disposeSWTObjects(menu.getItems());
                    }
                });
            }

            public void menuShown(MenuEvent e) {
                Utils.disposeSWTObjects(menu.getItems());
                this.bShown = true;
                CategoryUIUtils.createMenuItems(menu, category, filter2);
            }
        });
    }

    public static void createMenuItems(Menu menu, Category category) {
        CategoryUIUtils.createMenuItems(menu, category, dm -> true);
    }

    private static List<DownloadManager> getDownloads(Category category, Predicate<Taggable> filter2) {
        GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
        List<DownloadManager> managers = category.getDownloadManagers(gm.getDownloadManagers());
        return managers.stream().filter(filter2).collect(Collectors.toList());
    }

    public static void createMenuItems(Menu menu, final Category category, final Predicate<Taggable> filter2) {
        TrancodeUIUtils.TranscodeTarget[] tts;
        BuddyPlugin buddy_plugin;
        if (category.getType() == 0) {
            MenuItem itemDelete = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemDelete, "MyTorrentsView.menu.category.delete");
            itemDelete.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    List dms = CategoryUIUtils.getDownloads(category, filter2);
                    for (DownloadManager dm : dms) {
                        DownloadManagerState state = dm.getDownloadState();
                        if (state == null) continue;
                        state.setCategory(null);
                    }
                    CategoryManager.removeCategory(category);
                }
            });
        }
        if (category.getType() != 1) {
            long kInB = DisplayFormatters.getKinB();
            long maxDownload = (long)COConfigurationManager.getIntParameter("Max Download Speed KBs", 0) * kInB;
            long maxUpload = (long)COConfigurationManager.getIntParameter("Max Upload Speed KBs", 0) * kInB;
            int down_speed = category.getDownloadSpeed();
            int up_speed = category.getUploadSpeed();
            ViewUtils.addSpeedMenu(menu.getShell(), menu, true, true, true, true, false, down_speed == 0, down_speed, down_speed, maxDownload, false, up_speed == 0, up_speed, up_speed, maxUpload, 1, null, new ViewUtils.SpeedAdapter(){

                @Override
                public void setDownSpeed(int val) {
                    category.setDownloadSpeed(val);
                }

                @Override
                public void setUpSpeed(int val) {
                    category.setUploadSpeed(val);
                }
            });
        }
        final List<DownloadManager> dms = CategoryUIUtils.getDownloads(category, filter2);
        boolean start = false;
        boolean stop = false;
        for (DownloadManager dm : dms) {
            stop = stop || ManagerUtils.isStopable(dm);
            boolean bl = start = start || ManagerUtils.isStartable(dm);
        }
        MenuItem itemQueue = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemQueue, "MyTorrentsView.menu.queue");
        Utils.setMenuItemImage(itemQueue, "start");
        itemQueue.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                List dms = CategoryUIUtils.getDownloads(category, filter2);
                TorrentUtil.queueDataSources(dms.toArray(), false);
            }
        });
        itemQueue.setEnabled(start);
        MenuItem itemStop = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemStop, "MyTorrentsView.menu.stop");
        Utils.setMenuItemImage(itemStop, "stop");
        itemStop.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                List dms = CategoryUIUtils.getDownloads(category, filter2);
                TorrentUtil.stopDataSources(dms.toArray());
            }
        });
        itemStop.setEnabled(stop);
        if (category.canBePublic()) {
            new MenuItem(menu, 2);
            final MenuItem itemPublic = new MenuItem(menu, 32);
            itemPublic.setSelection(category.isPublic());
            Messages.setLanguageText((Widget)itemPublic, "cat.share");
            itemPublic.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    category.setPublic(itemPublic.getSelection());
                }
            });
        }
        PluginInterface bpi = PluginInitializer.getDefaultInterface().getPluginManager().getPluginInterfaceByClass(BuddyPlugin.class);
        int cat_type = category.getType();
        if (bpi != null && cat_type != 2 && (buddy_plugin = (BuddyPlugin)bpi.getPlugin()).isClassicEnabled()) {
            Menu share_menu = new Menu((Decorations)menu.getShell(), 4);
            MenuItem share_item = new MenuItem(menu, 64);
            Messages.setLanguageText((Widget)share_item, "azbuddy.ui.menu.cat.share");
            share_item.setMenu(share_menu);
            List<BuddyPluginBuddy> buddies = buddy_plugin.getBuddies();
            if (buddies.size() == 0) {
                MenuItem item = new MenuItem(share_menu, 32);
                item.setText(MessageText.getString("general.add.friends"));
                item.setEnabled(false);
            } else {
                final String cname = cat_type == 1 ? "All" : category.getName();
                final boolean is_public = buddy_plugin.isPublicTagOrCategory(cname);
                MenuItem itemPubCat = new MenuItem(share_menu, 32);
                Messages.setLanguageText((Widget)itemPubCat, "general.all.friends");
                itemPubCat.setSelection(is_public);
                itemPubCat.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        if (is_public) {
                            buddy_plugin.removePublicTagOrCategory(cname);
                        } else {
                            buddy_plugin.addPublicTagOrCategory(cname);
                        }
                    }
                });
                new MenuItem(share_menu, 2);
                for (final BuddyPluginBuddy buddy : buddies) {
                    if (buddy.getNickName() == null) continue;
                    final boolean auth = buddy.isLocalRSSTagOrCategoryAuthorised(cname);
                    MenuItem itemShare = new MenuItem(share_menu, 32);
                    itemShare.setText(String.valueOf(buddy.getName()) + (buddy.isPublicNetwork() ? "" : " (" + MessageText.getString("label.anon.medium") + ")"));
                    itemShare.setSelection(auth || is_public);
                    if (is_public) {
                        itemShare.setEnabled(false);
                    }
                    itemShare.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            if (auth) {
                                buddy.removeLocalAuthorisedRSSTagOrCategory(cname);
                            } else {
                                buddy.addLocalAuthorisedRSSTagOrCategory(cname);
                            }
                        }
                    });
                }
            }
        }
        if (category.getType() != 1 && (tts = TrancodeUIUtils.getTranscodeTargets()).length > 0) {
            Menu t_menu = new Menu((Decorations)menu.getShell(), 4);
            MenuItem t_item = new MenuItem(menu, 64);
            Messages.setLanguageText((Widget)t_item, "cat.autoxcode");
            t_item.setMenu(t_menu);
            String existing = category.getStringAttribute("at_att");
            TrancodeUIUtils.TranscodeTarget[] transcodeTargetArray = tts;
            int n = tts.length;
            int n2 = 0;
            while (n2 < n) {
                TrancodeUIUtils.TranscodeTarget tt = transcodeTargetArray[n2];
                TrancodeUIUtils.TranscodeProfile[] profiles = tt.getProfiles();
                if (profiles.length > 0) {
                    Menu tt_menu = new Menu((Decorations)t_menu.getShell(), 4);
                    MenuItem tt_item = new MenuItem(t_menu, 64);
                    tt_item.setText(tt.getName());
                    tt_item.setMenu(tt_menu);
                    TrancodeUIUtils.TranscodeProfile[] transcodeProfileArray = profiles;
                    int n3 = profiles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        boolean selected;
                        final TrancodeUIUtils.TranscodeProfile tp2 = transcodeProfileArray[n4];
                        final MenuItem p_item = new MenuItem(tt_menu, 32);
                        p_item.setText(tp2.getName());
                        boolean bl = selected = existing != null && existing.equals(tp2.getUID());
                        if (selected) {
                            Utils.setMenuItemImage(tt_item, "blacktick");
                        }
                        p_item.setSelection(selected);
                        p_item.addListener(13, new Listener(){

                            public void handleEvent(Event event2) {
                                category.setStringAttribute("at_att", p_item.getSelection() ? tp2.getUID() : null);
                            }
                        });
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        final MenuItem rssOption = new MenuItem(menu, 32);
        rssOption.setSelection(category.getBooleanAttribute("at_rss_gen"));
        Messages.setLanguageText((Widget)rssOption, "cat.rss.gen");
        rssOption.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                boolean set = rssOption.getSelection();
                category.setBooleanAttribute("at_rss_gen", set);
            }
        });
        if (cat_type != 2 && cat_type != 1) {
            final MenuItem upPriority = new MenuItem(menu, 32);
            upPriority.setSelection(category.getIntAttribute("at_up_pri") > 0);
            Messages.setLanguageText((Widget)upPriority, "cat.upload.priority");
            upPriority.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    boolean set = upPriority.getSelection();
                    category.setIntAttribute("at_up_pri", set ? 1 : 0);
                }
            });
        }
        MenuItem itemOptions = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemOptions, "cat.options");
        itemOptions.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                MultipleDocumentInterface mdi;
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null && (mdi = uiFunctions.getMDI()) != null) {
                    mdi.showEntryByID("TorrentOptionsView", dms);
                }
            }
        });
        if (dms.isEmpty()) {
            itemOptions.setEnabled(false);
        }
    }

    public static void showCreateCategoryDialog(final UIFunctions.TagReturner tagReturner) {
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("CategoryAddWindow.title", "CategoryAddWindow.message");
        entryWindow.setParentShell(Utils.findAnyShell());
        entryWindow.prompt(new UIInputReceiverListener(){

            @Override
            public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                if (entryWindow.hasSubmittedInput()) {
                    TagUIUtils.checkTagSharing(false);
                    Category newCategory = CategoryManager.createCategory(entryWindow.getSubmittedInput());
                    if (tagReturner != null) {
                        tagReturner.returnedTags(new Tag[]{newCategory});
                    }
                }
            }
        });
    }
}

